/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.io;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class XMLUtils {
    public static final String LT = "&lt;";
    public static final String GT = "&gt;";
    public static final String QUOT = "&quot;";
    public static final String AMP = "&amp;";
    public static final String APOS = "&apos;";
    public static final String OWL_PROCESSING_INSTRUCTION_NAME = "owl";

    private XMLUtils() {
    }

    public static boolean isXMLNameStartCharacter(int codePoint) {
        return codePoint == 58 || codePoint >= 65 && codePoint <= 90 || codePoint == 95 || codePoint >= 97 && codePoint <= 122 || codePoint >= 192 && codePoint <= 214 || codePoint >= 216 && codePoint <= 246 || codePoint >= 248 && codePoint <= 767 || codePoint >= 880 && codePoint <= 893 || codePoint >= 895 && codePoint <= 8191 || codePoint >= 8204 && codePoint <= 8205 || codePoint >= 8304 && codePoint <= 8591 || codePoint >= 11264 && codePoint <= 12271 || codePoint >= 12289 && codePoint <= 55295 || codePoint >= 63744 && codePoint <= 64975 || codePoint >= 65008 && codePoint <= 65533 || codePoint >= 65536 && codePoint <= 983039;
    }

    public static boolean isXMLNameChar(int codePoint) {
        return XMLUtils.isXMLNameStartCharacter(codePoint) || codePoint == 45 || codePoint == 46 || codePoint >= 48 && codePoint <= 57 || codePoint == 183 || codePoint >= 768 && codePoint <= 879 || codePoint >= 8255 && codePoint <= 8256;
    }

    public static boolean isNCNameStartChar(int codePoint) {
        return codePoint != 58 && XMLUtils.isXMLNameStartCharacter(codePoint);
    }

    public static boolean isNCNameChar(int codePoint) {
        return codePoint != 58 && XMLUtils.isXMLNameChar(codePoint);
    }

    public static boolean isNCName(CharSequence s2) {
        int codePoint;
        if (XMLUtils.isNullOrEmpty(s2)) {
            return false;
        }
        int firstCodePoint = Character.codePointAt(s2, 0);
        if (!XMLUtils.isNCNameStartChar(firstCodePoint)) {
            return false;
        }
        for (int i = Character.charCount(firstCodePoint); i < s2.length(); i += Character.charCount(codePoint)) {
            codePoint = Character.codePointAt(s2, i);
            if (XMLUtils.isNCNameChar(codePoint)) continue;
            return false;
        }
        return true;
    }

    public static boolean isQName(CharSequence s2) {
        return XMLUtils.isQName(s2, 0);
    }

    public static boolean isQName(CharSequence s2, int start) {
        int codePoint;
        if (XMLUtils.isNullOrEmpty(s2) || start >= s2.length()) {
            return false;
        }
        boolean foundColon = false;
        boolean inNCName = false;
        for (int i = start; i < s2.length(); i += Character.charCount(codePoint)) {
            codePoint = Character.codePointAt(s2, i);
            if (codePoint == 58) {
                if (foundColon) {
                    return false;
                }
                foundColon = true;
                if (!inNCName) {
                    return false;
                }
                inNCName = false;
                continue;
            }
            if (!inNCName) {
                if (!XMLUtils.isXMLNameStartCharacter(codePoint)) {
                    return false;
                }
                inNCName = true;
                continue;
            }
            if (XMLUtils.isXMLNameChar(codePoint)) continue;
            return false;
        }
        return true;
    }

    public static boolean hasNCNameSuffix(CharSequence s2) {
        return XMLUtils.getNCNameSuffixIndex(s2) != -1;
    }

    public static int getNCNameSuffixIndex(CharSequence s2) {
        if (s2.length() > 1 && s2.charAt(0) == '_' && s2.charAt(1) == ':') {
            return -1;
        }
        int index = -1;
        for (int i = s2.length() - 1; i > -1; --i) {
            if (Character.isLowSurrogate(s2.charAt(i))) continue;
            int codePoint = Character.codePointAt(s2, i);
            if (XMLUtils.isNCNameStartChar(codePoint)) {
                index = i;
            }
            if (!XMLUtils.isNCNameChar(codePoint)) break;
        }
        return index;
    }

    @Nullable
    public static String getNCNameSuffix(CharSequence s2) {
        if (s2.length() > 1 && s2.charAt(0) == '_' && s2.charAt(1) == ':') {
            return null;
        }
        int localPartStartIndex = XMLUtils.getNCNameSuffixIndex(s2);
        if (localPartStartIndex > -1) {
            return s2.toString().substring(localPartStartIndex);
        }
        return null;
    }

    public static boolean isEmpty(@Nullable CharSequence s2) {
        if (s2 == null || s2.length() == 0) {
            return true;
        }
        return s2.chars().allMatch(Character::isWhitespace);
    }

    @Nonnull
    public static String getNCNamePrefix(CharSequence s2) {
        if (XMLUtils.isEmpty(s2)) {
            return "";
        }
        if (s2.length() > 1 && s2.charAt(0) == '_' && s2.charAt(1) == ':') {
            return s2.toString();
        }
        int localPartStartIndex = XMLUtils.getNCNameSuffixIndex(s2);
        int firstNonBlank = 0;
        while (Character.isWhitespace(s2.charAt(firstNonBlank))) {
            ++firstNonBlank;
        }
        if (localPartStartIndex > -1) {
            return s2.toString().substring(firstNonBlank, localPartStartIndex);
        }
        return s2.toString().substring(firstNonBlank);
    }

    @Nonnull
    public static String escapeXML(CharSequence s2) {
        int codePoint;
        StringBuilder sb = new StringBuilder(s2.length() * 2);
        for (int i = 0; i < s2.length(); i += Character.charCount(codePoint)) {
            codePoint = Character.codePointAt(s2, i);
            if (codePoint == 60) {
                sb.append(LT);
                continue;
            }
            if (codePoint == 62) {
                sb.append(GT);
                continue;
            }
            if (codePoint == 34) {
                sb.append(QUOT);
                continue;
            }
            if (codePoint == 38) {
                sb.append(AMP);
                continue;
            }
            if (codePoint == 39) {
                sb.append(APOS);
                continue;
            }
            sb.appendCodePoint(codePoint);
        }
        return sb.toString();
    }

    public static StringBuilder escapeXML(char[] chars, int start, int count, StringBuilder destination) {
        for (int i = 0; i < count; ++i) {
            char codePoint = chars[start + i];
            if (codePoint == '<') {
                destination.append(LT);
                continue;
            }
            if (codePoint == '>') {
                destination.append(GT);
                continue;
            }
            if (codePoint == '\"') {
                destination.append(QUOT);
                continue;
            }
            if (codePoint == '&') {
                destination.append(AMP);
                continue;
            }
            if (codePoint == '\'') {
                destination.append(APOS);
                continue;
            }
            destination.append(codePoint);
        }
        return destination;
    }

    public static void escapeXML(StringBuilder sb) {
        int i = 0;
        while (i < sb.length()) {
            int codePoint = Character.codePointAt(sb, i);
            int length = Character.charCount(codePoint);
            if (codePoint == 60) {
                sb.replace(i, i + length, LT);
                i += LT.length();
                continue;
            }
            if (codePoint == 62) {
                sb.replace(i, i + length, GT);
                i += GT.length();
                continue;
            }
            if (codePoint == 34) {
                sb.replace(i, i + length, QUOT);
                i += QUOT.length();
                continue;
            }
            if (codePoint == 38) {
                sb.replace(i, i + length, AMP);
                i += AMP.length();
                continue;
            }
            if (codePoint == 39) {
                sb.replace(i, i + length, APOS);
                i += APOS.length();
                continue;
            }
            i += length;
        }
    }

    public static boolean isNullOrEmpty(CharSequence s2) {
        return s2 == null || s2.length() == 0;
    }

    public static String iriWithTerminatingHash(@Nullable String iri) {
        if (iri == null) {
            return "#";
        }
        char c = iri.charAt(iri.length() - 1);
        if (c == '/' || c == '#') {
            return iri;
        }
        if (iri.indexOf(35) > -1) {
            return iri;
        }
        return iri + '#';
    }
}

