/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.metrics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.metrics.OWLMetric;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

public class OWLMetricManager {
    @Nonnull
    private final List<OWLMetric<?>> metrics;

    public OWLMetricManager(@Nonnull List<OWLMetric<?>> metrics) {
        this.metrics = new ArrayList((Collection)OWLAPIPreconditions.checkNotNull(metrics, "metrics cannot be null"));
    }

    public void setOntology(@Nonnull OWLOntology ontology) {
        for (OWLMetric<?> metric : this.metrics) {
            metric.setOntology(ontology);
        }
    }

    @Nonnull
    public List<OWLMetric<?>> getMetrics() {
        return new ArrayList(this.metrics);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (OWLMetric<?> m3 : this.metrics) {
            sb.append(m3);
            sb.append('\n');
        }
        return sb.toString();
    }
}

