/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.rdf.rdfxml.renderer;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.formats.PrefixDocumentFormat;
import org.semanticweb.owlapi.io.XMLUtils;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLNamedObject;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.rdf.rdfxml.renderer.XMLWriterNamespaceManager;
import org.semanticweb.owlapi.util.NamespaceUtil;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.vocab.Namespaces;

public class OWLOntologyXMLNamespaceManager
extends XMLWriterNamespaceManager {
    @Nonnull
    private final OWLOntology ontology;
    @Nonnull
    private final NamespaceUtil namespaceUtil = new NamespaceUtil();
    @Nonnull
    private final OWLDocumentFormat ontologyFormat;

    public OWLOntologyXMLNamespaceManager(@Nonnull OWLOntology ontology, @Nonnull OWLDocumentFormat format) {
        super(OWLOntologyXMLNamespaceManager.getDefaultNamespace(ontology, format));
        this.ontology = OWLAPIPreconditions.checkNotNull(ontology, "ontology cannot be null");
        this.ontologyFormat = OWLAPIPreconditions.checkNotNull(format, "format cannot be null");
        this.addWellKnownNamespace("skos", Namespaces.SKOS.toString());
        this.addWellKnownNamespace("dc", "http://purl.org/dc/elements/1.1/");
        this.processOntology();
    }

    @Nonnull
    protected OWLOntology getOntology() {
        return this.ontology;
    }

    private final void processOntology() {
        if (this.ontologyFormat instanceof PrefixDocumentFormat) {
            PrefixDocumentFormat namespaceFormat = (PrefixDocumentFormat)this.ontologyFormat;
            Map<String, String> namespacesByPrefix = namespaceFormat.getPrefixName2PrefixMap();
            for (String prefixName : namespacesByPrefix.keySet()) {
                String xmlnsPrefixName = prefixName.substring(0, prefixName.length() - 1);
                String xmlnsPrefix = (String)namespacesByPrefix.get(prefixName);
                this.namespaceUtil.setPrefix(OWLAPIPreconditions.verifyNotNull(xmlnsPrefix), OWLAPIPreconditions.verifyNotNull(xmlnsPrefixName));
            }
        }
        if (this.ontology.getAxiomCount(AxiomType.SWRL_RULE) != 0) {
            this.namespaceUtil.setPrefix(Namespaces.SWRL.toString(), "swrl");
            this.namespaceUtil.setPrefix(Namespaces.SWRLB.toString(), "swrlb");
        }
        Set<OWLEntity> entities = this.getEntitiesThatRequireNamespaces();
        for (OWLEntity ent : entities) {
            assert (ent != null);
            this.processEntity(ent);
        }
        Map<String, String> ns2prefixMap = this.namespaceUtil.getNamespace2PrefixMap();
        for (String ns : ns2prefixMap.keySet()) {
            assert (ns != null);
            if (Namespaces.OWL11.inNamespace(ns) || Namespaces.OWL11XML.inNamespace(ns)) continue;
            String prefix = ns2prefixMap.get(ns);
            assert (prefix != null);
            this.setPrefix(prefix, ns);
        }
    }

    @Nonnull
    protected Set<OWLEntity> getEntitiesThatRequireNamespaces() {
        HashSet<OWLEntity> result = new HashSet<OWLEntity>();
        result.addAll(this.ontology.getClassesInSignature());
        result.addAll(this.ontology.getObjectPropertiesInSignature());
        result.addAll(this.ontology.getDataPropertiesInSignature());
        result.addAll(this.ontology.getIndividualsInSignature());
        result.addAll(this.ontology.getAnnotationPropertiesInSignature());
        return result;
    }

    private void processEntity(@Nonnull OWLNamedObject entity) {
        this.processIRI(OWLAPIPreconditions.checkNotNull(entity, "entity cannot be null").getIRI());
    }

    private void processIRI(@Nonnull IRI iri) {
        String ns = OWLAPIPreconditions.checkNotNull(iri, "iri cannot be null").getNamespace();
        if (!ns.isEmpty() && iri.getRemainder().isPresent()) {
            this.namespaceUtil.getPrefix(ns);
        }
    }

    @Nonnull
    private static String getDefaultNamespace(@Nonnull OWLOntology ontology, @Nonnull OWLDocumentFormat format) {
        PrefixDocumentFormat prefixOWLOntologyFormat;
        String defaultPrefix;
        OWLAPIPreconditions.checkNotNull(ontology, "ontology cannot be null");
        OWLAPIPreconditions.checkNotNull(format, "format cannot be null");
        if (format instanceof PrefixDocumentFormat && (defaultPrefix = (prefixOWLOntologyFormat = (PrefixDocumentFormat)format).getDefaultPrefix()) != null) {
            return defaultPrefix;
        }
        if (ontology.getOntologyID().isAnonymous()) {
            return Namespaces.OWL.toString();
        }
        String base = ontology.getOntologyID().getOntologyIRI().get().toString();
        if (!base.endsWith("#") && !base.endsWith("/")) {
            base = base + "#";
        }
        return base;
    }

    @Override
    @Nullable
    public String getQName(String name) {
        OWLAPIPreconditions.checkNotNull(name, "name cannot be null");
        String ns = XMLUtils.getNCNamePrefix(name);
        String fragment = XMLUtils.getNCNameSuffix(name);
        if (ns.equals(this.getDefaultNamespace())) {
            return fragment;
        }
        if (name.startsWith("xmlns") || name.startsWith("xml:")) {
            return name;
        }
        if (ns.isEmpty() || fragment == null || fragment.isEmpty()) {
            return name;
        }
        String prefix = this.getPrefixForNamespace(ns);
        if (prefix != null) {
            if (!prefix.isEmpty()) {
                return prefix + ":" + fragment;
            }
            return fragment;
        }
        return null;
    }
}

