/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.rio;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.eclipse.rdf4j.OpenRDFUtil;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.semanticweb.owlapi.formats.PrefixDocumentFormat;
import org.semanticweb.owlapi.io.RDFResource;
import org.semanticweb.owlapi.io.RDFTriple;
import org.semanticweb.owlapi.io.XMLUtils;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.rdf.RDFRendererBase;
import org.semanticweb.owlapi.rio.utils.RioUtils;
import org.semanticweb.owlapi.util.DefaultPrefixManager;
import org.semanticweb.owlapi.util.VersionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RioRenderer
extends RDFRendererBase {
    private static final Logger logger = LoggerFactory.getLogger(RioRenderer.class);
    private final RDFHandler writer;
    private final DefaultPrefixManager pm;
    @Nonnull
    private final Set<RDFTriple> renderedStatements = new LinkedHashSet<RDFTriple>();
    private final Resource[] contexts;

    public RioRenderer(@Nonnull OWLOntology ontology, RDFHandler writer, OWLDocumentFormat format, Resource ... contexts) {
        super(ontology, format);
        OpenRDFUtil.verifyContextNotNull(contexts);
        this.contexts = contexts;
        this.writer = writer;
        this.pm = new DefaultPrefixManager();
        if (!ontology.isAnonymous() && this.pm.getDefaultPrefix() == null) {
            this.pm.setDefaultPrefix(XMLUtils.iriWithTerminatingHash(ontology.getOntologyID().getOntologyIRI().get().toString()));
        }
        if (format instanceof PrefixDocumentFormat) {
            PrefixDocumentFormat prefixFormat = (PrefixDocumentFormat)format;
            this.pm.copyPrefixesFrom(prefixFormat);
            this.pm.setPrefixComparator(prefixFormat.getPrefixComparator());
        }
    }

    @Override
    protected void beginDocument() throws IOException {
        this.pending.clear();
        this.renderedStatements.clear();
        try {
            this.writer.startRDF();
        }
        catch (RDFHandlerException e) {
            throw new IOException(e);
        }
        this.writeNamespaces();
    }

    @Override
    protected void endDocument() throws IOException {
        this.writeComment(VersionInfo.getVersionInfo().getGeneratedByMessage());
        try {
            this.writer.endRDF();
        }
        catch (RDFHandlerException e) {
            throw new IOException(e);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("pendingNodes={}", (Object)this.pending.size());
            logger.trace("renderedStatements={}", (Object)this.renderedStatements.size());
        }
        this.pending.clear();
        this.renderedStatements.clear();
    }

    @Override
    protected void endObject() throws IOException {
        this.writeComment("");
    }

    @Override
    protected void renderOntologyHeader() throws IOException {
        super.renderOntologyHeader();
        this.graph.forceIdOutput();
    }

    @Override
    protected void createGraph(Set<? extends OWLObject> objects) {
        super.createGraph(objects);
        this.graph.forceIdOutput();
    }

    @Override
    public void render(RDFResource node, boolean root) throws IOException {
        if (!this.pending.add(node)) {
            return;
        }
        ArrayList<RDFTriple> statements = new ArrayList<RDFTriple>();
        Collection<RDFTriple> triples = this.graph.getTriplesForSubject(node);
        this.trace(triples);
        triples.stream().filter(this.renderedStatements::add).forEach(statements::add);
        this.recurseOnNestedResources(statements);
        try {
            statements.forEach(triple -> RioUtils.tripleAsStatements(triple, this.contexts).forEach(this.writer::handleStatement));
        }
        catch (RDFHandlerException e) {
            throw new IOException(e);
        }
        this.pending.remove(node);
    }

    protected void recurseOnNestedResources(List<RDFTriple> list) {
        HashSet<RDFResource> subnodes = new HashSet<RDFResource>();
        for (int i = 0; i < list.size(); ++i) {
            RDFResource node;
            if (!(list.get(i).getObject() instanceof RDFResource) || this.pending.contains(node = (RDFResource)list.get(i).getObject()) || !subnodes.add(node)) continue;
            Collection<RDFTriple> triples = this.graph.getTriplesForSubject(node);
            this.trace(triples);
            this.addNewTriples(list, i, triples);
        }
    }

    protected void addNewTriples(List<RDFTriple> list, int i, Collection<RDFTriple> triples) {
        Iterator it = triples.stream().filter(this.renderedStatements::add).iterator();
        int local = 1;
        while (it.hasNext()) {
            list.add(i + local, (RDFTriple)it.next());
        }
    }

    protected void trace(Collection<RDFTriple> triples) {
        if (logger.isTraceEnabled()) {
            logger.trace("triples.size()={}", (Object)triples.size());
            if (!triples.isEmpty()) {
                logger.trace("triples={}", (Object)triples);
            }
        }
    }

    @Override
    protected void writeAnnotationPropertyComment(@Nonnull OWLAnnotationProperty prop) throws IOException {
        this.writeComment(prop.getIRI().toString());
    }

    @Override
    protected void writeBanner(String name) throws IOException {
        this.writeComment("");
        this.writeComment("");
        this.writeComment("#################################################################");
        this.writeComment("#");
        this.writeComment("#    " + name);
        this.writeComment("#");
        this.writeComment("#################################################################");
        this.writeComment("");
        this.writeComment("");
    }

    @Override
    protected void writeClassComment(@Nonnull OWLClass cls) throws IOException {
        this.writeComment(cls.getIRI().toString());
    }

    private void writeComment(String comment) throws IOException {
        try {
            this.writer.handleComment(comment);
        }
        catch (RDFHandlerException e) {
            throw new IOException(e);
        }
    }

    @Override
    protected void writeDataPropertyComment(@Nonnull OWLDataProperty prop) throws IOException {
        this.writeComment(prop.getIRI().toString());
    }

    @Override
    protected void writeDatatypeComment(@Nonnull OWLDatatype datatype) throws IOException {
        this.writeComment(datatype.getIRI().toString());
    }

    @Override
    protected void writeIndividualComments(@Nonnull OWLNamedIndividual ind) throws IOException {
        this.writeComment(ind.getIRI().toString());
    }

    private void writeNamespaces() throws IOException {
        for (String prefixName : this.pm.getPrefixName2PrefixMap().keySet()) {
            assert (prefixName != null);
            String prefix = this.pm.getPrefix(prefixName);
            if (prefixName.endsWith(":")) {
                prefixName = prefixName.substring(0, prefixName.length() - 1);
            }
            try {
                this.writer.handleNamespace(prefixName, prefix);
            }
            catch (RDFHandlerException e) {
                throw new IOException(e);
            }
        }
    }

    @Override
    protected void writeObjectPropertyComment(@Nonnull OWLObjectProperty prop) throws IOException {
        this.writeComment(prop.getIRI().toString());
    }
}

