/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.rio;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URISyntaxException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.eclipse.rdf4j.OpenRDFUtil;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFWriter;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.rio.UnsupportedRDFormatException;
import org.eclipse.rdf4j.rio.helpers.StatementCollector;
import org.semanticweb.owlapi.formats.RioRDFDocumentFormat;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLDocumentFormatFactory;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;
import org.semanticweb.owlapi.rio.RioRenderer;
import org.semanticweb.owlapi.util.AbstractOWLStorer;

public class RioStorer
extends AbstractOWLStorer {
    private static final long serialVersionUID = 40000L;
    private transient RDFHandler rioHandler;
    private final OWLDocumentFormatFactory ontFormat;
    private final Resource[] contexts;

    public RioStorer(OWLDocumentFormatFactory ontologyFormat, RDFHandler rioHandler, Resource ... contexts) {
        this(ontologyFormat, contexts);
        this.rioHandler = rioHandler;
    }

    public RioStorer(OWLDocumentFormatFactory ontologyFormat, Resource ... contexts) {
        OpenRDFUtil.verifyContextNotNull(contexts);
        this.ontFormat = ontologyFormat;
        this.contexts = contexts;
    }

    @Override
    public boolean canStoreOntology(OWLDocumentFormat ontologyFormat) {
        return this.ontFormat.createFormat().equals(ontologyFormat);
    }

    protected RDFHandler getRDFHandlerForWriter(@Nullable RDFFormat format, Writer writer, @Nullable String baseIRI) throws OWLOntologyStorageException {
        if (format == null) {
            return new StatementCollector();
        }
        try {
            return this.getWriter(format, writer, baseIRI);
        }
        catch (URISyntaxException | UnsupportedRDFormatException e) {
            throw new OWLOntologyStorageException(e);
        }
    }

    protected RDFWriter getWriter(RDFFormat format, Writer writer, @Nullable String baseIRI) throws URISyntaxException {
        if (baseIRI == null || format.equals(RDFFormat.RDFXML)) {
            return Rio.createWriter(format, writer);
        }
        return Rio.createWriter(format, writer, baseIRI);
    }

    protected static RDFHandler getRDFHandlerForOutputStream(RDFFormat format, OutputStream outputStream) throws OWLOntologyStorageException {
        if (format == null) {
            return new StatementCollector();
        }
        try {
            return Rio.createWriter(format, outputStream);
        }
        catch (UnsupportedRDFormatException e) {
            throw new OWLOntologyStorageException(e);
        }
    }

    public RDFHandler getRioHandler() {
        return this.rioHandler;
    }

    public void setRioHandler(RDFHandler rioHandler) {
        this.rioHandler = rioHandler;
    }

    @Override
    protected void storeOntology(@Nonnull OWLOntology ontology, Writer writer, OWLDocumentFormat format) throws OWLOntologyStorageException {
        if (this.rioHandler == null) {
            if (!(format instanceof RioRDFDocumentFormat)) {
                throw new OWLOntologyStorageException("Unable to use RioOntologyStorer to store this format as it is not recognised as a RioRDFOntologyFormat: " + format);
            }
            RioRDFDocumentFormat rioFormat = (RioRDFDocumentFormat)format;
            if (format.isTextual()) {
                this.rioHandler = this.getRDFHandlerForWriter(rioFormat.getRioFormat(), writer, format.isPrefixOWLOntologyFormat() ? format.asPrefixOWLOntologyFormat().getDefaultPrefix() : null);
            } else {
                throw new OWLOntologyStorageException("Unable to use storeOntology with a Writer as the desired format is not textual. Format was " + format);
            }
        }
        try {
            RioRenderer ren = new RioRenderer(ontology, this.rioHandler, format, this.contexts);
            ren.render();
        }
        catch (IOException e) {
            throw new OWLOntologyStorageException(e);
        }
    }

    @Override
    protected void storeOntology(@Nonnull OWLOntology ontology, OutputStream outputStream, OWLDocumentFormat format) throws OWLOntologyStorageException {
        if (this.rioHandler == null) {
            if (!(format instanceof RioRDFDocumentFormat)) {
                throw new OWLOntologyStorageException("Unable to use RioOntologyStorer to store this format as it is not recognised as a RioRDFOntologyFormat: " + format);
            }
            RioRDFDocumentFormat rioFormat = (RioRDFDocumentFormat)format;
            if (format.isTextual()) {
                try {
                    BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"));
                    this.rioHandler = this.getRDFHandlerForWriter(rioFormat.getRioFormat(), writer, format.isPrefixOWLOntologyFormat() ? format.asPrefixOWLOntologyFormat().getDefaultPrefix() : null);
                }
                catch (IOException e) {
                    throw new OWLOntologyStorageException(e);
                }
            } else {
                this.rioHandler = RioStorer.getRDFHandlerForOutputStream(rioFormat.getRioFormat(), outputStream);
            }
        }
        try {
            RioRenderer ren = new RioRenderer(ontology, this.rioHandler, format, this.contexts);
            ren.render();
        }
        catch (IOException e) {
            throw new OWLOntologyStorageException(e);
        }
    }
}

