/*
 * Decompiled with CFR 0.152.
 */
package org.tap4j.consumer;

import java.io.File;
import org.tap4j.consumer.TapConsumer;
import org.tap4j.consumer.TapConsumerException;
import org.tap4j.model.TestSet;
import org.tap4j.parser.Parser;
import org.tap4j.parser.ParserException;
import org.tap4j.parser.Tap13Parser;

public class TapConsumerImpl
implements TapConsumer {
    private final Parser parser;
    private TestSet testSet;

    public TapConsumerImpl() {
        this.parser = new Tap13Parser();
        this.testSet = new TestSet();
    }

    public TapConsumerImpl(Parser parser) {
        this.parser = parser;
    }

    @Override
    public TestSet getTestSet() {
        return this.testSet;
    }

    @Override
    public TestSet load(File file) {
        try {
            this.testSet = this.parser.parseFile(file);
        }
        catch (ParserException e) {
            throw new TapConsumerException("Failed to parse file " + file + ": " + e.getMessage(), e);
        }
        return this.testSet;
    }

    @Override
    public TestSet load(Readable tapStream) {
        try {
            this.testSet = this.parser.parseTapStream(tapStream);
        }
        catch (ParserException e) {
            throw new TapConsumerException("Failed to parse TAP Stream " + tapStream + ": " + e.getMessage(), e);
        }
        return this.testSet;
    }

    @Override
    public TestSet load(String tapStream) {
        try {
            this.testSet = this.parser.parseTapStream(tapStream);
        }
        catch (ParserException e) {
            throw new TapConsumerException("Failed to parse TAP Stream " + tapStream + ": " + e.getMessage(), e);
        }
        return this.testSet;
    }

    @Override
    public Parser getParser() {
        return this.parser;
    }
}

