/*
 * Decompiled with CFR 0.152.
 */
package org.tap4j.model;

import java.util.regex.Matcher;
import org.tap4j.model.BailOut;
import org.tap4j.model.Comment;
import org.tap4j.model.Directive;
import org.tap4j.model.Footer;
import org.tap4j.model.Header;
import org.tap4j.model.Patterns;
import org.tap4j.model.Plan;
import org.tap4j.model.SkipPlan;
import org.tap4j.model.TapElement;
import org.tap4j.model.TestResult;
import org.tap4j.model.Text;
import org.tap4j.util.DirectiveValues;
import org.tap4j.util.StatusValues;

public final class TapElementFactory {
    private TapElementFactory() {
    }

    public static Text createTextElement(String tapLine) {
        Matcher m3 = Patterns.TEXT_PATTERN.matcher(tapLine);
        if (m3.matches()) {
            Text result = new Text(tapLine);
            result.setIndentationString(m3.group(1));
            result.indentation = m3.group(1).length();
            return result;
        }
        return null;
    }

    public static TapElement createTapElement(String tapLine) {
        Matcher m3 = Patterns.COMMENT_PATTERN.matcher(tapLine);
        if (m3.matches()) {
            Comment comment = new Comment(m3.group(3), false);
            comment.indentation = m3.group(1).length();
            return comment;
        }
        m3 = Patterns.HEADER_PATTERN.matcher(tapLine);
        if (m3.matches()) {
            Header header = new Header(Integer.parseInt(m3.group(3)));
            header.indentation = m3.group(1).length();
            TapElementFactory.addComment(header, m3.group(5));
            return header;
        }
        m3 = Patterns.FOOTER_PATTERN.matcher(tapLine);
        if (m3.matches()) {
            Footer footer = new Footer(m3.group(3));
            TapElementFactory.addComment(footer, m3.group(5));
            footer.indentation = m3.group(1).length();
            return footer;
        }
        m3 = Patterns.PLAN_PATTERN.matcher(tapLine);
        if (m3.matches()) {
            String skip = m3.group(8);
            String comment = m3.group(10);
            SkipPlan skipPlan = skip != null && skip.trim().length() > 0 ? new SkipPlan(skip) : null;
            Plan plan = new Plan(Integer.parseInt(m3.group(3)), Integer.parseInt(m3.group(5)), skipPlan);
            TapElementFactory.addComment(plan, comment);
            plan.indentation = m3.group(1).length();
            return plan;
        }
        m3 = Patterns.BAIL_OUT_PATTERN.matcher(tapLine);
        if (m3.matches()) {
            String reason = m3.group(3);
            String comment = m3.group(5);
            BailOut bailOut = new BailOut(reason);
            TapElementFactory.addComment(bailOut, comment);
            bailOut.indentation = m3.group(1).length();
            return bailOut;
        }
        m3 = Patterns.TEST_RESULT_PATTERN.matcher(tapLine);
        if (m3.matches()) {
            String testNumberText = m3.group(4);
            int testNumber = 0;
            if (testNumberText != null && !testNumberText.trim().equals("")) {
                testNumber = Integer.parseInt(testNumberText);
            }
            TestResult testResult = new TestResult(StatusValues.get(m3.group(3)), testNumber);
            String comment = m3.group(10);
            if (comment != null && comment.trim().length() > 0) {
                Comment c = new Comment(comment, true);
                testResult.setComment(c);
                testResult.addComment(c);
            }
            testResult.setDescription(m3.group(5));
            DirectiveValues directive = DirectiveValues.get(m3.group(7));
            if (directive != null) {
                testResult.setDirective(new Directive(directive, m3.group(8)));
            }
            testResult.indentation = m3.group(1).length();
            return testResult;
        }
        return null;
    }

    public static void addComment(TapElement element, String comment) {
        if (comment != null && comment.trim().length() > 0) {
            element.setComment(new Comment(comment, true));
        }
    }
}

