/*
 * Decompiled with CFR 0.152.
 */
package org.tap4j.representer;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.tap4j.model.BailOut;
import org.tap4j.model.TapElement;
import org.tap4j.model.TestResult;
import org.tap4j.model.TestSet;
import org.tap4j.representer.Representer;
import org.tap4j.representer.Statuses;
import org.tap4j.util.DirectiveValues;
import org.tap4j.util.StatusValues;

public class TapJunitRepresenter
implements Representer {
    private String name;

    public TapJunitRepresenter(String name) {
        this.name = name;
    }

    @Override
    public String representData(TestSet testSet) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
        Statuses statuses = this.getStatuses(testSet);
        pw.println("<testsuite failures=\"" + statuses.getFailures() + "\" time=\"" + statuses.getTime() + "\" errors=\"" + statuses.getErrors() + "\" skipped=\"" + statuses.getSkipped() + "\" tests=\"" + statuses.getTests() + "\" name=\"" + this.name + "\">");
        for (TapElement tapLine : testSet.getTapLines()) {
            if (tapLine instanceof TestResult) {
                pw.println("<testcase time=\"0\" classname=\"" + this.name + "\" name=\"" + ((TestResult)tapLine).getDescription() + "\">");
                if (((TestResult)tapLine).getDirective() != null && ((TestResult)tapLine).getDirective().getDirectiveValue() == DirectiveValues.SKIP) {
                    pw.println("<skipped/>");
                }
                if (((TestResult)tapLine).getStatus() == StatusValues.NOT_OK) {
                    pw.println("<failure message=\"" + ((TestResult)tapLine).getDescription() + "\" type=\"Failure\" />");
                }
                pw.println("</testcase>");
            }
            if (!(tapLine instanceof BailOut)) continue;
            pw.println("<testcase time=\"0\" classname=\"" + this.name + "\" name=\"" + ((BailOut)tapLine).getReason() + "\">");
            pw.println("<error message=\"" + ((BailOut)tapLine).getReason() + "\" type=\"BailOut\"/>");
            pw.println("</testcase>");
        }
        pw.println("</testsuite>");
        return sw.toString();
    }

    private Statuses getStatuses(TestSet testSet) {
        Statuses statuses = new Statuses();
        statuses.setErrors(testSet.getBailOuts().size());
        for (TestResult tr : testSet.getTestResults()) {
            statuses.setTests(statuses.getTests() + 1);
            if (tr.getDirective() != null && tr.getDirective().getDirectiveValue() == DirectiveValues.SKIP) {
                statuses.setSkipped(statuses.getSkipped() + 1);
                continue;
            }
            if (tr.getStatus() != StatusValues.NOT_OK) continue;
            statuses.setFailures(statuses.getFailures() + 1);
        }
        return statuses;
    }
}

