/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppcrt;

import com.carrotsearch.hppcrt.ArraySizingStrategy;
import com.carrotsearch.hppcrt.ObjectFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectPool<E> {
    protected ObjectFactory<E> factory;
    protected int currentSize;
    protected int capacity;
    protected ArraySizingStrategy growthPolicy;
    protected E[] arrayPool;

    public ObjectPool(ObjectFactory<E> objFactory, int initialSize, ArraySizingStrategy growthPolicy) {
        this.factory = objFactory;
        this.currentSize = initialSize;
        this.growthPolicy = growthPolicy;
        assert (this.factory != null);
        assert (this.currentSize > 0);
        assert (this.growthPolicy != null);
        this.capacity = this.currentSize;
        this.arrayPool = new Object[this.capacity];
        for (int i = 0; i < this.arrayPool.length; ++i) {
            this.arrayPool[i] = this.factory.create();
        }
    }

    public E borrow() {
        Object borrowedObject = null;
        if (this.currentSize <= 0) {
            int newCapacity = this.growthPolicy.grow(this.capacity, this.capacity, 1);
            if (newCapacity < 0) {
                int nbAddedObjects = Math.min(-newCapacity, this.capacity);
                for (int i = 0; i < nbAddedObjects; ++i) {
                    this.arrayPool[i] = this.factory.create();
                    this.currentSize = nbAddedObjects;
                }
            } else if (newCapacity > this.capacity) {
                Object[] newPoolArray = new Object[newCapacity];
                for (int i = 0; i < newCapacity - this.capacity; ++i) {
                    newPoolArray[i] = this.factory.create();
                }
                this.currentSize = newCapacity - this.capacity;
                this.capacity = newCapacity;
                this.arrayPool = newPoolArray;
            }
        }
        if (this.currentSize > 0) {
            borrowedObject = this.arrayPool[this.currentSize - 1];
            this.arrayPool[this.currentSize - 1] = null;
            this.factory.initialize(borrowedObject);
            --this.currentSize;
        }
        return borrowedObject;
    }

    public void release(E releasedObject) {
        this.factory.reset(releasedObject);
        if (releasedObject != null && this.currentSize < this.capacity) {
            this.arrayPool[this.currentSize] = releasedObject;
            ++this.currentSize;
        }
    }

    public int size() {
        return this.currentSize;
    }

    public int capacity() {
        return this.capacity;
    }
}

