/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppcrt.heaps;

import com.carrotsearch.hppcrt.AbstractFloatCollection;
import com.carrotsearch.hppcrt.AbstractIterator;
import com.carrotsearch.hppcrt.ArraySizingStrategy;
import com.carrotsearch.hppcrt.BoundedProportionalArraySizingStrategy;
import com.carrotsearch.hppcrt.BufferAllocationException;
import com.carrotsearch.hppcrt.FloatContainer;
import com.carrotsearch.hppcrt.FloatPriorityQueue;
import com.carrotsearch.hppcrt.IteratorPool;
import com.carrotsearch.hppcrt.ObjectFactory;
import com.carrotsearch.hppcrt.cursors.FloatCursor;
import com.carrotsearch.hppcrt.hash.BitMixer;
import com.carrotsearch.hppcrt.predicates.FloatPredicate;
import com.carrotsearch.hppcrt.procedures.FloatProcedure;
import com.carrotsearch.hppcrt.strategies.FloatComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FloatHeapPriorityQueue
extends AbstractFloatCollection
implements FloatPriorityQueue,
Cloneable {
    public float[] buffer;
    protected int elementsCount;
    protected FloatComparator comparator;
    protected final ArraySizingStrategy resizer;
    protected final IteratorPool<FloatCursor, ValueIterator> valueIteratorPool;
    protected float currentOccurenceToBeRemoved;
    protected FloatPredicate removeAllOccurencesPredicate = new FloatPredicate(){

        public final boolean apply(float value) {
            return Float.floatToIntBits(value) == Float.floatToIntBits(FloatHeapPriorityQueue.this.currentOccurenceToBeRemoved);
        }
    };
    protected float defaultValue;

    public FloatHeapPriorityQueue(FloatComparator comp, int initialCapacity, ArraySizingStrategy resizer) {
        this.comparator = comp;
        assert (resizer != null);
        this.resizer = resizer;
        this.ensureBufferSpace(Math.max(8, initialCapacity));
        this.valueIteratorPool = new IteratorPool(new ObjectFactory<ValueIterator>(){

            @Override
            public ValueIterator create() {
                return new ValueIterator();
            }

            @Override
            public void initialize(ValueIterator obj) {
                obj.cursor.index = 0;
                obj.size = FloatHeapPriorityQueue.this.size();
                ValueIterator.access$102(obj, FloatHeapPriorityQueue.this.buffer);
            }

            @Override
            public void reset(ValueIterator obj) {
                ValueIterator.access$102(obj, null);
            }
        });
    }

    public FloatHeapPriorityQueue(FloatComparator comp) {
        this(comp, 8);
    }

    public FloatHeapPriorityQueue() {
        this(null, 8);
    }

    public FloatHeapPriorityQueue(int initialCapacity) {
        this(null, initialCapacity, new BoundedProportionalArraySizingStrategy());
    }

    public FloatHeapPriorityQueue(FloatComparator comp, int initialCapacity) {
        this(comp, initialCapacity, new BoundedProportionalArraySizingStrategy());
    }

    public FloatHeapPriorityQueue(FloatContainer container) {
        this(container.size());
        this.addAll(container);
    }

    public static FloatHeapPriorityQueue from(FloatContainer container) {
        return new FloatHeapPriorityQueue(container);
    }

    public static FloatHeapPriorityQueue from(float ... elements) {
        FloatHeapPriorityQueue heap = new FloatHeapPriorityQueue(elements.length);
        for (float elem : elements) {
            heap.add(elem);
        }
        return heap;
    }

    @Override
    public int removeAll(float e1) {
        this.currentOccurenceToBeRemoved = e1;
        return this.removeAll(this.removeAllOccurencesPredicate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int removeAll(FloatPredicate predicate) {
        int deleted = 0;
        float[] buffer = this.buffer;
        int elementsCount = this.elementsCount;
        int pos = 1;
        try {
            while (pos <= elementsCount) {
                if (predicate.apply(buffer[pos])) {
                    buffer[pos] = buffer[elementsCount];
                    --elementsCount;
                    ++deleted;
                    continue;
                }
                ++pos;
            }
        }
        finally {
            this.elementsCount = elementsCount;
            this.updatePriorities();
        }
        return deleted;
    }

    @Override
    public void clear() {
        this.elementsCount = 0;
    }

    public ValueIterator iterator() {
        return (ValueIterator)this.valueIteratorPool.borrow();
    }

    @Override
    public boolean contains(float element) {
        int size = this.elementsCount;
        float[] buff = this.buffer;
        for (int i = 1; i <= size; ++i) {
            if (Float.floatToIntBits(element) != Float.floatToIntBits(buff[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this.elementsCount;
    }

    @Override
    public int capacity() {
        return this.buffer.length - 1;
    }

    @Override
    public <T extends FloatProcedure> T forEach(T procedure) {
        float[] buff = this.buffer;
        int size = this.elementsCount;
        for (int i = 1; i <= size; ++i) {
            procedure.apply(buff[i]);
        }
        return procedure;
    }

    @Override
    public <T extends FloatPredicate> T forEach(T predicate) {
        float[] buff = this.buffer;
        int size = this.elementsCount;
        for (int i = 1; i <= size && predicate.apply(buff[i]); ++i) {
        }
        return predicate;
    }

    @Override
    public void add(float element) {
        this.ensureBufferSpace(1);
        ++this.elementsCount;
        this.buffer[this.elementsCount] = element;
        this.swim(this.elementsCount);
    }

    @Override
    public float top() {
        float elem = this.defaultValue;
        if (this.elementsCount > 0) {
            elem = this.buffer[1];
        }
        return elem;
    }

    @Override
    public float popTop() {
        float elem = this.defaultValue;
        if (this.elementsCount > 0) {
            elem = this.buffer[1];
            if (this.elementsCount == 1) {
                this.elementsCount = 0;
            } else {
                this.buffer[1] = this.buffer[this.elementsCount];
                --this.elementsCount;
                this.sink(1);
            }
        }
        return elem;
    }

    public int addAll(FloatContainer container) {
        return this.addAll((Iterable<? extends FloatCursor>)container);
    }

    public int addAll(Iterable<? extends FloatCursor> iterable) {
        int size = 0;
        float[] buff = this.buffer;
        int count = this.elementsCount;
        for (FloatCursor floatCursor : iterable) {
            this.ensureBufferSpace(1);
            buff[++count] = floatCursor.value;
            ++size;
        }
        this.elementsCount = count;
        this.updatePriorities();
        return size;
    }

    public int hashCode() {
        int h2 = 1;
        int max = this.elementsCount;
        float[] buff = this.buffer;
        for (int i = 1; i <= max; ++i) {
            h2 = 31 * h2 + BitMixer.mix(buff[i]);
        }
        return h2;
    }

    @Override
    public void updatePriorities() {
        if (this.comparator == null) {
            for (int k = this.elementsCount >> 1; k >= 1; --k) {
                this.sinkComparable(k);
            }
        } else {
            for (int k = this.elementsCount >> 1; k >= 1; --k) {
                this.sinkComparator(k);
            }
        }
    }

    @Override
    public void updateTopPriority() {
        if (this.elementsCount > 1) {
            this.sink(1);
        }
    }

    public FloatHeapPriorityQueue clone() {
        FloatHeapPriorityQueue cloned = new FloatHeapPriorityQueue(this.comparator, 8, this.resizer);
        cloned.buffer = (float[])this.buffer.clone();
        cloned.defaultValue = this.defaultValue;
        cloned.elementsCount = this.elementsCount;
        return cloned;
    }

    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            FloatHeapPriorityQueue other = (FloatHeapPriorityQueue)obj;
            if (other.size() != this.size()) {
                return false;
            }
            if (!(this.comparator == null && other.comparator == null || this.comparator != null && this.comparator.equals(other.comparator))) {
                return false;
            }
            ValueIterator it = this.iterator();
            ValueIterator itOther = other.iterator();
            while (it.hasNext()) {
                float myVal = ((FloatCursor)it.next()).value;
                float otherVal = ((FloatCursor)itOther.next()).value;
                if (Float.floatToIntBits(myVal) == Float.floatToIntBits(otherVal)) continue;
                it.release();
                itOther.release();
                return false;
            }
            itOther.release();
            return true;
        }
        return false;
    }

    protected void ensureBufferSpace(int expectedAdditions) {
        int bufferLen;
        int n = bufferLen = this.buffer == null ? 0 : this.buffer.length;
        if (this.elementsCount + 1 > bufferLen - expectedAdditions) {
            int newSize = this.resizer.grow(bufferLen, this.elementsCount, expectedAdditions);
            if (this.buffer == null) {
                ++newSize;
            }
            try {
                float[] newBuffer = new float[newSize];
                if (bufferLen > 0) {
                    System.arraycopy(this.buffer, 0, newBuffer, 0, this.buffer.length);
                }
                this.buffer = newBuffer;
            }
            catch (OutOfMemoryError e) {
                throw new BufferAllocationException("Not enough memory to allocate buffers to grow from %d -> %d elements", (Throwable)e, bufferLen, newSize);
            }
        }
    }

    @Override
    public float[] toArray(float[] target) {
        System.arraycopy(this.buffer, 1, target, 0, this.elementsCount);
        return target;
    }

    public FloatComparator comparator() {
        return this.comparator;
    }

    @Override
    public float getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public void setDefaultValue(float defaultValue) {
        this.defaultValue = defaultValue;
    }

    private void sinkComparable(int k) {
        int N = this.elementsCount;
        float[] buffer = this.buffer;
        while (k << 1 <= N) {
            int child = k << 1;
            if (child < N && Float.compare(buffer[child], buffer[child + 1]) > 0) {
                ++child;
            }
            if (Float.compare(buffer[k], buffer[child]) <= 0) break;
            float tmp = buffer[k];
            buffer[k] = buffer[child];
            buffer[child] = tmp;
            k = child;
        }
    }

    private void sinkComparator(int k) {
        int N = this.elementsCount;
        float[] buffer = this.buffer;
        FloatComparator comp = this.comparator;
        while (k << 1 <= N) {
            int child = k << 1;
            if (child < N && comp.compare(buffer[child], buffer[child + 1]) > 0) {
                ++child;
            }
            if (comp.compare(buffer[k], buffer[child]) <= 0) break;
            float tmp = buffer[k];
            buffer[k] = buffer[child];
            buffer[child] = tmp;
            k = child;
        }
    }

    private void swimComparable(int k) {
        float[] buffer = this.buffer;
        while (k > 1 && Float.compare(buffer[k >> 1], buffer[k]) > 0) {
            int parent = k >> 1;
            float tmp = buffer[k];
            buffer[k] = buffer[parent];
            buffer[parent] = tmp;
            k = parent;
        }
    }

    private void swimComparator(int k) {
        float[] buffer = this.buffer;
        FloatComparator comp = this.comparator;
        while (k > 1 && comp.compare(buffer[k >> 1], buffer[k]) > 0) {
            int parent = k >> 1;
            float tmp = buffer[k];
            buffer[k] = buffer[parent];
            buffer[parent] = tmp;
            k = parent;
        }
    }

    private void swim(int k) {
        if (this.comparator == null) {
            this.swimComparable(k);
        } else {
            this.swimComparator(k);
        }
    }

    private void sink(int k) {
        if (this.comparator == null) {
            this.sinkComparable(k);
        } else {
            this.sinkComparator(k);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class ValueIterator
    extends AbstractIterator<FloatCursor> {
        public final FloatCursor cursor = new FloatCursor();
        private float[] buffer;
        private int size;

        public ValueIterator() {
            this.cursor.index = 0;
            this.size = FloatHeapPriorityQueue.this.size();
            this.buffer = FloatHeapPriorityQueue.this.buffer;
        }

        @Override
        protected FloatCursor fetch() {
            if (this.cursor.index == this.size) {
                return (FloatCursor)this.done();
            }
            this.cursor.value = this.buffer[++this.cursor.index];
            return this.cursor;
        }

        static /* synthetic */ float[] access$102(ValueIterator x0, float[] x1) {
            x0.buffer = x1;
            return x1;
        }
    }
}

