/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppcrt.heaps;

import com.carrotsearch.hppcrt.AbstractIntCollection;
import com.carrotsearch.hppcrt.AbstractIterator;
import com.carrotsearch.hppcrt.AbstractObjectCollection;
import com.carrotsearch.hppcrt.BufferAllocationException;
import com.carrotsearch.hppcrt.IntContainer;
import com.carrotsearch.hppcrt.IntLookupContainer;
import com.carrotsearch.hppcrt.IntObjectAssociativeContainer;
import com.carrotsearch.hppcrt.IntObjectMap;
import com.carrotsearch.hppcrt.IteratorPool;
import com.carrotsearch.hppcrt.ObjectArrays;
import com.carrotsearch.hppcrt.ObjectFactory;
import com.carrotsearch.hppcrt.cursors.IntCursor;
import com.carrotsearch.hppcrt.cursors.IntObjectCursor;
import com.carrotsearch.hppcrt.cursors.ObjectCursor;
import com.carrotsearch.hppcrt.hash.BitMixer;
import com.carrotsearch.hppcrt.predicates.IntObjectPredicate;
import com.carrotsearch.hppcrt.predicates.IntPredicate;
import com.carrotsearch.hppcrt.predicates.ObjectPredicate;
import com.carrotsearch.hppcrt.procedures.IntObjectProcedure;
import com.carrotsearch.hppcrt.procedures.IntProcedure;
import com.carrotsearch.hppcrt.procedures.ObjectProcedure;
import java.util.Arrays;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectIndexedHeapPriorityQueue<KType>
implements IntObjectMap<KType>,
Cloneable {
    public Object[] buffer;
    public int[] pq;
    protected int[] qp;
    protected int elementsCount;
    protected Comparator<? super KType> comparator;
    protected KType defaultValue = null;
    protected final IteratorPool<IntObjectCursor<KType>, EntryIterator> entryIteratorPool;

    public ObjectIndexedHeapPriorityQueue(Comparator<? super KType> comp, int initialCapacity) {
        this.comparator = comp;
        this.ensureBufferSpace(Math.max(8, initialCapacity));
        this.entryIteratorPool = new IteratorPool(new ObjectFactory<EntryIterator>(){

            @Override
            public EntryIterator create() {
                return new EntryIterator();
            }

            @Override
            public void initialize(EntryIterator obj) {
                obj.cursor.index = 0;
                EntryIterator.access$002(obj, ObjectIndexedHeapPriorityQueue.this.buffer);
                obj.size = ObjectIndexedHeapPriorityQueue.this.elementsCount;
                EntryIterator.access$202(obj, ObjectIndexedHeapPriorityQueue.this.qp);
            }

            @Override
            public void reset(EntryIterator obj) {
                EntryIterator.access$202(obj, null);
                EntryIterator.access$002(obj, null);
                obj.cursor.value = null;
            }
        });
    }

    public ObjectIndexedHeapPriorityQueue(Comparator<? super KType> comp) {
        this(comp, 8);
    }

    public ObjectIndexedHeapPriorityQueue() {
        this(null, 8);
    }

    public ObjectIndexedHeapPriorityQueue(int initialCapacity) {
        this(null, initialCapacity);
    }

    public ObjectIndexedHeapPriorityQueue(IntObjectAssociativeContainer<KType> container) {
        this(container.size());
        this.putAll(container);
    }

    public static <KType> ObjectIndexedHeapPriorityQueue<KType> from(IntObjectAssociativeContainer<KType> container) {
        return new ObjectIndexedHeapPriorityQueue<KType>(container);
    }

    public static <KType> ObjectIndexedHeapPriorityQueue<KType> from(int[] keys, KType[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        ObjectIndexedHeapPriorityQueue<KType> heap = new ObjectIndexedHeapPriorityQueue<KType>(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            heap.put(keys[i], values[i]);
        }
        return heap;
    }

    @Override
    public void clear() {
        ObjectArrays.blankArray(this.buffer, 1, this.elementsCount + 1);
        Arrays.fill(this.pq, 0);
        this.elementsCount = 0;
    }

    public EntryIterator iterator() {
        return (EntryIterator)this.entryIteratorPool.borrow();
    }

    @Override
    public int size() {
        return this.elementsCount;
    }

    @Override
    public int capacity() {
        return this.buffer.length - 1;
    }

    @Override
    public <T extends IntObjectProcedure<? super KType>> T forEach(T procedure) {
        Object[] buffer = this.buffer;
        int[] qp = this.qp;
        int size = this.elementsCount;
        for (int pos = 1; pos <= size; ++pos) {
            procedure.apply(qp[pos], (Object)buffer[pos]);
        }
        return procedure;
    }

    @Override
    public <T extends IntObjectPredicate<? super KType>> T forEach(T predicate) {
        Object[] buffer = this.buffer;
        int[] qp = this.qp;
        int size = this.elementsCount;
        for (int pos = 1; pos <= size && predicate.apply(qp[pos], (Object)buffer[pos]); ++pos) {
        }
        return predicate;
    }

    @Override
    public boolean isEmpty() {
        return this.elementsCount == 0;
    }

    @Override
    public int removeAll(IntContainer container) {
        int before = this.elementsCount;
        for (IntCursor cursor : container) {
            this.remove(cursor.value);
        }
        return before - this.elementsCount;
    }

    @Override
    public int removeAll(IntPredicate predicate) {
        int[] pq = this.pq;
        int size = this.pq.length;
        int initialSize = this.elementsCount;
        for (int key = 0; key < size; ++key) {
            if (pq[key] <= 0 || !predicate.apply(key)) continue;
            this.remove(key);
        }
        return initialSize - this.elementsCount;
    }

    @Override
    public int removeAll(IntObjectPredicate<? super KType> predicate) {
        Object[] buffer = this.buffer;
        int[] pq = this.pq;
        int size = this.elementsCount;
        int initialSize = this.elementsCount;
        for (int key = 0; key < size; ++key) {
            int pos = pq[key];
            if (pos <= 0 || !predicate.apply(key, buffer[pos])) continue;
            this.remove(key);
        }
        return initialSize - this.elementsCount;
    }

    @Override
    public boolean putIfAbsent(int key, KType value) {
        if (!this.containsKey(key)) {
            this.put(key, value);
            return true;
        }
        return false;
    }

    @Override
    public int putAll(IntObjectAssociativeContainer<? extends KType> container) {
        return this.putAll((Iterable<? extends IntObjectCursor<? extends KType>>)container);
    }

    @Override
    public int putAll(Iterable<? extends IntObjectCursor<? extends KType>> iterable) {
        int count = this.elementsCount;
        for (IntObjectCursor<KType> intObjectCursor : iterable) {
            this.put(intObjectCursor.key, (KType)intObjectCursor.value);
        }
        return this.elementsCount - count;
    }

    @Override
    public KType put(int key, KType element) {
        assert (key >= 0) : "Keys must be >= 0, but is " + key;
        if (key < this.pq.length && this.pq[key] > 0) {
            Object previousValue = this.buffer[this.pq[key]];
            this.buffer[this.pq[key]] = element;
            this.sink(this.pq[key]);
            this.swim(this.pq[key]);
            return (KType)previousValue;
        }
        this.ensureBufferSpace(key);
        ++this.elementsCount;
        int count = this.elementsCount;
        this.buffer[count] = element;
        this.pq[key] = count;
        this.qp[count] = key;
        this.swim(count);
        return this.defaultValue;
    }

    public KType top() {
        Object elem = this.defaultValue;
        if (this.elementsCount > 0) {
            elem = this.buffer[1];
        }
        return elem;
    }

    public int topKey() {
        int key = -1;
        if (this.elementsCount > 0) {
            key = this.qp[1];
        }
        return key;
    }

    public KType popTop() {
        Object elem = this.defaultValue;
        if (this.elementsCount > 0) {
            elem = this.buffer[1];
            this.remove(this.qp[1]);
        }
        return elem;
    }

    @Override
    public KType get(int key) {
        Object elem = this.defaultValue;
        if (key < this.pq.length && this.pq[key] > 0) {
            elem = this.buffer[this.pq[key]];
        }
        return elem;
    }

    @Override
    public KType remove(int key) {
        Object deletedElement = this.defaultValue;
        int[] qp = this.qp;
        int[] pq = this.pq;
        Object[] buffer = this.buffer;
        if (key < pq.length && pq[key] > 0) {
            int deletedPos = pq[key];
            deletedElement = buffer[deletedPos];
            if (deletedPos == this.elementsCount) {
                pq[key] = 0;
                buffer[deletedPos] = null;
                --this.elementsCount;
            } else {
                int lastElementIndex = qp[this.elementsCount];
                buffer[deletedPos] = buffer[this.elementsCount];
                pq[lastElementIndex] = deletedPos;
                qp[deletedPos] = lastElementIndex;
                pq[key] = 0;
                buffer[this.elementsCount] = null;
                --this.elementsCount;
                if (this.elementsCount > 1) {
                    this.sink(pq[lastElementIndex]);
                    this.swim(pq[lastElementIndex]);
                }
            }
        }
        return deletedElement;
    }

    public void updatePriority(int key) {
        if (key < this.pq.length && this.pq[key] > 0) {
            this.swim(this.pq[key]);
            this.sink(this.pq[key]);
        }
    }

    public void updateTopPriority() {
        if (this.elementsCount > 1) {
            this.sink(1);
        }
    }

    @Override
    public boolean containsKey(int key) {
        return key < this.pq.length && this.pq[key] > 0;
    }

    public int hashCode() {
        int h2 = 1;
        int size = this.pq.length;
        Object[] buffer = this.buffer;
        int[] pq = this.pq;
        for (int index = 0; index < size; ++index) {
            if (pq[index] <= 0) continue;
            h2 = 31 * h2 + BitMixer.mix(index);
            h2 = 31 * h2 + BitMixer.mix(buffer[pq[index]]);
        }
        return h2;
    }

    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            ObjectIndexedHeapPriorityQueue other = (ObjectIndexedHeapPriorityQueue)obj;
            if (other.size() != this.size()) {
                return false;
            }
            if (!(this.comparator == null && other.comparator == null || this.comparator != null && this.comparator.equals(other.comparator))) {
                return false;
            }
            EntryIterator it = this.iterator();
            while (it.hasNext()) {
                IntObjectCursor c = (IntObjectCursor)it.next();
                if (!other.containsKey(c.key)) {
                    it.release();
                    return false;
                }
                Object mineValue = c.value;
                KType otherValue = other.get(c.key);
                if (mineValue != null ? mineValue.equals(otherValue) : otherValue == null) continue;
                it.release();
                return false;
            }
            return true;
        }
        return false;
    }

    public ObjectIndexedHeapPriorityQueue<KType> clone() {
        ObjectIndexedHeapPriorityQueue<? super KType> cloned = new ObjectIndexedHeapPriorityQueue<KType>(this.comparator, 8);
        cloned.buffer = (Object[])this.buffer.clone();
        cloned.pq = (int[])this.pq.clone();
        cloned.qp = (int[])this.qp.clone();
        cloned.defaultValue = this.defaultValue;
        cloned.elementsCount = this.elementsCount;
        return cloned;
    }

    public void updatePriorities() {
        if (this.comparator == null) {
            for (int k = this.elementsCount >> 1; k >= 1; --k) {
                this.sinkComparable(k);
            }
        } else {
            for (int k = this.elementsCount >> 1; k >= 1; --k) {
                this.sinkComparator(k);
            }
        }
    }

    @Override
    public KeysCollection keys() {
        return new KeysCollection();
    }

    public ValuesCollection values() {
        return new ValuesCollection();
    }

    public String toString() {
        Object[] buffer = this.buffer;
        int[] pq = this.pq;
        StringBuilder buff = new StringBuilder();
        buff.append("[");
        boolean first = true;
        for (int i = 0; i < pq.length; ++i) {
            if (pq[i] <= 0) continue;
            if (!first) {
                buff.append(", ");
            }
            buff.append(i);
            buff.append("=>");
            buff.append(buffer[pq[i]]);
            first = false;
        }
        buff.append("]");
        return buff.toString();
    }

    @Override
    public KType getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public void setDefaultValue(KType defaultValue) {
        this.defaultValue = defaultValue;
    }

    public Comparator<? super KType> comparator() {
        return this.comparator;
    }

    protected void ensureBufferSpace(int index) {
        int pqLen;
        int n = pqLen = this.pq == null ? 0 : this.pq.length;
        if (index > pqLen - 1) {
            int newPQSize = Math.max(index + 8, (int)((double)index * 1.5));
            try {
                int[] newPQIndex = new int[newPQSize];
                Object[] newBuffer = new Object[newPQSize + 1];
                int[] newQPIndex = new int[newPQSize + 1];
                if (pqLen > 0) {
                    System.arraycopy(this.buffer, 0, newBuffer, 0, this.buffer.length);
                    System.arraycopy(this.pq, 0, newPQIndex, 0, this.pq.length);
                    System.arraycopy(this.qp, 0, newQPIndex, 0, this.qp.length);
                }
                this.buffer = newBuffer;
                this.pq = newPQIndex;
                this.qp = newQPIndex;
            }
            catch (OutOfMemoryError e) {
                throw new BufferAllocationException("Not enough memory to allocate buffers to grow from %d -> %d elements", (Throwable)e, pqLen, newPQSize);
            }
        }
    }

    private void sinkComparable(int k) {
        int N = this.elementsCount;
        Object[] buffer = this.buffer;
        int[] pq = this.pq;
        int[] qp = this.qp;
        while (k << 1 <= N) {
            int child = k << 1;
            if (child < N && ((Comparable)buffer[child]).compareTo(buffer[child + 1]) > 0) {
                ++child;
            }
            if (((Comparable)buffer[k]).compareTo(buffer[child]) <= 0) break;
            Object tmp = buffer[k];
            buffer[k] = buffer[child];
            buffer[child] = tmp;
            int indexK = qp[k];
            int indexChild = qp[child];
            pq[indexK] = child;
            pq[indexChild] = k;
            qp[k] = indexChild;
            qp[child] = indexK;
            k = child;
        }
    }

    private void sinkComparator(int k) {
        int N = this.elementsCount;
        Object[] buffer = this.buffer;
        int[] pq = this.pq;
        int[] qp = this.qp;
        Comparator<KType> comp = this.comparator;
        while (k << 1 <= N) {
            int child = k << 1;
            if (child < N && comp.compare(buffer[child], buffer[child + 1]) > 0) {
                ++child;
            }
            if (comp.compare(buffer[k], buffer[child]) <= 0) break;
            Object tmp = buffer[k];
            buffer[k] = buffer[child];
            buffer[child] = tmp;
            int indexK = qp[k];
            int indexChild = qp[child];
            pq[indexK] = child;
            pq[indexChild] = k;
            qp[k] = indexChild;
            qp[child] = indexK;
            k = child;
        }
    }

    private void swimComparable(int k) {
        Object[] buffer = this.buffer;
        int[] pq = this.pq;
        int[] qp = this.qp;
        while (k > 1 && ((Comparable)buffer[k >> 1]).compareTo(buffer[k]) > 0) {
            int parent = k >> 1;
            Object tmp = buffer[k];
            buffer[k] = buffer[parent];
            buffer[parent] = tmp;
            int indexK = qp[k];
            int indexParent = qp[parent];
            pq[indexK] = parent;
            pq[indexParent] = k;
            qp[k] = indexParent;
            qp[parent] = indexK;
            k = parent;
        }
    }

    private void swimComparator(int k) {
        Object[] buffer = this.buffer;
        int[] pq = this.pq;
        int[] qp = this.qp;
        Comparator<KType> comp = this.comparator;
        while (k > 1 && comp.compare(buffer[k >> 1], buffer[k]) > 0) {
            int parent = k >> 1;
            Object tmp = buffer[k];
            buffer[k] = buffer[parent];
            buffer[parent] = tmp;
            int indexK = qp[k];
            int indexParent = qp[parent];
            pq[indexK] = parent;
            pq[indexParent] = k;
            qp[k] = indexParent;
            qp[parent] = indexK;
            k = parent;
        }
    }

    private void swim(int k) {
        if (this.comparator == null) {
            this.swimComparable(k);
        } else {
            this.swimComparator(k);
        }
    }

    private void sink(int k) {
        if (this.comparator == null) {
            this.sinkComparable(k);
        } else {
            this.sinkComparator(k);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int removeAllInternal(ObjectPredicate<? super KType> predicate) {
        int deleted = 0;
        Object[] buffer = this.buffer;
        int[] qp = this.qp;
        int[] pq = this.pq;
        int lastElementIndex = -1;
        int elementsCount = this.elementsCount;
        int pos = 1;
        try {
            while (pos <= elementsCount) {
                if (predicate.apply(buffer[pos])) {
                    lastElementIndex = qp[elementsCount];
                    buffer[pos] = buffer[elementsCount];
                    pq[lastElementIndex] = pos;
                    pq[qp[pos]] = 0;
                    qp[pos] = lastElementIndex;
                    buffer[elementsCount] = null;
                    --elementsCount;
                    ++deleted;
                    continue;
                }
                ++pos;
            }
        }
        finally {
            this.elementsCount = elementsCount;
            this.updatePriorities();
        }
        return deleted;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class ValuesIterator
    extends AbstractIterator<ObjectCursor<KType>> {
        public final ObjectCursor<KType> cursor = new ObjectCursor();
        private KType[] buffer;
        private int size;

        public ValuesIterator() {
            this.cursor.index = 0;
            this.buffer = ObjectIndexedHeapPriorityQueue.this.buffer;
            this.size = ObjectIndexedHeapPriorityQueue.this.size();
        }

        @Override
        protected ObjectCursor<KType> fetch() {
            if (this.cursor.index == this.size) {
                return (ObjectCursor)this.done();
            }
            this.cursor.value = this.buffer[++this.cursor.index];
            return this.cursor;
        }

        static /* synthetic */ Object[] access$602(ValuesIterator x0, Object[] x1) {
            x0.buffer = x1;
            return x1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class ValuesCollection
    extends AbstractObjectCollection<KType> {
        private final ObjectIndexedHeapPriorityQueue<KType> owner;
        private KType currentOccurenceToBeRemoved;
        private final ObjectPredicate<? super KType> removeAllOccurencesPredicate;
        protected final IteratorPool<ObjectCursor<KType>, ValuesIterator> valuesIteratorPool;

        public ValuesCollection() {
            this.owner = ObjectIndexedHeapPriorityQueue.this;
            this.removeAllOccurencesPredicate = new ObjectPredicate<KType>(){

                @Override
                public final boolean apply(KType value) {
                    return value == null ? ValuesCollection.this.currentOccurenceToBeRemoved == null : value.equals(ValuesCollection.this.currentOccurenceToBeRemoved);
                }
            };
            this.valuesIteratorPool = new IteratorPool(new ObjectFactory<ValuesIterator>(){

                @Override
                public ValuesIterator create() {
                    return new ValuesIterator();
                }

                @Override
                public void initialize(ValuesIterator obj) {
                    obj.cursor.index = 0;
                    ValuesIterator.access$602(obj, ObjectIndexedHeapPriorityQueue.this.buffer);
                    obj.size = ObjectIndexedHeapPriorityQueue.this.size();
                }

                @Override
                public void reset(ValuesIterator obj) {
                    ValuesIterator.access$602(obj, null);
                    obj.cursor.value = null;
                }
            });
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public int capacity() {
            return this.owner.capacity();
        }

        @Override
        public boolean contains(KType value) {
            Object[] buffer = this.owner.buffer;
            int size = this.owner.elementsCount;
            for (int pos = 1; pos <= size; ++pos) {
                if (!(buffer[pos] == null ? value == null : buffer[pos].equals(value))) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends ObjectProcedure<? super KType>> T forEach(T procedure) {
            Object[] buffer = this.owner.buffer;
            int size = this.owner.elementsCount;
            for (int pos = 1; pos <= size; ++pos) {
                procedure.apply((Object)buffer[pos]);
            }
            return procedure;
        }

        @Override
        public <T extends ObjectPredicate<? super KType>> T forEach(T predicate) {
            Object[] buffer = this.owner.buffer;
            int size = this.owner.elementsCount;
            for (int pos = 1; pos <= size && predicate.apply((Object)buffer[pos]); ++pos) {
            }
            return predicate;
        }

        public ValuesIterator iterator() {
            return (ValuesIterator)this.valuesIteratorPool.borrow();
        }

        @Override
        public int removeAll(KType e) {
            this.currentOccurenceToBeRemoved = e;
            return this.owner.removeAllInternal(this.removeAllOccurencesPredicate);
        }

        @Override
        public int removeAll(ObjectPredicate<? super KType> predicate) {
            return this.owner.removeAllInternal(predicate);
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public KType[] toArray(KType[] target) {
            System.arraycopy(this.owner.buffer, 1, target, 0, this.owner.elementsCount);
            return target;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class KeysIterator
    extends AbstractIterator<IntCursor> {
        public final IntCursor cursor = new IntCursor();
        private int[] pq;

        public KeysIterator() {
            this.cursor.value = -1;
            this.pq = ObjectIndexedHeapPriorityQueue.this.pq;
        }

        @Override
        protected IntCursor fetch() {
            int i;
            for (i = this.cursor.value + 1; i < this.pq.length && this.pq[i] <= 0; ++i) {
            }
            if (i == this.pq.length) {
                return (IntCursor)this.done();
            }
            this.cursor.value = i;
            this.cursor.index = this.pq[i];
            return this.cursor;
        }

        static /* synthetic */ int[] access$302(KeysIterator x0, int[] x1) {
            x0.pq = x1;
            return x1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class KeysCollection
    extends AbstractIntCollection
    implements IntLookupContainer {
        private final ObjectIndexedHeapPriorityQueue<KType> owner;
        protected final IteratorPool<IntCursor, KeysIterator> keyIteratorPool;

        public KeysCollection() {
            this.owner = ObjectIndexedHeapPriorityQueue.this;
            this.keyIteratorPool = new IteratorPool(new ObjectFactory<KeysIterator>(){

                @Override
                public KeysIterator create() {
                    return new KeysIterator();
                }

                @Override
                public void initialize(KeysIterator obj) {
                    obj.cursor.value = -1;
                    KeysIterator.access$302(obj, ObjectIndexedHeapPriorityQueue.this.pq);
                }

                @Override
                public void reset(KeysIterator obj) {
                    KeysIterator.access$302(obj, null);
                }
            });
        }

        @Override
        public boolean contains(int e) {
            return this.owner.containsKey(e);
        }

        @Override
        public <T extends IntProcedure> T forEach(T procedure) {
            int[] qp = this.owner.qp;
            int size = this.owner.elementsCount;
            for (int pos = 1; pos <= size; ++pos) {
                procedure.apply(qp[pos]);
            }
            return procedure;
        }

        @Override
        public <T extends IntPredicate> T forEach(T predicate) {
            int[] qp = this.owner.qp;
            int size = this.owner.elementsCount;
            for (int pos = 1; pos <= size && predicate.apply(qp[pos]); ++pos) {
            }
            return predicate;
        }

        public KeysIterator iterator() {
            return (KeysIterator)this.keyIteratorPool.borrow();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public int capacity() {
            return this.owner.capacity();
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public int removeAll(IntPredicate predicate) {
            return this.owner.removeAll(predicate);
        }

        @Override
        public int removeAll(int e) {
            boolean hasKey = this.owner.containsKey(e);
            int result = 0;
            if (hasKey) {
                this.owner.remove(e);
                result = 1;
            }
            return result;
        }

        @Override
        public int[] toArray(int[] target) {
            int count = 0;
            int[] pq = this.owner.pq;
            int size = this.owner.pq.length;
            for (int key = 0; key < size; ++key) {
                if (pq[key] <= 0) continue;
                target[count] = key;
                ++count;
            }
            return target;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class EntryIterator
    extends AbstractIterator<IntObjectCursor<KType>> {
        public final IntObjectCursor<KType> cursor = new IntObjectCursor();
        private KType[] buffer;
        private int size;
        private int[] qp;

        public EntryIterator() {
            this.cursor.index = 0;
            this.buffer = ObjectIndexedHeapPriorityQueue.this.buffer;
            this.size = ObjectIndexedHeapPriorityQueue.this.size();
            this.qp = ObjectIndexedHeapPriorityQueue.this.qp;
        }

        @Override
        protected IntObjectCursor<KType> fetch() {
            if (this.cursor.index == this.size) {
                return (IntObjectCursor)this.done();
            }
            this.cursor.key = this.qp[++this.cursor.index];
            this.cursor.value = this.buffer[this.cursor.index];
            return this.cursor;
        }

        static /* synthetic */ Object[] access$002(EntryIterator x0, Object[] x1) {
            x0.buffer = x1;
            return x1;
        }

        static /* synthetic */ int[] access$202(EntryIterator x0, int[] x1) {
            x0.qp = x1;
            return x1;
        }
    }
}

