/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppcrt.lists;

import com.carrotsearch.hppcrt.AbstractIntCollection;
import com.carrotsearch.hppcrt.AbstractIterator;
import com.carrotsearch.hppcrt.ArraySizingStrategy;
import com.carrotsearch.hppcrt.BoundedProportionalArraySizingStrategy;
import com.carrotsearch.hppcrt.BufferAllocationException;
import com.carrotsearch.hppcrt.IntArrays;
import com.carrotsearch.hppcrt.IntContainer;
import com.carrotsearch.hppcrt.IntIndexedContainer;
import com.carrotsearch.hppcrt.IteratorPool;
import com.carrotsearch.hppcrt.ObjectFactory;
import com.carrotsearch.hppcrt.cursors.IntCursor;
import com.carrotsearch.hppcrt.hash.BitMixer;
import com.carrotsearch.hppcrt.lists.IntLinkedList;
import com.carrotsearch.hppcrt.predicates.IntPredicate;
import com.carrotsearch.hppcrt.procedures.IntProcedure;
import com.carrotsearch.hppcrt.sorting.IntSort;
import com.carrotsearch.hppcrt.strategies.IntComparator;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntArrayList
extends AbstractIntCollection
implements IntIndexedContainer,
Cloneable {
    public int[] buffer;
    protected int elementsCount;
    protected final ArraySizingStrategy resizer;
    protected final IteratorPool<IntCursor, ValueIterator> valueIteratorPool;

    public IntArrayList() {
        this(8);
    }

    public IntArrayList(int initialCapacity) {
        this(initialCapacity, new BoundedProportionalArraySizingStrategy());
    }

    public IntArrayList(int initialCapacity, ArraySizingStrategy resizer) {
        assert (resizer != null);
        this.resizer = resizer;
        this.ensureBufferSpace(Math.max(8, initialCapacity));
        this.valueIteratorPool = new IteratorPool(new ObjectFactory<ValueIterator>(){

            @Override
            public ValueIterator create() {
                return new ValueIterator();
            }

            @Override
            public void initialize(ValueIterator obj) {
                obj.cursor.index = -1;
                obj.size = IntArrayList.this.size();
                ValueIterator.access$102(obj, IntArrayList.this.buffer);
            }

            @Override
            public void reset(ValueIterator obj) {
                ValueIterator.access$102(obj, null);
            }
        });
    }

    public IntArrayList(IntContainer container) {
        this(container.size());
        this.addAll(container);
    }

    @Override
    public void add(int e1) {
        this.ensureBufferSpace(1);
        this.buffer[this.elementsCount++] = e1;
    }

    public void add(int e1, int e2) {
        this.ensureBufferSpace(2);
        this.buffer[this.elementsCount++] = e1;
        this.buffer[this.elementsCount++] = e2;
    }

    public void add(int[] elements, int start, int length) {
        assert (length >= 0) : "Length must be >= 0";
        this.ensureBufferSpace(length);
        System.arraycopy(elements, start, this.buffer, this.elementsCount, length);
        this.elementsCount += length;
    }

    public void add(int ... elements) {
        this.add(elements, 0, elements.length);
    }

    public int addAll(IntContainer container) {
        return this.addAll((Iterable<? extends IntCursor>)container);
    }

    public int addAll(Iterable<? extends IntCursor> iterable) {
        int size = 0;
        for (IntCursor intCursor : iterable) {
            this.add(intCursor.value);
            ++size;
        }
        return size;
    }

    @Override
    public void insert(int index, int e1) {
        assert (index >= 0 && index <= this.size()) : "Index " + index + " out of bounds [" + 0 + ", " + this.size() + "].";
        this.ensureBufferSpace(1);
        System.arraycopy(this.buffer, index, this.buffer, index + 1, this.elementsCount - index);
        this.buffer[index] = e1;
        ++this.elementsCount;
    }

    @Override
    public int get(int index) {
        assert (index >= 0 && index < this.size()) : "Index " + index + " out of bounds [" + 0 + ", " + this.size() + "[.";
        return this.buffer[index];
    }

    @Override
    public int set(int index, int e1) {
        assert (index >= 0 && index < this.size()) : "Index " + index + " out of bounds [" + 0 + ", " + this.size() + "[.";
        int v = this.buffer[index];
        this.buffer[index] = e1;
        return v;
    }

    @Override
    public int remove(int index) {
        assert (index >= 0 && index < this.size()) : "Index " + index + " out of bounds [" + 0 + ", " + this.size() + "[.";
        int v = this.buffer[index];
        if (index + 1 < this.elementsCount) {
            System.arraycopy(this.buffer, index + 1, this.buffer, index, this.elementsCount - index - 1);
        }
        --this.elementsCount;
        return v;
    }

    @Override
    public void removeRange(int fromIndex, int toIndex) {
        this.checkRangeBounds(fromIndex, toIndex);
        System.arraycopy(this.buffer, toIndex, this.buffer, fromIndex, this.elementsCount - toIndex);
        int count = toIndex - fromIndex;
        this.elementsCount -= count;
    }

    @Override
    public int removeFirst(int e1) {
        int index = this.indexOf(e1);
        if (index >= 0) {
            this.remove(index);
        }
        return index;
    }

    @Override
    public int removeLast(int e1) {
        int index = this.lastIndexOf(e1);
        if (index >= 0) {
            this.remove(index);
        }
        return index;
    }

    @Override
    public int removeAll(int e1) {
        int to = 0;
        int[] buffer = this.buffer;
        for (int from = 0; from < this.elementsCount; ++from) {
            if (e1 == buffer[from]) continue;
            if (to != from) {
                buffer[to] = buffer[from];
            }
            ++to;
        }
        int deleted = this.elementsCount - to;
        this.elementsCount = to;
        return deleted;
    }

    @Override
    public boolean contains(int e1) {
        return this.indexOf(e1) >= 0;
    }

    @Override
    public int indexOf(int e1) {
        int[] buffer = this.buffer;
        for (int i = 0; i < this.elementsCount; ++i) {
            if (e1 != buffer[i]) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(int e1) {
        int[] buffer = this.buffer;
        for (int i = this.elementsCount - 1; i >= 0; --i) {
            if (e1 != buffer[i]) continue;
            return i;
        }
        return -1;
    }

    public void ensureCapacity(int minCapacity) {
        if (minCapacity > this.buffer.length) {
            this.ensureBufferSpace(minCapacity - this.size());
        }
    }

    protected void ensureBufferSpace(int expectedAdditions) {
        int bufferLen;
        int n = bufferLen = this.buffer == null ? 0 : this.buffer.length;
        if (this.elementsCount > bufferLen - expectedAdditions) {
            int newSize = this.resizer.grow(bufferLen, this.elementsCount, expectedAdditions);
            try {
                int[] newBuffer = new int[newSize];
                if (bufferLen > 0) {
                    System.arraycopy(this.buffer, 0, newBuffer, 0, this.buffer.length);
                }
                this.buffer = newBuffer;
            }
            catch (OutOfMemoryError e) {
                throw new BufferAllocationException("Not enough memory to allocate buffers to grow from %d -> %d elements", (Throwable)e, bufferLen, newSize);
            }
        }
    }

    public void resize(int newSize) {
        if (newSize <= this.buffer.length) {
            if (newSize >= this.elementsCount) {
                Arrays.fill(this.buffer, this.elementsCount, newSize, 0);
            }
        } else {
            this.ensureCapacity(newSize);
        }
        this.elementsCount = newSize;
    }

    @Override
    public int size() {
        return this.elementsCount;
    }

    @Override
    public int capacity() {
        return this.buffer.length;
    }

    public void trimToSize() {
        if (this.size() != this.buffer.length) {
            this.buffer = this.toArray();
        }
    }

    @Override
    public void clear() {
        this.elementsCount = 0;
    }

    public void release() {
        this.buffer = IntArrays.EMPTY;
        this.elementsCount = 0;
    }

    @Override
    public int[] toArray(int[] target) {
        System.arraycopy(this.buffer, 0, target, 0, this.elementsCount);
        return target;
    }

    public IntArrayList clone() {
        IntArrayList cloned = new IntArrayList(8, this.resizer);
        cloned.buffer = (int[])this.buffer.clone();
        cloned.elementsCount = this.elementsCount;
        return cloned;
    }

    public int hashCode() {
        int h2 = 1;
        int max = this.elementsCount;
        int[] buffer = this.buffer;
        for (int i = 0; i < max; ++i) {
            h2 = 31 * h2 + BitMixer.mix(buffer[i]);
        }
        return h2;
    }

    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof IntArrayList) {
                IntArrayList other = (IntArrayList)obj;
                return other.size() == this.size() && this.rangeEquals(other.buffer, this.buffer, this.size());
            }
            if (obj instanceof IntLinkedList) {
                IntLinkedList other = (IntLinkedList)obj;
                if (other.size() != this.size()) {
                    return false;
                }
                ValueIterator it = this.iterator();
                IntLinkedList.ValueIterator itOther = other.iterator();
                while (it.hasNext()) {
                    int myVal = ((IntCursor)it.next()).value;
                    int otherVal = ((IntCursor)itOther.next()).value;
                    if (myVal == otherVal) continue;
                    it.release();
                    itOther.release();
                    return false;
                }
                itOther.release();
                return true;
            }
            if (obj instanceof IntIndexedContainer) {
                IntIndexedContainer other = (IntIndexedContainer)obj;
                return other.size() == this.size() && this.allIndexesEqual(this, other, this.size());
            }
        }
        return false;
    }

    private boolean rangeEquals(int[] b1, int[] b2, int length) {
        for (int i = 0; i < length; ++i) {
            if (b1[i] == b2[i]) continue;
            return false;
        }
        return true;
    }

    private boolean allIndexesEqual(IntIndexedContainer b1, IntIndexedContainer b2, int length) {
        for (int i = 0; i < length; ++i) {
            int o2;
            int o1 = b1.get(i);
            if (o1 == (o2 = b2.get(i))) continue;
            return false;
        }
        return true;
    }

    public ValueIterator iterator() {
        return (ValueIterator)this.valueIteratorPool.borrow();
    }

    @Override
    public <T extends IntProcedure> T forEach(T procedure) {
        return this.forEach(procedure, 0, this.size());
    }

    @Override
    public <T extends IntProcedure> T forEach(T procedure, int fromIndex, int toIndex) {
        this.checkRangeBounds(fromIndex, toIndex);
        int[] buffer = this.buffer;
        for (int i = fromIndex; i < toIndex; ++i) {
            procedure.apply(buffer[i]);
        }
        return procedure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int removeAll(IntPredicate predicate) {
        int from;
        int elementsCount = this.elementsCount;
        int[] buffer = this.buffer;
        int to = 0;
        try {
            for (from = 0; from < elementsCount; ++from) {
                if (predicate.apply(buffer[from])) continue;
                if (to != from) {
                    buffer[to] = buffer[from];
                }
                ++to;
            }
        }
        finally {
            while (from < elementsCount) {
                if (to != from) {
                    buffer[to] = buffer[from];
                }
                ++to;
                ++from;
            }
            this.elementsCount = to;
        }
        return elementsCount - to;
    }

    @Override
    public <T extends IntPredicate> T forEach(T predicate) {
        return this.forEach(predicate, 0, this.size());
    }

    @Override
    public <T extends IntPredicate> T forEach(T predicate, int fromIndex, int toIndex) {
        this.checkRangeBounds(fromIndex, toIndex);
        int[] buffer = this.buffer;
        for (int i = fromIndex; i < toIndex && predicate.apply(buffer[i]); ++i) {
        }
        return predicate;
    }

    public static IntArrayList newInstance() {
        return new IntArrayList();
    }

    public static IntArrayList newInstance(int initialCapacity) {
        return new IntArrayList(initialCapacity);
    }

    public static IntArrayList from(int ... elements) {
        IntArrayList list = new IntArrayList(elements.length);
        list.add(elements);
        return list;
    }

    public static IntArrayList from(IntContainer container) {
        return new IntArrayList(container);
    }

    public void sort(int beginIndex, int endIndex) {
        IntSort.quicksort(this.buffer, beginIndex, endIndex);
    }

    public void sort() {
        this.sort(0, this.elementsCount);
    }

    public void sort(int beginIndex, int endIndex, IntComparator comp) {
        IntSort.quicksort(this.buffer, beginIndex, endIndex, comp);
    }

    public void sort(IntComparator comp) {
        this.sort(0, this.elementsCount, comp);
    }

    public void pushLast(int e1) {
        this.add(e1);
    }

    public void pushLast(int e1, int e2) {
        this.add(e1, e2);
    }

    public void pushLast(int e1, int e2, int e3) {
        this.ensureBufferSpace(3);
        this.buffer[this.elementsCount++] = e1;
        this.buffer[this.elementsCount++] = e2;
        this.buffer[this.elementsCount++] = e3;
    }

    public void pushLast(int e1, int e2, int e3, int e4) {
        this.ensureBufferSpace(4);
        this.buffer[this.elementsCount++] = e1;
        this.buffer[this.elementsCount++] = e2;
        this.buffer[this.elementsCount++] = e3;
        this.buffer[this.elementsCount++] = e4;
    }

    public void pushLast(int[] elements, int start, int len) {
        this.add(elements, start, len);
    }

    public final void pushLast(int ... elements) {
        this.add(elements, 0, elements.length);
    }

    public int pushAllLast(IntContainer container) {
        return this.addAll(container);
    }

    public int pushAllLast(Iterable<? extends IntCursor> iterable) {
        return this.addAll(iterable);
    }

    public void discardLast(int count) {
        assert (this.elementsCount >= count);
        this.elementsCount -= count;
    }

    public void discardLast() {
        assert (this.elementsCount > 0);
        --this.elementsCount;
    }

    public int popLast() {
        assert (this.elementsCount > 0);
        int v = this.buffer[--this.elementsCount];
        return v;
    }

    public int peekLast() {
        assert (this.elementsCount > 0);
        return this.buffer[this.elementsCount - 1];
    }

    private void checkRangeBounds(int beginIndex, int endIndex) {
        if (beginIndex > endIndex) {
            throw new IllegalArgumentException("Index beginIndex " + beginIndex + " is > endIndex " + endIndex);
        }
        if (beginIndex < 0) {
            throw new IndexOutOfBoundsException("Index beginIndex < 0");
        }
        if (endIndex > this.elementsCount) {
            throw new IndexOutOfBoundsException("Index endIndex " + endIndex + " out of bounds [" + 0 + ", " + this.elementsCount + "].");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class ValueIterator
    extends AbstractIterator<IntCursor> {
        public final IntCursor cursor = new IntCursor();
        private int[] buffer;
        private int size;

        public ValueIterator() {
            this.cursor.index = -1;
            this.size = IntArrayList.this.size();
            this.buffer = IntArrayList.this.buffer;
        }

        @Override
        protected IntCursor fetch() {
            if (this.cursor.index + 1 == this.size) {
                return (IntCursor)this.done();
            }
            this.cursor.value = this.buffer[++this.cursor.index];
            return this.cursor;
        }

        static /* synthetic */ int[] access$102(ValueIterator x0, int[] x1) {
            x0.buffer = x1;
            return x1;
        }
    }
}

