/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppcrt.lists;

import com.carrotsearch.hppcrt.AbstractIterator;
import com.carrotsearch.hppcrt.AbstractLongCollection;
import com.carrotsearch.hppcrt.ArraySizingStrategy;
import com.carrotsearch.hppcrt.BoundedProportionalArraySizingStrategy;
import com.carrotsearch.hppcrt.BufferAllocationException;
import com.carrotsearch.hppcrt.IteratorPool;
import com.carrotsearch.hppcrt.LongArrays;
import com.carrotsearch.hppcrt.LongContainer;
import com.carrotsearch.hppcrt.LongIndexedContainer;
import com.carrotsearch.hppcrt.ObjectFactory;
import com.carrotsearch.hppcrt.cursors.LongCursor;
import com.carrotsearch.hppcrt.hash.BitMixer;
import com.carrotsearch.hppcrt.lists.LongLinkedList;
import com.carrotsearch.hppcrt.predicates.LongPredicate;
import com.carrotsearch.hppcrt.procedures.LongProcedure;
import com.carrotsearch.hppcrt.sorting.LongSort;
import com.carrotsearch.hppcrt.strategies.LongComparator;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LongArrayList
extends AbstractLongCollection
implements LongIndexedContainer,
Cloneable {
    public long[] buffer;
    protected int elementsCount;
    protected final ArraySizingStrategy resizer;
    protected final IteratorPool<LongCursor, ValueIterator> valueIteratorPool;

    public LongArrayList() {
        this(8);
    }

    public LongArrayList(int initialCapacity) {
        this(initialCapacity, new BoundedProportionalArraySizingStrategy());
    }

    public LongArrayList(int initialCapacity, ArraySizingStrategy resizer) {
        assert (resizer != null);
        this.resizer = resizer;
        this.ensureBufferSpace(Math.max(8, initialCapacity));
        this.valueIteratorPool = new IteratorPool(new ObjectFactory<ValueIterator>(){

            @Override
            public ValueIterator create() {
                return new ValueIterator();
            }

            @Override
            public void initialize(ValueIterator obj) {
                obj.cursor.index = -1;
                obj.size = LongArrayList.this.size();
                ValueIterator.access$102(obj, LongArrayList.this.buffer);
            }

            @Override
            public void reset(ValueIterator obj) {
                ValueIterator.access$102(obj, null);
            }
        });
    }

    public LongArrayList(LongContainer container) {
        this(container.size());
        this.addAll(container);
    }

    @Override
    public void add(long e1) {
        this.ensureBufferSpace(1);
        this.buffer[this.elementsCount++] = e1;
    }

    public void add(long e1, long e2) {
        this.ensureBufferSpace(2);
        this.buffer[this.elementsCount++] = e1;
        this.buffer[this.elementsCount++] = e2;
    }

    public void add(long[] elements, int start, int length) {
        assert (length >= 0) : "Length must be >= 0";
        this.ensureBufferSpace(length);
        System.arraycopy(elements, start, this.buffer, this.elementsCount, length);
        this.elementsCount += length;
    }

    public void add(long ... elements) {
        this.add(elements, 0, elements.length);
    }

    public int addAll(LongContainer container) {
        return this.addAll((Iterable<? extends LongCursor>)container);
    }

    public int addAll(Iterable<? extends LongCursor> iterable) {
        int size = 0;
        for (LongCursor longCursor : iterable) {
            this.add(longCursor.value);
            ++size;
        }
        return size;
    }

    @Override
    public void insert(int index, long e1) {
        assert (index >= 0 && index <= this.size()) : "Index " + index + " out of bounds [" + 0 + ", " + this.size() + "].";
        this.ensureBufferSpace(1);
        System.arraycopy(this.buffer, index, this.buffer, index + 1, this.elementsCount - index);
        this.buffer[index] = e1;
        ++this.elementsCount;
    }

    @Override
    public long get(int index) {
        assert (index >= 0 && index < this.size()) : "Index " + index + " out of bounds [" + 0 + ", " + this.size() + "[.";
        return this.buffer[index];
    }

    @Override
    public long set(int index, long e1) {
        assert (index >= 0 && index < this.size()) : "Index " + index + " out of bounds [" + 0 + ", " + this.size() + "[.";
        long v = this.buffer[index];
        this.buffer[index] = e1;
        return v;
    }

    @Override
    public long remove(int index) {
        assert (index >= 0 && index < this.size()) : "Index " + index + " out of bounds [" + 0 + ", " + this.size() + "[.";
        long v = this.buffer[index];
        if (index + 1 < this.elementsCount) {
            System.arraycopy(this.buffer, index + 1, this.buffer, index, this.elementsCount - index - 1);
        }
        --this.elementsCount;
        return v;
    }

    @Override
    public void removeRange(int fromIndex, int toIndex) {
        this.checkRangeBounds(fromIndex, toIndex);
        System.arraycopy(this.buffer, toIndex, this.buffer, fromIndex, this.elementsCount - toIndex);
        int count = toIndex - fromIndex;
        this.elementsCount -= count;
    }

    @Override
    public int removeFirst(long e1) {
        int index = this.indexOf(e1);
        if (index >= 0) {
            this.remove(index);
        }
        return index;
    }

    @Override
    public int removeLast(long e1) {
        int index = this.lastIndexOf(e1);
        if (index >= 0) {
            this.remove(index);
        }
        return index;
    }

    @Override
    public int removeAll(long e1) {
        int to = 0;
        long[] buffer = this.buffer;
        for (int from = 0; from < this.elementsCount; ++from) {
            if (e1 == buffer[from]) continue;
            if (to != from) {
                buffer[to] = buffer[from];
            }
            ++to;
        }
        int deleted = this.elementsCount - to;
        this.elementsCount = to;
        return deleted;
    }

    @Override
    public boolean contains(long e1) {
        return this.indexOf(e1) >= 0;
    }

    @Override
    public int indexOf(long e1) {
        long[] buffer = this.buffer;
        for (int i = 0; i < this.elementsCount; ++i) {
            if (e1 != buffer[i]) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(long e1) {
        long[] buffer = this.buffer;
        for (int i = this.elementsCount - 1; i >= 0; --i) {
            if (e1 != buffer[i]) continue;
            return i;
        }
        return -1;
    }

    public void ensureCapacity(int minCapacity) {
        if (minCapacity > this.buffer.length) {
            this.ensureBufferSpace(minCapacity - this.size());
        }
    }

    protected void ensureBufferSpace(int expectedAdditions) {
        int bufferLen;
        int n = bufferLen = this.buffer == null ? 0 : this.buffer.length;
        if (this.elementsCount > bufferLen - expectedAdditions) {
            int newSize = this.resizer.grow(bufferLen, this.elementsCount, expectedAdditions);
            try {
                long[] newBuffer = new long[newSize];
                if (bufferLen > 0) {
                    System.arraycopy(this.buffer, 0, newBuffer, 0, this.buffer.length);
                }
                this.buffer = newBuffer;
            }
            catch (OutOfMemoryError e) {
                throw new BufferAllocationException("Not enough memory to allocate buffers to grow from %d -> %d elements", (Throwable)e, bufferLen, newSize);
            }
        }
    }

    public void resize(int newSize) {
        if (newSize <= this.buffer.length) {
            if (newSize >= this.elementsCount) {
                Arrays.fill(this.buffer, this.elementsCount, newSize, 0L);
            }
        } else {
            this.ensureCapacity(newSize);
        }
        this.elementsCount = newSize;
    }

    @Override
    public int size() {
        return this.elementsCount;
    }

    @Override
    public int capacity() {
        return this.buffer.length;
    }

    public void trimToSize() {
        if (this.size() != this.buffer.length) {
            this.buffer = this.toArray();
        }
    }

    @Override
    public void clear() {
        this.elementsCount = 0;
    }

    public void release() {
        this.buffer = LongArrays.EMPTY;
        this.elementsCount = 0;
    }

    @Override
    public long[] toArray(long[] target) {
        System.arraycopy(this.buffer, 0, target, 0, this.elementsCount);
        return target;
    }

    public LongArrayList clone() {
        LongArrayList cloned = new LongArrayList(8, this.resizer);
        cloned.buffer = (long[])this.buffer.clone();
        cloned.elementsCount = this.elementsCount;
        return cloned;
    }

    public int hashCode() {
        int h2 = 1;
        int max = this.elementsCount;
        long[] buffer = this.buffer;
        for (int i = 0; i < max; ++i) {
            h2 = 31 * h2 + BitMixer.mix(buffer[i]);
        }
        return h2;
    }

    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof LongArrayList) {
                LongArrayList other = (LongArrayList)obj;
                return other.size() == this.size() && this.rangeEquals(other.buffer, this.buffer, this.size());
            }
            if (obj instanceof LongLinkedList) {
                LongLinkedList other = (LongLinkedList)obj;
                if (other.size() != this.size()) {
                    return false;
                }
                ValueIterator it = this.iterator();
                LongLinkedList.ValueIterator itOther = other.iterator();
                while (it.hasNext()) {
                    long myVal = ((LongCursor)it.next()).value;
                    long otherVal = ((LongCursor)itOther.next()).value;
                    if (myVal == otherVal) continue;
                    it.release();
                    itOther.release();
                    return false;
                }
                itOther.release();
                return true;
            }
            if (obj instanceof LongIndexedContainer) {
                LongIndexedContainer other = (LongIndexedContainer)obj;
                return other.size() == this.size() && this.allIndexesEqual(this, other, this.size());
            }
        }
        return false;
    }

    private boolean rangeEquals(long[] b1, long[] b2, int length) {
        for (int i = 0; i < length; ++i) {
            if (b1[i] == b2[i]) continue;
            return false;
        }
        return true;
    }

    private boolean allIndexesEqual(LongIndexedContainer b1, LongIndexedContainer b2, int length) {
        for (int i = 0; i < length; ++i) {
            long o2;
            long o1 = b1.get(i);
            if (o1 == (o2 = b2.get(i))) continue;
            return false;
        }
        return true;
    }

    public ValueIterator iterator() {
        return (ValueIterator)this.valueIteratorPool.borrow();
    }

    @Override
    public <T extends LongProcedure> T forEach(T procedure) {
        return this.forEach(procedure, 0, this.size());
    }

    @Override
    public <T extends LongProcedure> T forEach(T procedure, int fromIndex, int toIndex) {
        this.checkRangeBounds(fromIndex, toIndex);
        long[] buffer = this.buffer;
        for (int i = fromIndex; i < toIndex; ++i) {
            procedure.apply(buffer[i]);
        }
        return procedure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int removeAll(LongPredicate predicate) {
        int from;
        int elementsCount = this.elementsCount;
        long[] buffer = this.buffer;
        int to = 0;
        try {
            for (from = 0; from < elementsCount; ++from) {
                if (predicate.apply(buffer[from])) continue;
                if (to != from) {
                    buffer[to] = buffer[from];
                }
                ++to;
            }
        }
        finally {
            while (from < elementsCount) {
                if (to != from) {
                    buffer[to] = buffer[from];
                }
                ++to;
                ++from;
            }
            this.elementsCount = to;
        }
        return elementsCount - to;
    }

    @Override
    public <T extends LongPredicate> T forEach(T predicate) {
        return this.forEach(predicate, 0, this.size());
    }

    @Override
    public <T extends LongPredicate> T forEach(T predicate, int fromIndex, int toIndex) {
        this.checkRangeBounds(fromIndex, toIndex);
        long[] buffer = this.buffer;
        for (int i = fromIndex; i < toIndex && predicate.apply(buffer[i]); ++i) {
        }
        return predicate;
    }

    public static LongArrayList newInstance() {
        return new LongArrayList();
    }

    public static LongArrayList newInstance(int initialCapacity) {
        return new LongArrayList(initialCapacity);
    }

    public static LongArrayList from(long ... elements) {
        LongArrayList list = new LongArrayList(elements.length);
        list.add(elements);
        return list;
    }

    public static LongArrayList from(LongContainer container) {
        return new LongArrayList(container);
    }

    public void sort(int beginIndex, int endIndex) {
        LongSort.quicksort(this.buffer, beginIndex, endIndex);
    }

    public void sort() {
        this.sort(0, this.elementsCount);
    }

    public void sort(int beginIndex, int endIndex, LongComparator comp) {
        LongSort.quicksort(this.buffer, beginIndex, endIndex, comp);
    }

    public void sort(LongComparator comp) {
        this.sort(0, this.elementsCount, comp);
    }

    public void pushLast(long e1) {
        this.add(e1);
    }

    public void pushLast(long e1, long e2) {
        this.add(e1, e2);
    }

    public void pushLast(long e1, long e2, long e3) {
        this.ensureBufferSpace(3);
        this.buffer[this.elementsCount++] = e1;
        this.buffer[this.elementsCount++] = e2;
        this.buffer[this.elementsCount++] = e3;
    }

    public void pushLast(long e1, long e2, long e3, long e4) {
        this.ensureBufferSpace(4);
        this.buffer[this.elementsCount++] = e1;
        this.buffer[this.elementsCount++] = e2;
        this.buffer[this.elementsCount++] = e3;
        this.buffer[this.elementsCount++] = e4;
    }

    public void pushLast(long[] elements, int start, int len) {
        this.add(elements, start, len);
    }

    public final void pushLast(long ... elements) {
        this.add(elements, 0, elements.length);
    }

    public int pushAllLast(LongContainer container) {
        return this.addAll(container);
    }

    public int pushAllLast(Iterable<? extends LongCursor> iterable) {
        return this.addAll(iterable);
    }

    public void discardLast(int count) {
        assert (this.elementsCount >= count);
        this.elementsCount -= count;
    }

    public void discardLast() {
        assert (this.elementsCount > 0);
        --this.elementsCount;
    }

    public long popLast() {
        assert (this.elementsCount > 0);
        long v = this.buffer[--this.elementsCount];
        return v;
    }

    public long peekLast() {
        assert (this.elementsCount > 0);
        return this.buffer[this.elementsCount - 1];
    }

    private void checkRangeBounds(int beginIndex, int endIndex) {
        if (beginIndex > endIndex) {
            throw new IllegalArgumentException("Index beginIndex " + beginIndex + " is > endIndex " + endIndex);
        }
        if (beginIndex < 0) {
            throw new IndexOutOfBoundsException("Index beginIndex < 0");
        }
        if (endIndex > this.elementsCount) {
            throw new IndexOutOfBoundsException("Index endIndex " + endIndex + " out of bounds [" + 0 + ", " + this.elementsCount + "].");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class ValueIterator
    extends AbstractIterator<LongCursor> {
        public final LongCursor cursor = new LongCursor();
        private long[] buffer;
        private int size;

        public ValueIterator() {
            this.cursor.index = -1;
            this.size = LongArrayList.this.size();
            this.buffer = LongArrayList.this.buffer;
        }

        @Override
        protected LongCursor fetch() {
            if (this.cursor.index + 1 == this.size) {
                return (LongCursor)this.done();
            }
            this.cursor.value = this.buffer[++this.cursor.index];
            return this.cursor;
        }

        static /* synthetic */ long[] access$102(ValueIterator x0, long[] x1) {
            x0.buffer = x1;
            return x1;
        }
    }
}

