/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppcrt.lists;

import com.carrotsearch.hppcrt.AbstractIterator;
import com.carrotsearch.hppcrt.AbstractObjectCollection;
import com.carrotsearch.hppcrt.ArraySizingStrategy;
import com.carrotsearch.hppcrt.BoundedProportionalArraySizingStrategy;
import com.carrotsearch.hppcrt.BufferAllocationException;
import com.carrotsearch.hppcrt.IteratorPool;
import com.carrotsearch.hppcrt.ObjectArrays;
import com.carrotsearch.hppcrt.ObjectContainer;
import com.carrotsearch.hppcrt.ObjectDeque;
import com.carrotsearch.hppcrt.ObjectFactory;
import com.carrotsearch.hppcrt.ObjectIndexedContainer;
import com.carrotsearch.hppcrt.cursors.ObjectCursor;
import com.carrotsearch.hppcrt.hash.BitMixer;
import com.carrotsearch.hppcrt.predicates.ObjectPredicate;
import com.carrotsearch.hppcrt.procedures.ObjectProcedure;
import com.carrotsearch.hppcrt.sorting.ObjectSort;
import java.util.Comparator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectLinkedList<KType>
extends AbstractObjectCollection<KType>
implements ObjectIndexedContainer<KType>,
ObjectDeque<KType>,
Cloneable {
    public Object[] buffer;
    protected long[] beforeAfterPointers;
    protected static final int HEAD_POSITION = 0;
    protected static final int TAIL_POSITION = 1;
    protected int elementsCount = 2;
    protected final ArraySizingStrategy resizer;
    protected final IteratorPool<ObjectCursor<KType>, ValueIterator> valueIteratorPool;
    protected final IteratorPool<ObjectCursor<KType>, DescendingValueIterator> descendingValueIteratorPool;

    public ObjectLinkedList() {
        this(8);
    }

    public ObjectLinkedList(int initialCapacity) {
        this(initialCapacity, new BoundedProportionalArraySizingStrategy());
    }

    public ObjectLinkedList(int initialCapacity, ArraySizingStrategy resizer) {
        assert (resizer != null);
        this.resizer = resizer;
        this.ensureBufferSpace(Math.max(8, initialCapacity));
        this.elementsCount = 2;
        this.beforeAfterPointers[0] = 1L;
        this.beforeAfterPointers[1] = 1L;
        this.valueIteratorPool = new IteratorPool(new ObjectFactory<ValueIterator>(){

            @Override
            public ValueIterator create() {
                return new ValueIterator();
            }

            @Override
            public void initialize(ValueIterator obj) {
                obj.cursor.index = -1;
                obj.buffer = ObjectLinkedList.this.buffer;
                obj.pointers = ObjectLinkedList.this.beforeAfterPointers;
                obj.internalPos = 0;
            }

            @Override
            public void reset(ValueIterator obj) {
                obj.buffer = null;
                obj.pointers = null;
                obj.cursor.value = null;
            }
        });
        this.descendingValueIteratorPool = new IteratorPool(new ObjectFactory<DescendingValueIterator>(){

            @Override
            public DescendingValueIterator create() {
                return new DescendingValueIterator();
            }

            @Override
            public void initialize(DescendingValueIterator obj) {
                obj.cursor.index = ObjectLinkedList.this.size();
                obj.buffer = ObjectLinkedList.this.buffer;
                obj.pointers = ObjectLinkedList.this.beforeAfterPointers;
                obj.internalPos = 1;
            }

            @Override
            public void reset(DescendingValueIterator obj) {
                obj.buffer = null;
                obj.pointers = null;
                obj.cursor.value = null;
            }
        });
    }

    public ObjectLinkedList(ObjectContainer<? extends KType> container) {
        this(container.size());
        this.addAll(container);
    }

    @Override
    public void add(KType e1) {
        this.addLast(e1);
    }

    public void add(KType e1, KType e2) {
        this.ensureBufferSpace(2);
        this.insertAfterPosNoCheck(e1, (int)(this.beforeAfterPointers[1] >> 32));
        this.insertAfterPosNoCheck(e2, (int)(this.beforeAfterPointers[1] >> 32));
    }

    @Override
    public void addLast(KType ... elements) {
        this.addLast(elements, 0, elements.length);
    }

    public void addLast(KType[] elements, int start, int length) {
        assert (length + start <= elements.length) : "Length is smaller than required";
        this.ensureBufferSpace(length);
        long[] beforeAfterPointers = this.beforeAfterPointers;
        for (int i = 0; i < length; ++i) {
            this.insertAfterPosNoCheck(elements[start + i], (int)(beforeAfterPointers[1] >> 32));
        }
    }

    public void add(KType[] elements, int start, int length) {
        this.addLast(elements, start, length);
    }

    @Override
    public void add(KType ... elements) {
        this.addLast(elements, 0, elements.length);
    }

    public int addAll(ObjectContainer<? extends KType> container) {
        return this.addLast(container);
    }

    public int addAll(Iterable<? extends ObjectCursor<? extends KType>> iterable) {
        return this.addLast(iterable);
    }

    @Override
    public void insert(int index, KType e1) {
        assert (index >= 0 && index <= this.size()) : "Index " + index + " out of bounds [" + 0 + ", " + this.size() + "].";
        this.ensureBufferSpace(1);
        if (index == 0) {
            this.insertAfterPosNoCheck(e1, 0);
        } else {
            this.insertAfterPosNoCheck(e1, this.gotoIndex(index - 1));
        }
    }

    @Override
    public KType get(int index) {
        return (KType)this.buffer[this.gotoIndex(index)];
    }

    @Override
    public KType set(int index, KType e1) {
        int pos = this.gotoIndex(index);
        Object elem = this.buffer[pos];
        this.buffer[pos] = e1;
        return (KType)elem;
    }

    @Override
    public KType remove(int index) {
        int currentPos = this.gotoIndex(index);
        Object elem = this.buffer[currentPos];
        this.removeAtPosNoCheck(currentPos);
        return (KType)elem;
    }

    @Override
    public void removeRange(int fromIndex, int toIndex) {
        this.checkRangeBounds(fromIndex, toIndex);
        if (fromIndex == toIndex) {
            return;
        }
        int currentPos = this.gotoIndex(fromIndex);
        int size = toIndex - fromIndex;
        for (int count = 0; count < size; ++count) {
            currentPos = this.removeAtPosNoCheck(currentPos);
        }
    }

    @Override
    public int removeFirst(KType e1) {
        long[] pointers = this.beforeAfterPointers;
        Object[] buffer = this.buffer;
        int currentPos = (int)(pointers[0] & 0xFFFFFFFFL);
        int count = 0;
        while (currentPos != 1) {
            if (e1 == null ? buffer[currentPos] == null : e1.equals(buffer[currentPos])) {
                this.removeAtPosNoCheck(currentPos);
                return count;
            }
            currentPos = (int)(pointers[currentPos] & 0xFFFFFFFFL);
            ++count;
        }
        return -1;
    }

    @Override
    public int removeLast(KType e1) {
        long[] pointers = this.beforeAfterPointers;
        Object[] buffer = this.buffer;
        int size = this.size();
        int currentPos = (int)(pointers[1] >> 32);
        int count = 0;
        while (currentPos != 0) {
            if (e1 == null ? buffer[currentPos] == null : e1.equals(buffer[currentPos])) {
                this.removeAtPosNoCheck(currentPos);
                return size - count - 1;
            }
            currentPos = (int)(pointers[currentPos] >> 32);
            ++count;
        }
        return -1;
    }

    @Override
    public int removeAll(KType e1) {
        Object[] buffer = this.buffer;
        int deleted = 0;
        int pos = 2;
        while (pos < this.elementsCount) {
            if (e1 == null ? buffer[pos] == null : e1.equals(buffer[pos])) {
                this.removeAtPosNoCheck(pos);
                ++deleted;
                continue;
            }
            ++pos;
        }
        return deleted;
    }

    @Override
    public boolean contains(KType e1) {
        return this.indexOf(e1) >= 0;
    }

    @Override
    public int indexOf(KType e1) {
        long[] pointers = this.beforeAfterPointers;
        Object[] buffer = this.buffer;
        int currentPos = (int)(pointers[0] & 0xFFFFFFFFL);
        int count = 0;
        while (currentPos != 1) {
            if (e1 == null ? buffer[currentPos] == null : e1.equals(buffer[currentPos])) {
                return count;
            }
            currentPos = (int)(pointers[currentPos] & 0xFFFFFFFFL);
            ++count;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(KType e1) {
        long[] pointers = this.beforeAfterPointers;
        Object[] buffer = this.buffer;
        int currentPos = (int)(pointers[1] >> 32);
        int count = 0;
        while (currentPos != 0) {
            if (e1 == null ? buffer[currentPos] == null : e1.equals(buffer[currentPos])) {
                return this.size() - count - 1;
            }
            currentPos = (int)(pointers[currentPos] >> 32);
            ++count;
        }
        return -1;
    }

    public void ensureCapacity(int minCapacity) {
        if (minCapacity > this.buffer.length) {
            this.ensureBufferSpace(minCapacity - this.size());
        }
    }

    protected boolean ensureBufferSpace(int expectedAdditions) {
        int bufferLen;
        int n = bufferLen = this.buffer == null ? 0 : this.buffer.length;
        if (this.elementsCount > bufferLen - expectedAdditions) {
            int newSize = this.resizer.grow(bufferLen, this.elementsCount, expectedAdditions);
            if (this.buffer == null) {
                newSize += 2;
            }
            try {
                Object[] newBuffer = new Object[newSize];
                long[] newPointers = new long[newSize];
                if (bufferLen > 0) {
                    System.arraycopy(this.buffer, 0, newBuffer, 0, this.buffer.length);
                    System.arraycopy(this.beforeAfterPointers, 0, newPointers, 0, this.beforeAfterPointers.length);
                }
                this.buffer = newBuffer;
                this.beforeAfterPointers = newPointers;
            }
            catch (OutOfMemoryError e) {
                throw new BufferAllocationException("Not enough memory to allocate buffers to grow from %d -> %d elements", (Throwable)e, bufferLen, newSize);
            }
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this.elementsCount - 2;
    }

    @Override
    public int capacity() {
        return this.buffer.length - 2;
    }

    @Override
    public void clear() {
        ObjectArrays.blankArray(this.buffer, 0, this.elementsCount);
        this.elementsCount = 2;
        this.beforeAfterPointers[0] = 1L;
        this.beforeAfterPointers[1] = 1L;
    }

    @Override
    public KType[] toArray(KType[] target) {
        long[] pointers = this.beforeAfterPointers;
        Object[] buffer = this.buffer;
        int index = 0;
        int currentPos = (int)(pointers[0] & 0xFFFFFFFFL);
        while (currentPos != 1) {
            target[index] = buffer[currentPos];
            currentPos = (int)(pointers[currentPos] & 0xFFFFFFFFL);
            ++index;
        }
        return target;
    }

    public ObjectLinkedList<KType> clone() {
        ObjectLinkedList<KType> cloned = new ObjectLinkedList<KType>(8, this.resizer);
        cloned.buffer = (Object[])this.buffer.clone();
        cloned.beforeAfterPointers = (long[])this.beforeAfterPointers.clone();
        cloned.elementsCount = this.elementsCount;
        return cloned;
    }

    public int hashCode() {
        long[] pointers = this.beforeAfterPointers;
        Object[] buffer = this.buffer;
        int h2 = 1;
        int currentPos = (int)(pointers[0] & 0xFFFFFFFFL);
        while (currentPos != 1) {
            h2 = 31 * h2 + BitMixer.mix(buffer[currentPos]);
            currentPos = (int)(pointers[currentPos] & 0xFFFFFFFFL);
        }
        return h2;
    }

    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ObjectDeque) && !(obj instanceof ObjectIndexedContainer)) {
                return false;
            }
            ObjectContainer other = (ObjectContainer)obj;
            if (other.size() != this.size()) {
                return false;
            }
            ValueIterator it = this.iterator();
            AbstractIterator itOther = (AbstractIterator)other.iterator();
            while (it.hasNext()) {
                Object myVal = ((ObjectCursor)it.next()).value;
                Object otherVal = ((ObjectCursor)itOther.next()).value;
                if (myVal != null ? myVal.equals(otherVal) : otherVal == null) continue;
                it.release();
                itOther.release();
                return false;
            }
            itOther.release();
            return true;
        }
        return false;
    }

    protected int gotoIndex(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException("Index " + index + " out of bounds [" + 0 + ", size=" + this.size() + "[.");
        }
        int currentPos = 1;
        int currentIndex = -1;
        long[] pointers = this.beforeAfterPointers;
        if ((double)index <= (double)this.elementsCount / 2.0) {
            currentPos = (int)(pointers[0] & 0xFFFFFFFFL);
            for (currentIndex = 0; currentIndex < index && currentPos != 1; ++currentIndex) {
                currentPos = (int)(pointers[currentPos] & 0xFFFFFFFFL);
            }
        } else {
            currentPos = (int)(pointers[1] >> 32);
            for (currentIndex = this.size() - 1; currentIndex > index && currentPos != 0; --currentIndex) {
                currentPos = (int)(pointers[currentPos] >> 32);
            }
        }
        assert (currentIndex == index);
        return currentPos;
    }

    private void insertAfterPosNoCheck(KType e1, int insertionPos) {
        long[] pointers = this.beforeAfterPointers;
        int nextAfterInsertionPos = (int)(pointers[insertionPos] & 0xFFFFFFFFL);
        pointers[this.elementsCount] = (long)insertionPos << 32 | (long)nextAfterInsertionPos;
        pointers[insertionPos] = (long)this.elementsCount | pointers[insertionPos] & 0xFFFFFFFF00000000L;
        pointers[nextAfterInsertionPos] = (long)this.elementsCount << 32 | pointers[nextAfterInsertionPos] & 0xFFFFFFFFL;
        this.buffer[this.elementsCount] = e1;
        ++this.elementsCount;
    }

    private int removeAtPosNoCheck(int removalPos) {
        long[] pointers = this.beforeAfterPointers;
        int beforeRemovalPos = (int)(pointers[removalPos] >> 32);
        int afterRemovalPos = (int)(pointers[removalPos] & 0xFFFFFFFFL);
        pointers[beforeRemovalPos] = (long)afterRemovalPos | pointers[beforeRemovalPos] & 0xFFFFFFFF00000000L;
        pointers[afterRemovalPos] = (long)beforeRemovalPos << 32 | pointers[afterRemovalPos] & 0xFFFFFFFFL;
        if (removalPos != this.elementsCount - 1) {
            int beforeLastElementPos = (int)(pointers[this.elementsCount - 1] >> 32);
            int afterLastElementPos = (int)(pointers[this.elementsCount - 1] & 0xFFFFFFFFL);
            this.buffer[removalPos] = this.buffer[this.elementsCount - 1];
            pointers[removalPos] = pointers[this.elementsCount - 1];
            pointers[beforeLastElementPos] = (long)removalPos | pointers[beforeLastElementPos] & 0xFFFFFFFF00000000L;
            pointers[afterLastElementPos] = (long)removalPos << 32 | pointers[afterLastElementPos] & 0xFFFFFFFFL;
        }
        this.buffer[this.elementsCount - 1] = null;
        --this.elementsCount;
        return (int)(pointers[beforeRemovalPos] & 0xFFFFFFFFL);
    }

    public ValueIterator iterator() {
        return (ValueIterator)this.valueIteratorPool.borrow();
    }

    public DescendingValueIterator descendingIterator() {
        return (DescendingValueIterator)this.descendingValueIteratorPool.borrow();
    }

    @Override
    public <T extends ObjectProcedure<? super KType>> T forEach(T procedure) {
        this.forEach(procedure, 0, this.size());
        return procedure;
    }

    @Override
    public <T extends ObjectProcedure<? super KType>> T forEach(T procedure, int fromIndex, int toIndex) {
        this.internalForEach(procedure, fromIndex, toIndex);
        return procedure;
    }

    private void internalForEach(ObjectProcedure<? super KType> procedure, int fromIndex, int toIndex) {
        this.checkRangeBounds(fromIndex, toIndex);
        if (fromIndex == toIndex) {
            return;
        }
        int currentPos = this.gotoIndex(fromIndex);
        long[] pointers = this.beforeAfterPointers;
        Object[] buffer = this.buffer;
        int size = toIndex - fromIndex;
        for (int count = 0; count < size; ++count) {
            procedure.apply(buffer[currentPos]);
            currentPos = (int)(pointers[currentPos] & 0xFFFFFFFFL);
        }
    }

    @Override
    public <T extends ObjectPredicate<? super KType>> T forEach(T predicate) {
        this.forEach(predicate, 0, this.size());
        return predicate;
    }

    @Override
    public <T extends ObjectPredicate<? super KType>> T forEach(T predicate, int fromIndex, int toIndex) {
        this.internalForEach(predicate, fromIndex, toIndex);
        return predicate;
    }

    private void internalForEach(ObjectPredicate<? super KType> predicate, int fromIndex, int toIndex) {
        this.checkRangeBounds(fromIndex, toIndex);
        if (fromIndex == toIndex) {
            return;
        }
        int currentPos = this.gotoIndex(fromIndex);
        long[] pointers = this.beforeAfterPointers;
        Object[] buffer = this.buffer;
        int size = toIndex - fromIndex;
        for (int count = 0; count < size && predicate.apply(buffer[currentPos]); ++count) {
            currentPos = (int)(pointers[currentPos] & 0xFFFFFFFFL);
        }
    }

    @Override
    public <T extends ObjectProcedure<? super KType>> T descendingForEach(T procedure) {
        long[] pointers = this.beforeAfterPointers;
        Object[] buffer = this.buffer;
        int currentPos = (int)(pointers[1] >> 32);
        while (currentPos != 0) {
            procedure.apply((Object)buffer[currentPos]);
            currentPos = (int)(pointers[currentPos] >> 32);
        }
        return procedure;
    }

    @Override
    public <T extends ObjectPredicate<? super KType>> T descendingForEach(T predicate) {
        long[] pointers = this.beforeAfterPointers;
        Object[] buffer = this.buffer;
        int currentPos = (int)(pointers[1] >> 32);
        while (currentPos != 0 && predicate.apply((Object)buffer[currentPos])) {
            currentPos = (int)(pointers[currentPos] >> 32);
        }
        return predicate;
    }

    @Override
    public int removeAll(ObjectPredicate<? super KType> predicate) {
        Object[] buffer = this.buffer;
        int deleted = 0;
        int pos = 2;
        while (pos < this.elementsCount) {
            if (predicate.apply(buffer[pos])) {
                this.removeAtPosNoCheck(pos);
                ++deleted;
                continue;
            }
            ++pos;
        }
        return deleted;
    }

    public static <KType> ObjectLinkedList<KType> newInstance() {
        return new ObjectLinkedList<KType>();
    }

    public static <KType> ObjectLinkedList<KType> newInstance(int initialCapacity) {
        return new ObjectLinkedList<KType>(initialCapacity);
    }

    public static <KType> ObjectLinkedList<KType> from(KType ... elements) {
        ObjectLinkedList<KType> list = new ObjectLinkedList<KType>(elements.length);
        list.add(elements);
        return list;
    }

    public static <KType> ObjectLinkedList<KType> from(ObjectContainer<KType> container) {
        return new ObjectLinkedList<KType>(container);
    }

    public void sort(int beginIndex, int endIndex) {
        ObjectSort.quicksort(this, beginIndex, endIndex);
    }

    public void sort(int beginIndex, int endIndex, Comparator<? super KType> comp) {
        ObjectSort.quicksort(this, beginIndex, endIndex, comp);
    }

    public void sort() {
        if (this.elementsCount > 3) {
            int elementsCount = this.elementsCount;
            long[] pointers = this.beforeAfterPointers;
            ObjectSort.quicksort(this.buffer, 2, elementsCount);
            pointers[0] = 2L;
            pointers[2] = 3L;
            for (int pos = 3; pos < elementsCount - 1; ++pos) {
                pointers[pos] = (long)(pos - 1) << 32 | (long)(pos + 1);
            }
            pointers[elementsCount - 1] = (long)(elementsCount - 2) << 32 | 1L;
            pointers[1] = (long)(elementsCount - 1) << 32 | 1L;
        }
    }

    public void sort(Comparator<? super KType> comp) {
        if (this.elementsCount > 3) {
            int elementsCount = this.elementsCount;
            long[] pointers = this.beforeAfterPointers;
            ObjectSort.quicksort(this.buffer, 2, elementsCount, comp);
            pointers[0] = 2L;
            pointers[2] = 3L;
            for (int pos = 3; pos < elementsCount - 1; ++pos) {
                pointers[pos] = (long)(pos - 1) << 32 | (long)(pos + 1);
            }
            pointers[elementsCount - 1] = (long)(elementsCount - 2) << 32 | 1L;
            pointers[1] = (long)(elementsCount - 1) << 32 | 1L;
        }
    }

    @Override
    public void addFirst(KType e1) {
        this.ensureBufferSpace(1);
        this.insertAfterPosNoCheck(e1, 0);
    }

    public int addFirst(ObjectContainer<? extends KType> container) {
        return this.addFirst((Iterable<? extends ObjectCursor<? extends KType>>)container);
    }

    @Override
    public void addFirst(KType ... elements) {
        this.ensureBufferSpace(elements.length);
        for (int i = 0; i < elements.length; ++i) {
            this.insertAfterPosNoCheck(elements[i], 0);
        }
    }

    public int addFirst(Iterable<? extends ObjectCursor<? extends KType>> iterable) {
        int size = 0;
        for (ObjectCursor<KType> objectCursor : iterable) {
            this.ensureBufferSpace(1);
            this.insertAfterPosNoCheck(objectCursor.value, 0);
            ++size;
        }
        return size;
    }

    @Override
    public void addLast(KType e1) {
        this.ensureBufferSpace(1);
        this.insertAfterPosNoCheck(e1, (int)(this.beforeAfterPointers[1] >> 32));
    }

    public int addLast(ObjectContainer<? extends KType> container) {
        return this.addLast((Iterable<? extends ObjectCursor<? extends KType>>)container);
    }

    public int addLast(Iterable<? extends ObjectCursor<? extends KType>> iterable) {
        int size = 0;
        for (ObjectCursor<KType> objectCursor : iterable) {
            this.ensureBufferSpace(1);
            this.insertAfterPosNoCheck(objectCursor.value, (int)(this.beforeAfterPointers[1] >> 32));
            ++size;
        }
        return size;
    }

    @Override
    public KType removeFirst() {
        assert (this.size() > 0);
        int removedPos = (int)(this.beforeAfterPointers[0] & 0xFFFFFFFFL);
        Object elem = this.buffer[removedPos];
        this.removeAtPosNoCheck(removedPos);
        return (KType)elem;
    }

    @Override
    public KType removeLast() {
        assert (this.size() > 0);
        int removedPos = (int)(this.beforeAfterPointers[1] >> 32);
        Object elem = this.buffer[removedPos];
        this.removeAtPosNoCheck(removedPos);
        return (KType)elem;
    }

    @Override
    public KType getFirst() {
        assert (this.size() > 0);
        return (KType)this.buffer[(int)(this.beforeAfterPointers[0] & 0xFFFFFFFFL)];
    }

    @Override
    public KType getLast() {
        assert (this.size() > 0);
        return (KType)this.buffer[(int)(this.beforeAfterPointers[1] >> 32)];
    }

    private void checkRangeBounds(int beginIndex, int endIndex) {
        if (beginIndex > endIndex) {
            throw new IllegalArgumentException("Index beginIndex " + beginIndex + " is > endIndex " + endIndex);
        }
        if (beginIndex < 0) {
            throw new IndexOutOfBoundsException("Index beginIndex < 0");
        }
        if (endIndex > this.size()) {
            throw new IndexOutOfBoundsException("Index endIndex " + endIndex + " out of bounds [" + 0 + ", " + this.size() + "].");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class DescendingValueIterator
    extends ValueIterator {
        public DescendingValueIterator() {
            this.cursor.index = ObjectLinkedList.this.size();
            this.buffer = ObjectLinkedList.this.buffer;
            this.pointers = ObjectLinkedList.this.beforeAfterPointers;
            this.internalPos = 1;
        }

        @Override
        protected ObjectCursor<KType> fetch() {
            int previousPos;
            if (this.cursor.index == 0) {
                return (ObjectCursor)this.done();
            }
            this.internalPos = previousPos = (int)(this.pointers[this.internalPos] >> 32);
            --this.cursor.index;
            this.cursor.value = this.buffer[previousPos];
            return this.cursor;
        }

        @Override
        public boolean hasAfter() {
            return super.hasBefore();
        }

        @Override
        public boolean hasBefore() {
            return super.hasAfter();
        }

        @Override
        public ValueIterator gotoHead() {
            return super.gotoTail();
        }

        @Override
        public DescendingValueIterator gotoTail() {
            return (DescendingValueIterator)super.gotoHead();
        }

        @Override
        public DescendingValueIterator gotoNext() {
            return (DescendingValueIterator)super.gotoPrevious();
        }

        @Override
        public DescendingValueIterator gotoPrevious() {
            return (DescendingValueIterator)super.gotoNext();
        }

        @Override
        public KType getNext() {
            return super.getPrevious();
        }

        @Override
        public KType getPrevious() {
            return super.getNext();
        }

        @Override
        public KType removeNext() {
            return super.removePrevious();
        }

        @Override
        public KType removePrevious() {
            return super.removeNext();
        }

        @Override
        public void insertBefore(KType e1) {
            super.insertAfter(e1);
        }

        @Override
        public void insertAfter(KType e1) {
            super.insertBefore(e1);
        }

        @Override
        public DescendingValueIterator delete() {
            if (this.internalPos == 0 || this.internalPos == 1) {
                throw new IndexOutOfBoundsException("Cannot delete while pointing at head or tail");
            }
            int nextPos = ObjectLinkedList.this.removeAtPosNoCheck(this.internalPos);
            this.internalPos = (int)(this.pointers[nextPos] >> 32);
            this.cursor.value = this.buffer[this.internalPos];
            --this.cursor.index;
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ValueIterator
    extends AbstractIterator<ObjectCursor<KType>> {
        public final ObjectCursor<KType> cursor = new ObjectCursor();
        KType[] buffer;
        int internalPos;
        long[] pointers;

        public ValueIterator() {
            this.cursor.index = -1;
            this.buffer = ObjectLinkedList.this.buffer;
            this.pointers = ObjectLinkedList.this.beforeAfterPointers;
            this.internalPos = 0;
        }

        @Override
        protected ObjectCursor<KType> fetch() {
            int nextPos;
            if (this.cursor.index + 1 == ObjectLinkedList.this.size()) {
                return (ObjectCursor)this.done();
            }
            this.internalPos = nextPos = (int)(this.pointers[this.internalPos] & 0xFFFFFFFFL);
            ++this.cursor.index;
            this.cursor.value = this.buffer[nextPos];
            return this.cursor;
        }

        public boolean hasAfter() {
            int nextPos = (int)(this.pointers[this.internalPos] & 0xFFFFFFFFL);
            return nextPos != 1;
        }

        public boolean hasBefore() {
            int beforePos = (int)(this.pointers[this.internalPos] >> 32);
            return beforePos != 0;
        }

        public ValueIterator gotoHead() {
            this.internalPos = 0;
            this.cursor.index = -1;
            return this;
        }

        public ValueIterator gotoTail() {
            this.internalPos = 1;
            this.cursor.index = ObjectLinkedList.this.size();
            return this;
        }

        public ValueIterator gotoNext() {
            this.internalPos = (int)(this.pointers[this.internalPos] & 0xFFFFFFFFL);
            if (this.internalPos == 1) {
                this.cursor.index = ObjectLinkedList.this.size();
            } else {
                ++this.cursor.index;
                this.cursor.value = this.buffer[this.internalPos];
            }
            return this;
        }

        public ValueIterator gotoPrevious() {
            this.internalPos = (int)(this.pointers[this.internalPos] >> 32);
            if (this.internalPos == 0) {
                this.cursor.index = -1;
            } else {
                --this.cursor.index;
                this.cursor.value = this.buffer[this.internalPos];
            }
            return this;
        }

        public KType getNext() {
            int nextPos = (int)(this.pointers[this.internalPos] & 0xFFFFFFFFL);
            if (nextPos == 1) {
                throw new NoSuchElementException("Either no next element (forward iterator) or previous element (backward iterator)");
            }
            return this.buffer[nextPos];
        }

        public KType getPrevious() {
            int beforePos = (int)(this.pointers[this.internalPos] >> 32);
            if (beforePos == 0) {
                throw new NoSuchElementException("Either no previous element (forward iterator) or next element (backward iterator)");
            }
            return this.buffer[beforePos];
        }

        public KType removeNext() {
            int nextPos = (int)(this.pointers[this.internalPos] & 0xFFFFFFFFL);
            if (nextPos == 1) {
                throw new NoSuchElementException("Either no next element to remove (forward iterator) or previous element to remove (backward iterator)");
            }
            Object value = this.buffer[nextPos];
            ObjectLinkedList.this.removeAtPosNoCheck(nextPos);
            return value;
        }

        public KType removePrevious() {
            int previousPos = (int)(this.pointers[this.internalPos] >> 32);
            if (previousPos == 0) {
                throw new NoSuchElementException("Either no previous element to remove (forward iterator) or next element to remove (backward iterator)");
            }
            Object value = this.buffer[previousPos];
            this.internalPos = ObjectLinkedList.this.removeAtPosNoCheck(previousPos);
            --this.cursor.index;
            return value;
        }

        public void insertBefore(KType e1) {
            if (this.internalPos == 0) {
                throw new IndexOutOfBoundsException("Either cannot insert before (forward iterator) or insert after (backward iterator)");
            }
            if (ObjectLinkedList.this.ensureBufferSpace(1)) {
                this.pointers = ObjectLinkedList.this.beforeAfterPointers;
                this.buffer = ObjectLinkedList.this.buffer;
            }
            int beforePos = (int)(this.pointers[this.internalPos] >> 32);
            ObjectLinkedList.this.insertAfterPosNoCheck(e1, beforePos);
            ++this.cursor.index;
        }

        public void insertAfter(KType e1) {
            if (this.internalPos == 1) {
                throw new IndexOutOfBoundsException("Either cannot insert after (forward iterator) or insert before (backward iterator)");
            }
            if (ObjectLinkedList.this.ensureBufferSpace(1)) {
                this.pointers = ObjectLinkedList.this.beforeAfterPointers;
                this.buffer = ObjectLinkedList.this.buffer;
            }
            ObjectLinkedList.this.insertAfterPosNoCheck(e1, this.internalPos);
        }

        public void set(KType e1) {
            if (this.internalPos == 0 || this.internalPos == 1) {
                throw new IndexOutOfBoundsException("Cannot set while pointing at head or tail");
            }
            this.buffer[this.internalPos] = e1;
            this.cursor.value = e1;
        }

        public ValueIterator delete() {
            if (this.internalPos == 0 || this.internalPos == 1) {
                throw new IndexOutOfBoundsException("Cannot delete while pointing at head or tail");
            }
            this.internalPos = ObjectLinkedList.this.removeAtPosNoCheck(this.internalPos);
            this.cursor.value = this.buffer[this.internalPos];
            return this;
        }
    }
}

