/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppcrt.maps;

import com.carrotsearch.hppcrt.AbstractCharCollection;
import com.carrotsearch.hppcrt.AbstractDoubleCollection;
import com.carrotsearch.hppcrt.AbstractIterator;
import com.carrotsearch.hppcrt.BufferAllocationException;
import com.carrotsearch.hppcrt.Containers;
import com.carrotsearch.hppcrt.DoubleArrays;
import com.carrotsearch.hppcrt.DoubleCharAssociativeContainer;
import com.carrotsearch.hppcrt.DoubleCharMap;
import com.carrotsearch.hppcrt.DoubleContainer;
import com.carrotsearch.hppcrt.DoubleLookupContainer;
import com.carrotsearch.hppcrt.HashContainers;
import com.carrotsearch.hppcrt.IteratorPool;
import com.carrotsearch.hppcrt.ObjectFactory;
import com.carrotsearch.hppcrt.cursors.CharCursor;
import com.carrotsearch.hppcrt.cursors.DoubleCharCursor;
import com.carrotsearch.hppcrt.cursors.DoubleCursor;
import com.carrotsearch.hppcrt.hash.BitMixer;
import com.carrotsearch.hppcrt.predicates.CharPredicate;
import com.carrotsearch.hppcrt.predicates.DoubleCharPredicate;
import com.carrotsearch.hppcrt.predicates.DoublePredicate;
import com.carrotsearch.hppcrt.procedures.CharProcedure;
import com.carrotsearch.hppcrt.procedures.DoubleCharProcedure;
import com.carrotsearch.hppcrt.procedures.DoubleProcedure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoubleCharHashMap
implements DoubleCharMap,
Cloneable {
    protected char defaultValue = '\u0000';
    public double[] keys;
    public char[] values;
    public boolean allocatedDefaultKey = false;
    public char allocatedDefaultKeyValue;
    protected int assigned;
    protected final double loadFactor;
    private int resizeAt;
    private final int perturbation = Containers.randomSeed32();
    protected final IteratorPool<DoubleCharCursor, EntryIterator> entryIteratorPool = new IteratorPool(new ObjectFactory<EntryIterator>(){

        @Override
        public EntryIterator create() {
            return new EntryIterator();
        }

        @Override
        public void initialize(EntryIterator obj) {
            obj.cursor.index = DoubleCharHashMap.this.keys.length + 1;
        }

        @Override
        public void reset(EntryIterator obj) {
        }
    });

    public DoubleCharHashMap() {
        this(8);
    }

    public DoubleCharHashMap(int initialCapacity) {
        this(initialCapacity, 0.75);
    }

    public DoubleCharHashMap(int initialCapacity, double loadFactor) {
        this.loadFactor = loadFactor;
        this.allocateBuffers(HashContainers.minBufferSize(initialCapacity, loadFactor));
    }

    public DoubleCharHashMap(DoubleCharAssociativeContainer container) {
        this(container.size());
        this.putAll(container);
    }

    @Override
    public char put(double key, char value) {
        double existing;
        if (Double.doubleToLongBits(key) == 0L) {
            if (this.allocatedDefaultKey) {
                char previousValue = this.allocatedDefaultKeyValue;
                this.allocatedDefaultKeyValue = value;
                return previousValue;
            }
            this.allocatedDefaultKeyValue = value;
            this.allocatedDefaultKey = true;
            return this.defaultValue;
        }
        int mask = this.keys.length - 1;
        double[] keys = this.keys;
        int slot = BitMixer.mix(key, this.perturbation) & mask;
        while (Double.doubleToLongBits(existing = keys[slot]) != 0L) {
            if (Double.doubleToLongBits(key) == Double.doubleToLongBits(existing)) {
                char oldValue = this.values[slot];
                this.values[slot] = value;
                return oldValue;
            }
            slot = slot + 1 & mask;
        }
        if (this.assigned == this.resizeAt) {
            this.expandAndPut(key, value, slot);
        } else {
            ++this.assigned;
            keys[slot] = key;
            this.values[slot] = value;
        }
        return this.defaultValue;
    }

    @Override
    public int putAll(DoubleCharAssociativeContainer container) {
        return this.putAll((Iterable<? extends DoubleCharCursor>)container);
    }

    @Override
    public int putAll(Iterable<? extends DoubleCharCursor> iterable) {
        int count = this.size();
        for (DoubleCharCursor doubleCharCursor : iterable) {
            this.put(doubleCharCursor.key, doubleCharCursor.value);
        }
        return this.size() - count;
    }

    @Override
    public boolean putIfAbsent(double key, char value) {
        if (!this.containsKey(key)) {
            this.put(key, value);
            return true;
        }
        return false;
    }

    @Override
    public char putOrAdd(double key, char putValue, char incrementValue) {
        if (this.containsKey(key)) {
            putValue = this.get(key);
            putValue = (char)(putValue + incrementValue);
        }
        this.put(key, putValue);
        return putValue;
    }

    @Override
    public char addTo(double key, char incrementValue) {
        return this.putOrAdd(key, incrementValue, incrementValue);
    }

    private void expandAndPut(double pendingKey, char pendingValue, int freeSlot) {
        assert (this.assigned == this.resizeAt);
        assert (Double.doubleToLongBits(pendingKey) != 0L);
        double[] oldKeys = this.keys;
        char[] oldValues = this.values;
        this.allocateBuffers(HashContainers.nextBufferSize(this.keys.length, this.assigned, this.loadFactor));
        ++this.assigned;
        oldKeys[freeSlot] = pendingKey;
        oldValues[freeSlot] = pendingValue;
        int mask = this.keys.length - 1;
        double key = 0.0;
        char value = '\u0000';
        int slot = -1;
        double[] keys = this.keys;
        char[] values = this.values;
        int perturb = this.perturbation;
        int i = oldKeys.length;
        while (--i >= 0) {
            key = oldKeys[i];
            if (Double.doubleToLongBits(key) == 0L) continue;
            value = oldValues[i];
            slot = BitMixer.mix(key, perturb) & mask;
            while (Double.doubleToLongBits(keys[slot]) != 0L) {
                slot = slot + 1 & mask;
            }
            keys[slot] = key;
            values[slot] = value;
        }
    }

    private void allocateBuffers(int capacity) {
        try {
            double[] keys = new double[capacity];
            char[] values = new char[capacity];
            this.keys = keys;
            this.values = values;
            this.resizeAt = HashContainers.expandAtCount(capacity, this.loadFactor);
        }
        catch (OutOfMemoryError e) {
            throw new BufferAllocationException("Not enough memory to allocate buffers to grow from %d -> %d elements", (Throwable)e, this.keys == null ? 0 : this.keys.length, capacity);
        }
    }

    @Override
    public char remove(double key) {
        double existing;
        if (Double.doubleToLongBits(key) == 0L) {
            if (this.allocatedDefaultKey) {
                char previousValue = this.allocatedDefaultKeyValue;
                this.allocatedDefaultKey = false;
                return previousValue;
            }
            return this.defaultValue;
        }
        int mask = this.keys.length - 1;
        double[] keys = this.keys;
        int slot = BitMixer.mix(key, this.perturbation) & mask;
        while (Double.doubleToLongBits(existing = keys[slot]) != 0L) {
            if (Double.doubleToLongBits(key) == Double.doubleToLongBits(existing)) {
                char value = this.values[slot];
                this.shiftConflictingKeys(slot);
                return value;
            }
            slot = slot + 1 & mask;
        }
        return this.defaultValue;
    }

    private void shiftConflictingKeys(int gapSlot) {
        int mask = this.keys.length - 1;
        double[] keys = this.keys;
        char[] values = this.values;
        int perturb = this.perturbation;
        int distance = 0;
        while (true) {
            int slot = gapSlot + ++distance & mask;
            double existing = keys[slot];
            char existingValue = values[slot];
            if (Double.doubleToLongBits(existing) == 0L) break;
            int idealSlotModMask = BitMixer.mix(existing, perturb) & mask;
            int shift = slot - idealSlotModMask & mask;
            if (shift < distance) continue;
            keys[gapSlot] = existing;
            values[gapSlot] = existingValue;
            gapSlot = slot;
            distance = 0;
        }
        keys[gapSlot] = 0.0;
        --this.assigned;
    }

    @Override
    public int removeAll(DoubleContainer other) {
        int before = this.size();
        if (other.size() >= before && other instanceof DoubleLookupContainer) {
            if (this.allocatedDefaultKey && other.contains(0.0)) {
                this.allocatedDefaultKey = false;
            }
            double[] keys = this.keys;
            int i = 0;
            while (i < keys.length) {
                double existing = keys[i];
                if (Double.doubleToLongBits(existing) != 0L && other.contains(existing)) {
                    this.shiftConflictingKeys(i);
                    continue;
                }
                ++i;
            }
        } else {
            for (DoubleCursor c : other) {
                this.remove(c.value);
            }
        }
        return before - this.size();
    }

    @Override
    public int removeAll(DoublePredicate predicate) {
        int before = this.size();
        if (this.allocatedDefaultKey && predicate.apply(0.0)) {
            this.allocatedDefaultKey = false;
        }
        double[] keys = this.keys;
        int i = 0;
        while (i < keys.length) {
            double existing = keys[i];
            if (Double.doubleToLongBits(existing) != 0L && predicate.apply(existing)) {
                this.shiftConflictingKeys(i);
                continue;
            }
            ++i;
        }
        return before - this.size();
    }

    @Override
    public int removeAll(DoubleCharPredicate predicate) {
        int before = this.size();
        if (this.allocatedDefaultKey && predicate.apply(0.0, this.allocatedDefaultKeyValue)) {
            this.allocatedDefaultKey = false;
        }
        double[] keys = this.keys;
        char[] values = this.values;
        int i = 0;
        while (i < keys.length) {
            double existing = keys[i];
            if (Double.doubleToLongBits(existing) != 0L && predicate.apply(existing, values[i])) {
                this.shiftConflictingKeys(i);
                continue;
            }
            ++i;
        }
        return before - this.size();
    }

    @Override
    public char get(double key) {
        double existing;
        if (Double.doubleToLongBits(key) == 0L) {
            if (this.allocatedDefaultKey) {
                return this.allocatedDefaultKeyValue;
            }
            return this.defaultValue;
        }
        int mask = this.keys.length - 1;
        double[] keys = this.keys;
        int slot = BitMixer.mix(key, this.perturbation) & mask;
        while (Double.doubleToLongBits(existing = keys[slot]) != 0L) {
            if (Double.doubleToLongBits(key) == Double.doubleToLongBits(existing)) {
                return this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return this.defaultValue;
    }

    @Override
    public boolean containsKey(double key) {
        double existing;
        if (Double.doubleToLongBits(key) == 0L) {
            return this.allocatedDefaultKey;
        }
        int mask = this.keys.length - 1;
        double[] keys = this.keys;
        int slot = BitMixer.mix(key, this.perturbation) & mask;
        while (Double.doubleToLongBits(existing = keys[slot]) != 0L) {
            if (Double.doubleToLongBits(key) == Double.doubleToLongBits(existing)) {
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.allocatedDefaultKey = false;
        DoubleArrays.blankArray(this.keys, 0, this.keys.length);
    }

    @Override
    public int size() {
        return this.assigned + (this.allocatedDefaultKey ? 1 : 0);
    }

    @Override
    public int capacity() {
        return this.resizeAt;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int hashCode() {
        int h2 = 0;
        if (this.allocatedDefaultKey) {
            h2 += BitMixer.mix(this.allocatedDefaultKeyValue);
        }
        double[] keys = this.keys;
        char[] values = this.values;
        int i = keys.length;
        while (--i >= 0) {
            double existing = keys[i];
            if (Double.doubleToLongBits(existing) == 0L) continue;
            h2 += BitMixer.mix(existing) ^ BitMixer.mix(values[i]);
        }
        return h2;
    }

    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            DoubleCharHashMap other = (DoubleCharHashMap)obj;
            if (other.size() != this.size()) {
                return false;
            }
            EntryIterator it = this.iterator();
            while (it.hasNext()) {
                DoubleCharCursor c = (DoubleCharCursor)it.next();
                if (!other.containsKey(c.key)) {
                    it.release();
                    return false;
                }
                char otherValue = other.get(c.key);
                if (c.value == otherValue) continue;
                it.release();
                return false;
            }
            return true;
        }
        return false;
    }

    public EntryIterator iterator() {
        return (EntryIterator)this.entryIteratorPool.borrow();
    }

    @Override
    public <T extends DoubleCharProcedure> T forEach(T procedure) {
        if (this.allocatedDefaultKey) {
            procedure.apply(0.0, this.allocatedDefaultKeyValue);
        }
        double[] keys = this.keys;
        char[] values = this.values;
        for (int i = keys.length - 1; i >= 0; --i) {
            double existing = keys[i];
            if (Double.doubleToLongBits(existing) == 0L) continue;
            procedure.apply(existing, values[i]);
        }
        return procedure;
    }

    @Override
    public <T extends DoubleCharPredicate> T forEach(T predicate) {
        double existing;
        if (this.allocatedDefaultKey && !predicate.apply(0.0, this.allocatedDefaultKeyValue)) {
            return predicate;
        }
        double[] keys = this.keys;
        char[] values = this.values;
        for (int i = keys.length - 1; i >= 0 && (Double.doubleToLongBits(existing = keys[i]) == 0L || predicate.apply(existing, values[i])); --i) {
        }
        return predicate;
    }

    @Override
    public KeysCollection keys() {
        return new KeysCollection();
    }

    @Override
    public ValuesCollection values() {
        return new ValuesCollection();
    }

    public DoubleCharHashMap clone() {
        DoubleCharHashMap cloned = new DoubleCharHashMap(this.size(), this.loadFactor);
        cloned.putAll(this);
        return cloned;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        boolean first = true;
        for (DoubleCharCursor cursor : this) {
            if (!first) {
                buffer.append(", ");
            }
            buffer.append(cursor.key);
            buffer.append("=>");
            buffer.append(cursor.value);
            first = false;
        }
        buffer.append("]");
        return buffer.toString();
    }

    public static DoubleCharHashMap from(double[] keys, char[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        DoubleCharHashMap map = new DoubleCharHashMap(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }

    public static DoubleCharHashMap from(DoubleCharAssociativeContainer container) {
        return new DoubleCharHashMap(container);
    }

    public static DoubleCharHashMap newInstance() {
        return new DoubleCharHashMap();
    }

    public static DoubleCharHashMap newInstance(int initialCapacity, double loadFactor) {
        return new DoubleCharHashMap(initialCapacity, loadFactor);
    }

    @Override
    public char getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public void setDefaultValue(char defaultValue) {
        this.defaultValue = defaultValue;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class ValuesIterator
    extends AbstractIterator<CharCursor> {
        public final CharCursor cursor = new CharCursor();

        public ValuesIterator() {
            this.cursor.index = -2;
        }

        @Override
        protected CharCursor fetch() {
            int i;
            if (this.cursor.index == DoubleCharHashMap.this.values.length + 1) {
                if (DoubleCharHashMap.this.allocatedDefaultKey) {
                    this.cursor.index = DoubleCharHashMap.this.values.length;
                    this.cursor.value = DoubleCharHashMap.this.allocatedDefaultKeyValue;
                    return this.cursor;
                }
                this.cursor.index = DoubleCharHashMap.this.keys.length;
            }
            for (i = this.cursor.index - 1; i >= 0 && Double.doubleToLongBits(DoubleCharHashMap.this.keys[i]) == 0L; --i) {
            }
            if (i == -1) {
                return (CharCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = DoubleCharHashMap.this.values[i];
            return this.cursor;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class ValuesCollection
    extends AbstractCharCollection {
        private final DoubleCharHashMap owner;
        protected final IteratorPool<CharCursor, ValuesIterator> valuesIteratorPool;

        public ValuesCollection() {
            this.owner = DoubleCharHashMap.this;
            this.valuesIteratorPool = new IteratorPool(new ObjectFactory<ValuesIterator>(){

                @Override
                public ValuesIterator create() {
                    return new ValuesIterator();
                }

                @Override
                public void initialize(ValuesIterator obj) {
                    obj.cursor.index = DoubleCharHashMap.this.keys.length + 1;
                }

                @Override
                public void reset(ValuesIterator obj) {
                }
            });
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public int capacity() {
            return this.owner.capacity();
        }

        @Override
        public boolean contains(char value) {
            if (this.owner.allocatedDefaultKey && value == this.owner.allocatedDefaultKeyValue) {
                return true;
            }
            double[] keys = this.owner.keys;
            char[] values = this.owner.values;
            for (int slot = 0; slot < keys.length; ++slot) {
                if (Double.doubleToLongBits(keys[slot]) == 0L || value != values[slot]) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends CharProcedure> T forEach(T procedure) {
            if (this.owner.allocatedDefaultKey) {
                procedure.apply(this.owner.allocatedDefaultKeyValue);
            }
            double[] keys = this.owner.keys;
            char[] values = this.owner.values;
            for (int slot = 0; slot < keys.length; ++slot) {
                if (Double.doubleToLongBits(keys[slot]) == 0L) continue;
                procedure.apply(values[slot]);
            }
            return procedure;
        }

        @Override
        public <T extends CharPredicate> T forEach(T predicate) {
            if (this.owner.allocatedDefaultKey && !predicate.apply(this.owner.allocatedDefaultKeyValue)) {
                return predicate;
            }
            double[] keys = this.owner.keys;
            char[] values = this.owner.values;
            for (int slot = 0; slot < keys.length && (Double.doubleToLongBits(keys[slot]) == 0L || predicate.apply(values[slot])); ++slot) {
            }
            return predicate;
        }

        public ValuesIterator iterator() {
            return (ValuesIterator)this.valuesIteratorPool.borrow();
        }

        @Override
        public int removeAll(char e) {
            int before = this.owner.size();
            if (this.owner.allocatedDefaultKey && e == this.owner.allocatedDefaultKeyValue) {
                this.owner.allocatedDefaultKey = false;
            }
            double[] keys = this.owner.keys;
            char[] values = this.owner.values;
            int slot = 0;
            while (slot < keys.length) {
                if (Double.doubleToLongBits(keys[slot]) != 0L && e == values[slot]) {
                    DoubleCharHashMap.this.shiftConflictingKeys(slot);
                    continue;
                }
                ++slot;
            }
            return before - this.owner.size();
        }

        @Override
        public int removeAll(CharPredicate predicate) {
            int before = this.owner.size();
            if (this.owner.allocatedDefaultKey && predicate.apply(this.owner.allocatedDefaultKeyValue)) {
                this.owner.allocatedDefaultKey = false;
            }
            double[] keys = this.owner.keys;
            char[] values = this.owner.values;
            int slot = 0;
            while (slot < keys.length) {
                if (Double.doubleToLongBits(keys[slot]) != 0L && predicate.apply(values[slot])) {
                    DoubleCharHashMap.this.shiftConflictingKeys(slot);
                    continue;
                }
                ++slot;
            }
            return before - this.owner.size();
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public char[] toArray(char[] target) {
            int count = 0;
            if (this.owner.allocatedDefaultKey) {
                target[count++] = this.owner.allocatedDefaultKeyValue;
            }
            double[] keys = this.owner.keys;
            char[] values = this.owner.values;
            for (int i = 0; i < values.length; ++i) {
                if (Double.doubleToLongBits(keys[i]) == 0L) continue;
                target[count++] = values[i];
            }
            assert (count == this.owner.size());
            return target;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class KeysIterator
    extends AbstractIterator<DoubleCursor> {
        public final DoubleCursor cursor = new DoubleCursor();

        public KeysIterator() {
            this.cursor.index = -2;
        }

        @Override
        protected DoubleCursor fetch() {
            int i;
            if (this.cursor.index == DoubleCharHashMap.this.keys.length + 1) {
                if (DoubleCharHashMap.this.allocatedDefaultKey) {
                    this.cursor.index = DoubleCharHashMap.this.keys.length;
                    this.cursor.value = 0.0;
                    return this.cursor;
                }
                this.cursor.index = DoubleCharHashMap.this.keys.length;
            }
            for (i = this.cursor.index - 1; i >= 0 && Double.doubleToLongBits(DoubleCharHashMap.this.keys[i]) == 0L; --i) {
            }
            if (i == -1) {
                return (DoubleCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = DoubleCharHashMap.this.keys[i];
            return this.cursor;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class KeysCollection
    extends AbstractDoubleCollection
    implements DoubleLookupContainer {
        private final DoubleCharHashMap owner;
        protected final IteratorPool<DoubleCursor, KeysIterator> keyIteratorPool;

        public KeysCollection() {
            this.owner = DoubleCharHashMap.this;
            this.keyIteratorPool = new IteratorPool(new ObjectFactory<KeysIterator>(){

                @Override
                public KeysIterator create() {
                    return new KeysIterator();
                }

                @Override
                public void initialize(KeysIterator obj) {
                    obj.cursor.index = DoubleCharHashMap.this.keys.length + 1;
                }

                @Override
                public void reset(KeysIterator obj) {
                }
            });
        }

        @Override
        public boolean contains(double e) {
            return DoubleCharHashMap.this.containsKey(e);
        }

        @Override
        public <T extends DoubleProcedure> T forEach(T procedure) {
            if (this.owner.allocatedDefaultKey) {
                procedure.apply(0.0);
            }
            double[] keys = this.owner.keys;
            for (int i = keys.length - 1; i >= 0; --i) {
                double existing = keys[i];
                if (Double.doubleToLongBits(existing) == 0L) continue;
                procedure.apply(existing);
            }
            return procedure;
        }

        @Override
        public <T extends DoublePredicate> T forEach(T predicate) {
            double existing;
            if (this.owner.allocatedDefaultKey && !predicate.apply(0.0)) {
                return predicate;
            }
            double[] keys = this.owner.keys;
            for (int i = keys.length - 1; i >= 0 && (Double.doubleToLongBits(existing = keys[i]) == 0L || predicate.apply(existing)); --i) {
            }
            return predicate;
        }

        public KeysIterator iterator() {
            return (KeysIterator)this.keyIteratorPool.borrow();
        }

        @Override
        public int size() {
            return this.owner.size();
        }

        @Override
        public int capacity() {
            return this.owner.capacity();
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public int removeAll(DoublePredicate predicate) {
            return this.owner.removeAll(predicate);
        }

        @Override
        public int removeAll(double e) {
            boolean hasKey = this.owner.containsKey(e);
            int result = 0;
            if (hasKey) {
                this.owner.remove(e);
                result = 1;
            }
            return result;
        }

        @Override
        public double[] toArray(double[] target) {
            int count = 0;
            if (this.owner.allocatedDefaultKey) {
                target[count++] = 0.0;
            }
            double[] keys = this.owner.keys;
            for (int i = 0; i < keys.length; ++i) {
                double existing = keys[i];
                if (Double.doubleToLongBits(existing) == 0L) continue;
                target[count++] = existing;
            }
            assert (count == this.owner.size());
            return target;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class EntryIterator
    extends AbstractIterator<DoubleCharCursor> {
        public final DoubleCharCursor cursor = new DoubleCharCursor();

        public EntryIterator() {
            this.cursor.index = -2;
        }

        @Override
        protected DoubleCharCursor fetch() {
            int i;
            if (this.cursor.index == DoubleCharHashMap.this.keys.length + 1) {
                if (DoubleCharHashMap.this.allocatedDefaultKey) {
                    this.cursor.index = DoubleCharHashMap.this.keys.length;
                    this.cursor.key = 0.0;
                    this.cursor.value = DoubleCharHashMap.this.allocatedDefaultKeyValue;
                    return this.cursor;
                }
                this.cursor.index = DoubleCharHashMap.this.keys.length;
            }
            for (i = this.cursor.index - 1; i >= 0 && Double.doubleToLongBits(DoubleCharHashMap.this.keys[i]) == 0L; --i) {
            }
            if (i == -1) {
                return (DoubleCharCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.key = DoubleCharHashMap.this.keys[i];
            this.cursor.value = DoubleCharHashMap.this.values[i];
            return this.cursor;
        }
    }
}

