/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppcrt.sets;

import com.carrotsearch.hppcrt.AbstractDoubleCollection;
import com.carrotsearch.hppcrt.AbstractIterator;
import com.carrotsearch.hppcrt.BufferAllocationException;
import com.carrotsearch.hppcrt.Containers;
import com.carrotsearch.hppcrt.DoubleArrays;
import com.carrotsearch.hppcrt.DoubleContainer;
import com.carrotsearch.hppcrt.DoubleLookupContainer;
import com.carrotsearch.hppcrt.DoubleSet;
import com.carrotsearch.hppcrt.HashContainers;
import com.carrotsearch.hppcrt.IteratorPool;
import com.carrotsearch.hppcrt.ObjectFactory;
import com.carrotsearch.hppcrt.cursors.DoubleCursor;
import com.carrotsearch.hppcrt.hash.BitMixer;
import com.carrotsearch.hppcrt.predicates.DoublePredicate;
import com.carrotsearch.hppcrt.procedures.DoubleProcedure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoubleHashSet
extends AbstractDoubleCollection
implements DoubleLookupContainer,
DoubleSet,
Cloneable {
    public double[] keys;
    public boolean allocatedDefaultKey = false;
    protected int assigned;
    protected final double loadFactor;
    private int resizeAt;
    private final int perturbation = Containers.randomSeed32();
    protected final IteratorPool<DoubleCursor, EntryIterator> entryIteratorPool = new IteratorPool(new ObjectFactory<EntryIterator>(){

        @Override
        public EntryIterator create() {
            return new EntryIterator();
        }

        @Override
        public void initialize(EntryIterator obj) {
            obj.cursor.index = DoubleHashSet.this.keys.length + 1;
        }

        @Override
        public void reset(EntryIterator obj) {
        }
    });

    public DoubleHashSet() {
        this(8, 0.75);
    }

    public DoubleHashSet(int initialCapacity) {
        this(initialCapacity, 0.75);
    }

    public DoubleHashSet(int initialCapacity, double loadFactor) {
        this.loadFactor = loadFactor;
        this.allocateBuffers(HashContainers.minBufferSize(initialCapacity, loadFactor));
    }

    public DoubleHashSet(DoubleContainer container) {
        this(container.size());
        this.addAll(container);
    }

    @Override
    public boolean add(double key) {
        double existing;
        if (Double.doubleToLongBits(key) == 0L) {
            if (this.allocatedDefaultKey) {
                return false;
            }
            this.allocatedDefaultKey = true;
            return true;
        }
        int mask = this.keys.length - 1;
        double[] keys = this.keys;
        int slot = BitMixer.mix(key, this.perturbation) & mask;
        while (Double.doubleToLongBits(existing = keys[slot]) != 0L) {
            if (Double.doubleToLongBits(key) == Double.doubleToLongBits(existing)) {
                return false;
            }
            slot = slot + 1 & mask;
        }
        if (this.assigned == this.resizeAt) {
            this.expandAndAdd(key, slot);
        } else {
            ++this.assigned;
            keys[slot] = key;
        }
        return true;
    }

    public int add(double e1, double e2) {
        int count = 0;
        if (this.add(e1)) {
            ++count;
        }
        if (this.add(e2)) {
            ++count;
        }
        return count;
    }

    public int add(double ... elements) {
        int count = 0;
        for (double e : elements) {
            if (!this.add(e)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int addAll(DoubleContainer container) {
        return this.addAll((Iterable<? extends DoubleCursor>)container);
    }

    @Override
    public int addAll(Iterable<? extends DoubleCursor> iterable) {
        int count = 0;
        for (DoubleCursor doubleCursor : iterable) {
            if (!this.add(doubleCursor.value)) continue;
            ++count;
        }
        return count;
    }

    private void expandAndAdd(double pendingKey, int freeSlot) {
        assert (this.assigned == this.resizeAt);
        assert (Double.doubleToLongBits(pendingKey) != 0L);
        double[] oldKeys = this.keys;
        this.allocateBuffers(HashContainers.nextBufferSize(this.keys.length, this.assigned, this.loadFactor));
        ++this.assigned;
        oldKeys[freeSlot] = pendingKey;
        int mask = this.keys.length - 1;
        double key = 0.0;
        int slot = -1;
        double[] keys = this.keys;
        int perturb = this.perturbation;
        int i = oldKeys.length;
        while (--i >= 0) {
            key = oldKeys[i];
            if (Double.doubleToLongBits(key) == 0L) continue;
            slot = BitMixer.mix(key, perturb) & mask;
            while (Double.doubleToLongBits(keys[slot]) != 0L) {
                slot = slot + 1 & mask;
            }
            keys[slot] = key;
        }
    }

    private void allocateBuffers(int capacity) {
        try {
            double[] keys = new double[capacity];
            this.keys = keys;
            this.resizeAt = HashContainers.expandAtCount(capacity, this.loadFactor);
        }
        catch (OutOfMemoryError e) {
            throw new BufferAllocationException("Not enough memory to allocate buffers to grow from %d -> %d elements", (Throwable)e, this.keys == null ? 0 : this.keys.length, capacity);
        }
    }

    @Override
    public int removeAll(double key) {
        return this.remove(key) ? 1 : 0;
    }

    @Override
    public boolean remove(double key) {
        double existing;
        if (Double.doubleToLongBits(key) == 0L) {
            if (this.allocatedDefaultKey) {
                this.allocatedDefaultKey = false;
                return true;
            }
            return false;
        }
        int mask = this.keys.length - 1;
        double[] keys = this.keys;
        int slot = BitMixer.mix(key, this.perturbation) & mask;
        while (Double.doubleToLongBits(existing = keys[slot]) != 0L) {
            if (Double.doubleToLongBits(key) == Double.doubleToLongBits(existing)) {
                this.shiftConflictingKeys(slot);
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    private void shiftConflictingKeys(int gapSlot) {
        int slot;
        double existing;
        int mask = this.keys.length - 1;
        double[] keys = this.keys;
        int perturb = this.perturbation;
        int distance = 0;
        while (Double.doubleToLongBits(existing = keys[slot = gapSlot + ++distance & mask]) != 0L) {
            int idealSlotModMask = BitMixer.mix(existing, perturb) & mask;
            int shift = slot - idealSlotModMask & mask;
            if (shift < distance) continue;
            keys[gapSlot] = existing;
            gapSlot = slot;
            distance = 0;
        }
        keys[gapSlot] = 0.0;
        --this.assigned;
    }

    @Override
    public boolean contains(double key) {
        double existing;
        if (Double.doubleToLongBits(key) == 0L) {
            return this.allocatedDefaultKey;
        }
        int mask = this.keys.length - 1;
        double[] keys = this.keys;
        int slot = BitMixer.mix(key, this.perturbation) & mask;
        while (Double.doubleToLongBits(existing = keys[slot]) != 0L) {
            if (Double.doubleToLongBits(key) == Double.doubleToLongBits(existing)) {
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.allocatedDefaultKey = false;
        DoubleArrays.blankArray(this.keys, 0, this.keys.length);
    }

    @Override
    public int size() {
        return this.assigned + (this.allocatedDefaultKey ? 1 : 0);
    }

    @Override
    public int capacity() {
        return this.resizeAt;
    }

    public int hashCode() {
        int h2 = 0;
        double[] keys = this.keys;
        int i = keys.length;
        while (--i >= 0) {
            double existing = keys[i];
            if (Double.doubleToLongBits(existing) == 0L) continue;
            h2 += BitMixer.mix(existing);
        }
        return h2;
    }

    public boolean equals(Object obj) {
        if (obj != null) {
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            DoubleSet other = (DoubleSet)obj;
            if (other.size() != this.size()) {
                return false;
            }
            EntryIterator it = this.iterator();
            while (it.hasNext()) {
                if (other.contains(((DoubleCursor)it.next()).value)) continue;
                it.release();
                return false;
            }
            return true;
        }
        return false;
    }

    public EntryIterator iterator() {
        return (EntryIterator)this.entryIteratorPool.borrow();
    }

    @Override
    public <T extends DoubleProcedure> T forEach(T procedure) {
        if (this.allocatedDefaultKey) {
            procedure.apply(0.0);
        }
        double[] keys = this.keys;
        for (int i = keys.length - 1; i >= 0; --i) {
            double existing = keys[i];
            if (Double.doubleToLongBits(existing) == 0L) continue;
            procedure.apply(existing);
        }
        return procedure;
    }

    @Override
    public double[] toArray(double[] target) {
        int count = 0;
        if (this.allocatedDefaultKey) {
            target[count++] = 0.0;
        }
        double[] keys = this.keys;
        for (int i = 0; i < keys.length; ++i) {
            double existing = keys[i];
            if (Double.doubleToLongBits(existing) == 0L) continue;
            target[count++] = existing;
        }
        assert (count == this.size());
        return target;
    }

    public DoubleHashSet clone() {
        DoubleHashSet cloned = new DoubleHashSet(this.size(), this.loadFactor);
        cloned.addAll(this);
        return cloned;
    }

    @Override
    public <T extends DoublePredicate> T forEach(T predicate) {
        double existing;
        if (this.allocatedDefaultKey && !predicate.apply(0.0)) {
            return predicate;
        }
        double[] keys = this.keys;
        for (int i = keys.length - 1; i >= 0 && (Double.doubleToLongBits(existing = keys[i]) == 0L || predicate.apply(existing)); --i) {
        }
        return predicate;
    }

    @Override
    public int removeAll(DoublePredicate predicate) {
        int before = this.size();
        if (this.allocatedDefaultKey && predicate.apply(0.0)) {
            this.allocatedDefaultKey = false;
        }
        double[] keys = this.keys;
        int i = 0;
        while (i < keys.length) {
            double existing = keys[i];
            if (Double.doubleToLongBits(existing) != 0L && predicate.apply(existing)) {
                this.shiftConflictingKeys(i);
                continue;
            }
            ++i;
        }
        return before - this.size();
    }

    public static DoubleHashSet from(double ... elements) {
        DoubleHashSet set = new DoubleHashSet(elements.length);
        set.add(elements);
        return set;
    }

    public static DoubleHashSet from(DoubleContainer container) {
        return new DoubleHashSet(container);
    }

    public static DoubleHashSet newInstance() {
        return new DoubleHashSet();
    }

    public static DoubleHashSet newInstance(int initialCapacity, double loadFactor) {
        return new DoubleHashSet(initialCapacity, loadFactor);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class EntryIterator
    extends AbstractIterator<DoubleCursor> {
        public final DoubleCursor cursor = new DoubleCursor();

        public EntryIterator() {
            this.cursor.index = -2;
        }

        @Override
        protected DoubleCursor fetch() {
            int i;
            if (this.cursor.index == DoubleHashSet.this.keys.length + 1) {
                if (DoubleHashSet.this.allocatedDefaultKey) {
                    this.cursor.index = DoubleHashSet.this.keys.length;
                    this.cursor.value = 0.0;
                    return this.cursor;
                }
                this.cursor.index = DoubleHashSet.this.keys.length;
            }
            for (i = this.cursor.index - 1; i >= 0 && Double.doubleToLongBits(DoubleHashSet.this.keys[i]) == 0L; --i) {
            }
            if (i == -1) {
                return (DoubleCursor)this.done();
            }
            this.cursor.index = i;
            this.cursor.value = DoubleHashSet.this.keys[i];
            return this.cursor;
        }
    }
}

