/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonldjava.utils;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.jsonldjava.utils.JarCacheStorage;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.protocol.RequestAcceptEncoding;
import org.apache.http.client.protocol.ResponseContentEncoding;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.impl.client.cache.BasicHttpCacheStorage;
import org.apache.http.impl.client.cache.CacheConfig;
import org.apache.http.impl.client.cache.CachingHttpClientBuilder;

public class JsonUtils {
    public static final String ACCEPT_HEADER = "application/ld+json, application/json;q=0.9, application/javascript;q=0.5, text/javascript;q=0.5, text/plain;q=0.2, */*;q=0.1";
    private static final ObjectMapper JSON_MAPPER = new ObjectMapper();
    private static final JsonFactory JSON_FACTORY = new JsonFactory(JSON_MAPPER);
    private static volatile CloseableHttpClient DEFAULT_HTTP_CLIENT;

    public static Object fromInputStream(InputStream input) throws IOException {
        return JsonUtils.fromInputStream(input, "UTF-8");
    }

    /*
     * Exception decompiling
     */
    public static Object fromInputStream(InputStream input, String enc) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Object fromReader(Reader reader) throws IOException {
        JsonParser jp = JSON_FACTORY.createParser(reader);
        return JsonUtils.fromJsonParser(jp);
    }

    public static Object fromJsonParser(JsonParser jp) throws IOException {
        JsonToken t;
        Object rval;
        JsonToken initialToken = jp.nextToken();
        if (initialToken == JsonToken.START_ARRAY) {
            rval = jp.readValueAs(List.class);
        } else if (initialToken == JsonToken.START_OBJECT) {
            rval = jp.readValueAs(Map.class);
        } else if (initialToken == JsonToken.VALUE_STRING) {
            rval = jp.readValueAs(String.class);
        } else if (initialToken == JsonToken.VALUE_FALSE || initialToken == JsonToken.VALUE_TRUE) {
            rval = jp.readValueAs(Boolean.class);
        } else if (initialToken == JsonToken.VALUE_NUMBER_FLOAT || initialToken == JsonToken.VALUE_NUMBER_INT) {
            rval = jp.readValueAs(Number.class);
        } else if (initialToken == JsonToken.VALUE_NULL) {
            rval = null;
        } else {
            throw new JsonParseException(jp, "document doesn't start with a valid json element : " + (Object)((Object)initialToken), jp.getCurrentLocation());
        }
        try {
            t = jp.nextToken();
        }
        catch (JsonParseException ex) {
            throw new JsonParseException(jp, "Document contains more content after json-ld element - (possible mismatched {}?)", jp.getCurrentLocation());
        }
        if (t != null) {
            throw new JsonParseException(jp, "Document contains possible json content after the json-ld element - (possible mismatched {}?)", jp.getCurrentLocation());
        }
        return rval;
    }

    public static Object fromString(String jsonString) throws JsonParseException, IOException {
        return JsonUtils.fromReader(new StringReader(jsonString));
    }

    public static String toPrettyString(Object jsonObject) throws JsonGenerationException, IOException {
        StringWriter sw = new StringWriter();
        JsonUtils.writePrettyPrint(sw, jsonObject);
        return sw.toString();
    }

    public static String toString(Object jsonObject) throws JsonGenerationException, IOException {
        StringWriter sw = new StringWriter();
        JsonUtils.write(sw, jsonObject);
        return sw.toString();
    }

    public static void write(Writer writer, Object jsonObject) throws JsonGenerationException, IOException {
        JsonGenerator jw = JSON_FACTORY.createGenerator(writer);
        jw.writeObject(jsonObject);
    }

    public static void writePrettyPrint(Writer writer, Object jsonObject) throws JsonGenerationException, IOException {
        JsonGenerator jw = JSON_FACTORY.createGenerator(writer);
        jw.useDefaultPrettyPrinter();
        jw.writeObject(jsonObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object fromURL(URL url, CloseableHttpClient httpClient) throws JsonParseException, IOException {
        String protocol = url.getProtocol();
        try (InputStream in = null;){
            if (!protocol.equalsIgnoreCase("http") && !protocol.equalsIgnoreCase("https")) {
                in = url.openStream();
            } else {
                HttpGet request = new HttpGet(url.toExternalForm());
                request.addHeader("Accept", ACCEPT_HEADER);
                CloseableHttpResponse response = httpClient.execute(request);
                int status = response.getStatusLine().getStatusCode();
                if (status != 200 && status != 203) {
                    throw new IOException("Can't retrieve " + url + ", status code: " + status);
                }
                in = response.getEntity().getContent();
            }
            Object object = JsonUtils.fromInputStream(in);
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object fromURLJavaNet(URL url) throws JsonParseException, IOException {
        HttpURLConnection urlConn = (HttpURLConnection)url.openConnection();
        urlConn.addRequestProperty("Accept", ACCEPT_HEADER);
        InputStream directStream = urlConn.getInputStream();
        StringWriter output = new StringWriter();
        try {
            IOUtils.copy(directStream, (Writer)output, Charset.forName("UTF-8"));
        }
        finally {
            directStream.close();
            output.flush();
        }
        Object context = JsonUtils.fromReader(new StringReader(output.toString()));
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CloseableHttpClient getDefaultHttpClient() {
        CloseableHttpClient result = DEFAULT_HTTP_CLIENT;
        if (result != null) return result;
        Class<JsonUtils> clazz = JsonUtils.class;
        synchronized (JsonUtils.class) {
            result = DEFAULT_HTTP_CLIENT;
            if (result != null) return result;
            DEFAULT_HTTP_CLIENT = JsonUtils.createDefaultHttpClient();
            return DEFAULT_HTTP_CLIENT;
        }
    }

    private static CloseableHttpClient createDefaultHttpClient() {
        CacheConfig cacheConfig = CacheConfig.custom().setMaxCacheEntries(1000).setMaxObjectSize(131072L).build();
        CloseableHttpClient result = CachingHttpClientBuilder.create().setCacheConfig(cacheConfig).setHttpCacheStorage(new JarCacheStorage(null, cacheConfig, new BasicHttpCacheStorage(cacheConfig))).addInterceptorFirst(new RequestAcceptEncoding()).addInterceptorFirst(new ResponseContentEncoding()).setRedirectStrategy(DefaultRedirectStrategy.INSTANCE).useSystemProperties().build();
        return result;
    }

    static {
        JSON_FACTORY.disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
        JSON_FACTORY.disable(JsonFactory.Feature.INTERN_FIELD_NAMES);
        JSON_FACTORY.disable(JsonFactory.Feature.CANONICALIZE_FIELD_NAMES);
    }
}

