/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.util.xml;

import org.apache.soap.util.xml.QName;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMUtils {
    private static String NS_URI_XMLNS = "http://www.w3.org/2000/xmlns/";

    public static int countKids(Element element, short s2) {
        int n = 0;
        Node node = element.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == s2) {
                ++n;
            }
            node = node.getNextSibling();
        }
        return n;
    }

    public static Element findChildElementWithAttribute(Element element, String string, String string2) {
        Node node = element.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 1 && string2.equals(DOMUtils.getAttribute((Element)node, string))) {
                return (Element)node;
            }
            node = node.getNextSibling();
        }
        return null;
    }

    public static String getAttribute(Element element, String string) {
        String string2 = null;
        Attr attr = element.getAttributeNode(string);
        if (attr != null) {
            string2 = attr.getValue();
        }
        return string2;
    }

    public static String getAttributeNS(Element element, String string, String string2) {
        String string3 = null;
        Attr attr = element.getAttributeNodeNS(string, string2);
        if (attr != null) {
            string3 = attr.getValue();
        }
        return string3;
    }

    public static String getChildCharacterData(Element element) {
        if (element == null) {
            return null;
        }
        Node node = element.getFirstChild();
        StringBuffer stringBuffer = new StringBuffer();
        while (node != null) {
            switch (node.getNodeType()) {
                case 3: 
                case 4: {
                    CharacterData characterData = (CharacterData)node;
                    stringBuffer.append(characterData.getData());
                    break;
                }
            }
            node = node.getNextSibling();
        }
        return stringBuffer.toString();
    }

    public static Element getElementByID(Element element, String string) {
        if (element == null) {
            return null;
        }
        String string2 = element.getAttribute("id");
        if (string.equals(string2)) {
            return element;
        }
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Element element2;
            Node node = nodeList.item(n);
            if (node instanceof Element && (element2 = DOMUtils.getElementByID((Element)node, string)) != null) {
                return element2;
            }
            ++n;
        }
        return null;
    }

    public static Element getFirstChildElement(Element element) {
        Node node = element.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 1) {
                return (Element)node;
            }
            node = node.getNextSibling();
        }
        return null;
    }

    public static String getNamespaceURIFromPrefix(Node node, String string) {
        short s2 = node.getNodeType();
        Node node2 = null;
        switch (s2) {
            case 2: {
                node2 = ((Attr)node).getOwnerElement();
                break;
            }
            case 1: {
                node2 = node;
                break;
            }
            default: {
                node2 = node.getParentNode();
                break;
            }
        }
        while (node2 != null && node2.getNodeType() == 1) {
            String string2;
            Element element = (Element)node2;
            String string3 = string2 = string == null ? DOMUtils.getAttribute(element, "xmlns") : DOMUtils.getAttributeNS(element, NS_URI_XMLNS, string);
            if (string2 != null) {
                return string2;
            }
            node2 = element.getParentNode();
        }
        return null;
    }

    public static Element getNextSiblingElement(Element element) {
        Node node = element.getNextSibling();
        while (node != null) {
            if (node.getNodeType() == 1) {
                return (Element)node;
            }
            node = node.getNextSibling();
        }
        return null;
    }

    public static QName getQualifiedAttributeValue(Element element, String string) throws IllegalArgumentException {
        String string2 = DOMUtils.getAttribute(element, string);
        if (string2 != null) {
            int n = string2.indexOf(58);
            String string3 = n != -1 ? string2.substring(0, n) : null;
            String string4 = string2.substring(n + 1);
            String string5 = DOMUtils.getNamespaceURIFromPrefix(element, string3);
            if (string5 != null) {
                return new QName(string5, string4);
            }
            throw new IllegalArgumentException("Unable to determine namespace of '" + (string3 != null ? String.valueOf(string3) + ":" : "") + string4 + "'.");
        }
        return null;
    }
}

