/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.common.xml;

import org.eclipse.rdf4j.common.text.StringUtil;

public class XMLUtil {
    public static String escapeCharacterData(String text) {
        text = StringUtil.gsub("&", "&amp;", text);
        text = StringUtil.gsub("<", "&lt;", text);
        text = StringUtil.gsub(">", "&gt;", text);
        text = StringUtil.gsub("\r", "&#xD;", text);
        return text;
    }

    public static String escapeDoubleQuotedAttValue(String value) {
        value = XMLUtil._escapeAttValue(value);
        value = StringUtil.gsub("\"", "&quot;", value);
        return value;
    }

    public static String escapeSingleQuotedAttValue(String value) {
        value = XMLUtil._escapeAttValue(value);
        value = StringUtil.gsub("'", "&apos;", value);
        return value;
    }

    private static String _escapeAttValue(String value) {
        value = StringUtil.gsub("&", "&amp;", value);
        value = StringUtil.gsub("<", "&lt;", value);
        value = StringUtil.gsub(">", "&gt;", value);
        value = StringUtil.gsub("\t", "&#x9;", value);
        value = StringUtil.gsub("\n", "&#xA;", value);
        value = StringUtil.gsub("\r", "&#xD;", value);
        return value;
    }

    public static String resolveEntities(String text) {
        int ampIndex = text.indexOf(38);
        if (ampIndex == -1) {
            return text;
        }
        StringBuilder sb = new StringBuilder((int)(1.1 * (double)text.length()));
        int prevIndex = 0;
        while (ampIndex >= 0) {
            int colonIndex = text.indexOf(59, ampIndex);
            sb.append(text.substring(prevIndex, ampIndex));
            sb.append(XMLUtil.resolveEntity(text.substring(ampIndex + 1, colonIndex)));
            prevIndex = colonIndex + 1;
            ampIndex = text.indexOf(38, prevIndex);
        }
        sb.append(text.substring(prevIndex));
        return sb.toString();
    }

    public static String resolveEntity(String entName) {
        if (entName.startsWith("#")) {
            StringBuilder sb = new StringBuilder();
            if (entName.charAt(1) == 'x') {
                sb.append((char)Integer.parseInt(entName.substring(2), 16));
            } else {
                sb.append((char)Integer.parseInt(entName.substring(1)));
            }
            return sb.toString();
        }
        if (entName.equals("apos")) {
            return "'";
        }
        if (entName.equals("quot")) {
            return "\"";
        }
        if (entName.equals("gt")) {
            return ">";
        }
        if (entName.equals("lt")) {
            return "<";
        }
        if (entName.equals("amp")) {
            return "&";
        }
        return entName;
    }

    public static int findURISplitIndex(String uri) {
        char c;
        int i;
        int uriLength = uri.length();
        for (i = uriLength - 1; i >= 0 && (c = uri.charAt(i)) != '#' && c != '/' && XMLUtil.isNCNameChar(c); --i) {
        }
        ++i;
        while (i < uriLength && (c = uri.charAt(i)) != '_' && !XMLUtil.isLetter(c)) {
            ++i;
        }
        if (i == uriLength) {
            i = -1;
        }
        return i;
    }

    public static final boolean isNCName(String name) {
        int nameLength = name.length();
        if (nameLength == 0) {
            return false;
        }
        char c = name.charAt(0);
        if (XMLUtil.isNCNameStartChar(c)) {
            for (int i = 1; i < nameLength; ++i) {
                c = name.charAt(i);
                if (XMLUtil.isNCNameChar(c)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static final boolean isNCNameStartChar(char c) {
        return c == '_' || XMLUtil.isLetter(c);
    }

    public static final boolean isNCNameChar(char c) {
        return XMLUtil._isAsciiBaseChar(c) || XMLUtil._isAsciiDigit(c) || c == '.' || c == '-' || c == '_' || XMLUtil._isNonAsciiBaseChar(c) || XMLUtil._isNonAsciiDigit(c) || XMLUtil.isIdeographic(c) || XMLUtil.isCombiningChar(c) || XMLUtil.isExtender(c);
    }

    public static String escapeAttributeValue(String value) {
        String result = StringUtil.gsub("&", "&amp;", value);
        result = StringUtil.gsub("<", "&lt;", result);
        result = StringUtil.gsub(">", "&gt;", result);
        result = StringUtil.gsub("\"", "&quot;", result);
        result = StringUtil.gsub("'", "&apos;", result);
        return result;
    }

    public static String escapeText(String text) {
        String result = StringUtil.gsub("&", "&amp;", text);
        result = StringUtil.gsub("<", "&lt;", result);
        result = StringUtil.gsub(">", "&gt;", result);
        return result;
    }

    public static boolean isValidCharacterDataChar(char c) {
        return c >= ' ' && c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd' || c == '\t' || c == '\n' || c == '\r';
    }

    public static boolean isValidCharacterDataChar(int c) {
        return c >= 32 && c <= 55295 || c >= 57344 && c <= 65533 || c >= 65536 && c <= 0x10FFFF || c == 9 || c == 10 || c == 13;
    }

    public static String removeInvalidCharacterDataChars(String s2) {
        boolean hasInvalidChars = false;
        int length = s2.length();
        for (int i = 0; i < length; ++i) {
            if (XMLUtil.isValidCharacterDataChar(s2.charAt(i))) continue;
            hasInvalidChars = true;
            break;
        }
        if (hasInvalidChars) {
            StringBuilder buffer = new StringBuilder(length);
            for (int i = 0; i < length; ++i) {
                char c = s2.charAt(i);
                if (!XMLUtil.isValidCharacterDataChar(c)) continue;
                buffer.append(c);
            }
            return buffer.toString();
        }
        return s2;
    }

    public static final boolean isLetter(char c) {
        return XMLUtil._isAsciiBaseChar(c) || XMLUtil._isNonAsciiBaseChar(c) || XMLUtil.isIdeographic(c);
    }

    private static final boolean _isAsciiBaseChar(char c) {
        return XMLUtil._charInRange(c, 65, 90) || XMLUtil._charInRange(c, 97, 122);
    }

    private static final boolean _isNonAsciiBaseChar(char c) {
        return XMLUtil._charInRange(c, 192, 214) || XMLUtil._charInRange(c, 216, 246) || XMLUtil._charInRange(c, 248, 255) || XMLUtil._charInRange(c, 256, 305) || XMLUtil._charInRange(c, 308, 318) || XMLUtil._charInRange(c, 321, 328) || XMLUtil._charInRange(c, 330, 382) || XMLUtil._charInRange(c, 384, 451) || XMLUtil._charInRange(c, 461, 496) || XMLUtil._charInRange(c, 500, 501) || XMLUtil._charInRange(c, 506, 535) || XMLUtil._charInRange(c, 592, 680) || XMLUtil._charInRange(c, 699, 705) || c == '\u0386' || XMLUtil._charInRange(c, 904, 906) || c == '\u038c' || XMLUtil._charInRange(c, 910, 929) || XMLUtil._charInRange(c, 931, 974) || XMLUtil._charInRange(c, 976, 982) || c == '\u03da' || c == '\u03dc' || c == '\u03de' || c == '\u03e0' || XMLUtil._charInRange(c, 994, 1011) || XMLUtil._charInRange(c, 1025, 1036) || XMLUtil._charInRange(c, 1038, 1103) || XMLUtil._charInRange(c, 1105, 1116) || XMLUtil._charInRange(c, 1118, 1153) || XMLUtil._charInRange(c, 1168, 1220) || XMLUtil._charInRange(c, 1223, 1224) || XMLUtil._charInRange(c, 1227, 1228) || XMLUtil._charInRange(c, 1232, 1259) || XMLUtil._charInRange(c, 1262, 1269) || XMLUtil._charInRange(c, 1272, 1273) || XMLUtil._charInRange(c, 1329, 1366) || c == '\u0559' || XMLUtil._charInRange(c, 1377, 1414) || XMLUtil._charInRange(c, 1488, 1514) || XMLUtil._charInRange(c, 1520, 1522) || XMLUtil._charInRange(c, 1569, 1594) || XMLUtil._charInRange(c, 1601, 1610) || XMLUtil._charInRange(c, 1649, 1719) || XMLUtil._charInRange(c, 1722, 1726) || XMLUtil._charInRange(c, 1728, 1742) || XMLUtil._charInRange(c, 1744, 1747) || c == '\u06d5' || XMLUtil._charInRange(c, 1765, 1766) || XMLUtil._charInRange(c, 2309, 2361) || c == '\u093d' || XMLUtil._charInRange(c, 2392, 2401) || XMLUtil._charInRange(c, 2437, 2444) || XMLUtil._charInRange(c, 2447, 2448) || XMLUtil._charInRange(c, 2451, 2472) || XMLUtil._charInRange(c, 2474, 2480) || c == '\u09b2' || XMLUtil._charInRange(c, 2486, 2489) || XMLUtil._charInRange(c, 2524, 2525) || XMLUtil._charInRange(c, 2527, 2529) || XMLUtil._charInRange(c, 2544, 2545) || XMLUtil._charInRange(c, 2565, 2570) || XMLUtil._charInRange(c, 2575, 2576) || XMLUtil._charInRange(c, 2579, 2600) || XMLUtil._charInRange(c, 2602, 2608) || XMLUtil._charInRange(c, 2610, 2611) || XMLUtil._charInRange(c, 2613, 2614) || XMLUtil._charInRange(c, 2616, 2617) || XMLUtil._charInRange(c, 2649, 2652) || c == '\u0a5e' || XMLUtil._charInRange(c, 2674, 2676) || XMLUtil._charInRange(c, 2693, 2699) || c == '\u0a8d' || XMLUtil._charInRange(c, 2703, 2705) || XMLUtil._charInRange(c, 2707, 2728) || XMLUtil._charInRange(c, 2730, 2736) || XMLUtil._charInRange(c, 2738, 2739) || XMLUtil._charInRange(c, 2741, 2745) || c == '\u0abd' || c == '\u0ae0' || XMLUtil._charInRange(c, 2821, 2828) || XMLUtil._charInRange(c, 2831, 2832) || XMLUtil._charInRange(c, 2835, 2856) || XMLUtil._charInRange(c, 2858, 2864) || XMLUtil._charInRange(c, 2866, 2867) || XMLUtil._charInRange(c, 2870, 2873) || c == '\u0b3d' || XMLUtil._charInRange(c, 2908, 2909) || XMLUtil._charInRange(c, 2911, 2913) || XMLUtil._charInRange(c, 2949, 2954) || XMLUtil._charInRange(c, 2958, 2960) || XMLUtil._charInRange(c, 2962, 2965) || XMLUtil._charInRange(c, 2969, 2970) || c == '\u0b9c' || XMLUtil._charInRange(c, 2974, 2975) || XMLUtil._charInRange(c, 2979, 2980) || XMLUtil._charInRange(c, 2984, 2986) || XMLUtil._charInRange(c, 2990, 2997) || XMLUtil._charInRange(c, 2999, 3001) || XMLUtil._charInRange(c, 3077, 3084) || XMLUtil._charInRange(c, 3086, 3088) || XMLUtil._charInRange(c, 3090, 3112) || XMLUtil._charInRange(c, 3114, 3123) || XMLUtil._charInRange(c, 3125, 3129) || XMLUtil._charInRange(c, 3168, 3169) || XMLUtil._charInRange(c, 3205, 3212) || XMLUtil._charInRange(c, 3214, 3216) || XMLUtil._charInRange(c, 3218, 3240) || XMLUtil._charInRange(c, 3242, 3251) || XMLUtil._charInRange(c, 3253, 3257) || c == '\u0cde' || XMLUtil._charInRange(c, 3296, 3297) || XMLUtil._charInRange(c, 3333, 3340) || XMLUtil._charInRange(c, 3342, 3344) || XMLUtil._charInRange(c, 3346, 3368) || XMLUtil._charInRange(c, 3370, 3385) || XMLUtil._charInRange(c, 3424, 3425) || XMLUtil._charInRange(c, 3585, 3630) || c == '\u0e30' || XMLUtil._charInRange(c, 3634, 3635) || XMLUtil._charInRange(c, 3648, 3653) || XMLUtil._charInRange(c, 3713, 3714) || c == '\u0e84' || XMLUtil._charInRange(c, 3719, 3720) || c == '\u0e8a' || c == '\u0e8d' || XMLUtil._charInRange(c, 3732, 3735) || XMLUtil._charInRange(c, 3737, 3743) || XMLUtil._charInRange(c, 3745, 3747) || c == '\u0ea5' || c == '\u0ea7' || XMLUtil._charInRange(c, 3754, 3755) || XMLUtil._charInRange(c, 3757, 3758) || c == '\u0eb0' || XMLUtil._charInRange(c, 3762, 3763) || c == '\u0ebd' || XMLUtil._charInRange(c, 3776, 3780) || XMLUtil._charInRange(c, 3904, 3911) || XMLUtil._charInRange(c, 3913, 3945) || XMLUtil._charInRange(c, 4256, 4293) || XMLUtil._charInRange(c, 4304, 4342) || c == '\u1100' || XMLUtil._charInRange(c, 4354, 4355) || XMLUtil._charInRange(c, 4357, 4359) || c == '\u1109' || XMLUtil._charInRange(c, 4363, 4364) || XMLUtil._charInRange(c, 4366, 4370) || c == '\u113c' || c == '\u113e' || c == '\u1140' || c == '\u114c' || c == '\u114e' || c == '\u1150' || XMLUtil._charInRange(c, 4436, 4437) || c == '\u1159' || XMLUtil._charInRange(c, 4447, 4449) || c == '\u1163' || c == '\u1165' || c == '\u1167' || c == '\u1169' || XMLUtil._charInRange(c, 4461, 4462) || XMLUtil._charInRange(c, 4466, 4467) || c == '\u1175' || c == '\u119e' || c == '\u11a8' || c == '\u11ab' || XMLUtil._charInRange(c, 4526, 4527) || XMLUtil._charInRange(c, 4535, 4536) || c == '\u11ba' || XMLUtil._charInRange(c, 4540, 4546) || c == '\u11eb' || c == '\u11f0' || c == '\u11f9' || XMLUtil._charInRange(c, 7680, 7835) || XMLUtil._charInRange(c, 7840, 7929) || XMLUtil._charInRange(c, 7936, 7957) || XMLUtil._charInRange(c, 7960, 7965) || XMLUtil._charInRange(c, 7968, 8005) || XMLUtil._charInRange(c, 8008, 8013) || XMLUtil._charInRange(c, 8016, 8023) || c == '\u1f59' || c == '\u1f5b' || c == '\u1f5d' || XMLUtil._charInRange(c, 8031, 8061) || XMLUtil._charInRange(c, 8064, 8116) || XMLUtil._charInRange(c, 8118, 8124) || c == '\u1fbe' || XMLUtil._charInRange(c, 8130, 8132) || XMLUtil._charInRange(c, 8134, 8140) || XMLUtil._charInRange(c, 8144, 8147) || XMLUtil._charInRange(c, 8150, 8155) || XMLUtil._charInRange(c, 8160, 8172) || XMLUtil._charInRange(c, 8178, 8180) || XMLUtil._charInRange(c, 8182, 8188) || c == '\u2126' || XMLUtil._charInRange(c, 8490, 8491) || c == '\u212e' || XMLUtil._charInRange(c, 8576, 8578) || XMLUtil._charInRange(c, 12353, 12436) || XMLUtil._charInRange(c, 12449, 12538) || XMLUtil._charInRange(c, 12549, 12588) || XMLUtil._charInRange(c, 44032, 55203);
    }

    public static final boolean isIdeographic(char c) {
        return XMLUtil._charInRange(c, 19968, 40869) || c == '\u3007' || XMLUtil._charInRange(c, 12321, 12329);
    }

    public static final boolean isCombiningChar(char c) {
        return XMLUtil._charInRange(c, 768, 837) || XMLUtil._charInRange(c, 864, 865) || XMLUtil._charInRange(c, 1155, 1158) || XMLUtil._charInRange(c, 1425, 1441) || XMLUtil._charInRange(c, 1443, 1465) || XMLUtil._charInRange(c, 1467, 1469) || c == '\u05bf' || XMLUtil._charInRange(c, 1473, 1474) || c == '\u05c4' || XMLUtil._charInRange(c, 1611, 1618) || c == '\u0670' || XMLUtil._charInRange(c, 1750, 1756) || XMLUtil._charInRange(c, 1757, 1759) || XMLUtil._charInRange(c, 1760, 1764) || XMLUtil._charInRange(c, 1767, 1768) || XMLUtil._charInRange(c, 1770, 1773) || XMLUtil._charInRange(c, 2305, 2307) || c == '\u093c' || XMLUtil._charInRange(c, 2366, 2380) || c == '\u094d' || XMLUtil._charInRange(c, 2385, 2388) || XMLUtil._charInRange(c, 2402, 2403) || XMLUtil._charInRange(c, 2433, 2435) || c == '\u09bc' || c == '\u09be' || c == '\u09bf' || XMLUtil._charInRange(c, 2496, 2500) || XMLUtil._charInRange(c, 2503, 2504) || XMLUtil._charInRange(c, 2507, 2509) || c == '\u09d7' || XMLUtil._charInRange(c, 2530, 2531) || c == '\u0a02' || c == '\u0a3c' || c == '\u0a3e' || c == '\u0a3f' || XMLUtil._charInRange(c, 2624, 2626) || XMLUtil._charInRange(c, 2631, 2632) || XMLUtil._charInRange(c, 2635, 2637) || XMLUtil._charInRange(c, 2672, 2673) || XMLUtil._charInRange(c, 2689, 2691) || c == '\u0abc' || XMLUtil._charInRange(c, 2750, 2757) || XMLUtil._charInRange(c, 2759, 2761) || XMLUtil._charInRange(c, 2763, 2765) || XMLUtil._charInRange(c, 2817, 2819) || c == '\u0b3c' || XMLUtil._charInRange(c, 2878, 2883) || XMLUtil._charInRange(c, 2887, 2888) || XMLUtil._charInRange(c, 2891, 2893) || XMLUtil._charInRange(c, 2902, 2903) || XMLUtil._charInRange(c, 2946, 2947) || XMLUtil._charInRange(c, 3006, 3010) || XMLUtil._charInRange(c, 3014, 3016) || XMLUtil._charInRange(c, 3018, 3021) || c == '\u0bd7' || XMLUtil._charInRange(c, 3073, 3075) || XMLUtil._charInRange(c, 3134, 3140) || XMLUtil._charInRange(c, 3142, 3144) || XMLUtil._charInRange(c, 3146, 3149) || XMLUtil._charInRange(c, 3157, 3158) || XMLUtil._charInRange(c, 3202, 3203) || XMLUtil._charInRange(c, 3262, 3268) || XMLUtil._charInRange(c, 3270, 3272) || XMLUtil._charInRange(c, 3274, 3277) || XMLUtil._charInRange(c, 3285, 3286) || XMLUtil._charInRange(c, 3330, 3331) || XMLUtil._charInRange(c, 3390, 3395) || XMLUtil._charInRange(c, 3398, 3400) || XMLUtil._charInRange(c, 3402, 3405) || c == '\u0d57' || c == '\u0e31' || XMLUtil._charInRange(c, 3636, 3642) || XMLUtil._charInRange(c, 3655, 3662) || c == '\u0eb1' || XMLUtil._charInRange(c, 3764, 3769) || XMLUtil._charInRange(c, 3771, 3772) || XMLUtil._charInRange(c, 3784, 3789) || XMLUtil._charInRange(c, 3864, 3865) || c == '\u0f35' || c == '\u0f37' || c == '\u0f39' || c == '\u0f3e' || c == '\u0f3f' || XMLUtil._charInRange(c, 3953, 3972) || XMLUtil._charInRange(c, 3974, 3979) || XMLUtil._charInRange(c, 3984, 3989) || c == '\u0f97' || XMLUtil._charInRange(c, 3993, 4013) || XMLUtil._charInRange(c, 4017, 4023) || c == '\u0fb9' || XMLUtil._charInRange(c, 8400, 8412) || c == '\u20e1' || XMLUtil._charInRange(c, 12330, 12335) || c == '\u3099' || c == '\u309a';
    }

    public static final boolean isDigit(char c) {
        return XMLUtil._isAsciiDigit(c) || XMLUtil._isNonAsciiDigit(c);
    }

    private static final boolean _isAsciiDigit(char c) {
        return XMLUtil._charInRange(c, 48, 57);
    }

    private static final boolean _isNonAsciiDigit(char c) {
        return XMLUtil._charInRange(c, 1632, 1641) || XMLUtil._charInRange(c, 1776, 1785) || XMLUtil._charInRange(c, 2406, 2415) || XMLUtil._charInRange(c, 2534, 2543) || XMLUtil._charInRange(c, 2662, 2671) || XMLUtil._charInRange(c, 2790, 2799) || XMLUtil._charInRange(c, 2918, 2927) || XMLUtil._charInRange(c, 3047, 3055) || XMLUtil._charInRange(c, 3174, 3183) || XMLUtil._charInRange(c, 3302, 3311) || XMLUtil._charInRange(c, 3430, 3439) || XMLUtil._charInRange(c, 3664, 3673) || XMLUtil._charInRange(c, 3792, 3801) || XMLUtil._charInRange(c, 3872, 3881);
    }

    public static final boolean isExtender(char c) {
        return c == '\u00b7' || c == '\u02d0' || c == '\u02d1' || c == '\u0387' || c == '\u0640' || c == '\u0e46' || c == '\u0ec6' || c == '\u3005' || XMLUtil._charInRange(c, 12337, 12341) || XMLUtil._charInRange(c, 12445, 12446) || XMLUtil._charInRange(c, 12540, 12542);
    }

    private static final boolean _charInRange(char c, int start, int end) {
        return c >= start && c <= end;
    }
}

