/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.model.impl;

import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import org.eclipse.rdf4j.OpenRDFUtil;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.AbstractModel;
import org.eclipse.rdf4j.model.impl.EmptyModel;

public abstract class FilteredModel
extends AbstractModel {
    private final Model model;
    private static final long serialVersionUID = -2353344619836326934L;
    protected Resource subj;
    protected IRI pred;
    protected Value obj;
    protected Resource[] contexts;

    public FilteredModel(AbstractModel model, Resource subj, IRI pred, Value obj, Resource ... contexts) {
        OpenRDFUtil.verifyContextNotNull(contexts);
        this.model = model;
        this.subj = subj;
        this.pred = pred;
        this.obj = obj;
        this.contexts = contexts;
    }

    @Override
    public Optional<Namespace> getNamespace(String prefix) {
        return this.model.getNamespace(prefix);
    }

    @Override
    public Set<Namespace> getNamespaces() {
        return this.model.getNamespaces();
    }

    @Override
    public Namespace setNamespace(String prefix, String name) {
        return this.model.setNamespace(prefix, name);
    }

    @Override
    public void setNamespace(Namespace namespace) {
        this.model.setNamespace(namespace);
    }

    @Override
    public Optional<Namespace> removeNamespace(String prefix) {
        return this.model.removeNamespace(prefix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Iterator iter = this.iterator();
        try {
            int size = 0;
            while (iter.hasNext()) {
                ++size;
                iter.next();
            }
            int n = size;
            return n;
        }
        finally {
            this.closeIterator(iter);
        }
    }

    @Override
    public boolean add(Resource s2, IRI p, Value o, Resource ... c) {
        if (s2 == null) {
            s2 = this.subj;
        }
        if (p == null) {
            p = this.pred;
        }
        if (o == null) {
            o = this.obj;
        }
        if (c != null && c.length == 0) {
            c = this.contexts;
        }
        if (!this.accept(s2, p, o, c)) {
            throw new IllegalArgumentException("Statement is filtered out of view");
        }
        return this.model.add(s2, p, o, c);
    }

    @Override
    public boolean remove(Resource s2, IRI p, Value o, Resource ... c) {
        if (s2 == null) {
            s2 = this.subj;
        }
        if (p == null) {
            p = this.pred;
        }
        if (o == null) {
            o = this.obj;
        }
        if (c != null && c.length == 0) {
            c = this.contexts;
        }
        if (!this.accept(s2, p, o, c)) {
            return false;
        }
        return this.model.remove(s2, p, o, c);
    }

    @Override
    public boolean contains(Resource s2, IRI p, Value o, Resource ... c) {
        if (s2 == null) {
            s2 = this.subj;
        }
        if (p == null) {
            p = this.pred;
        }
        if (o == null) {
            o = this.obj;
        }
        if (c != null && c.length == 0) {
            c = this.contexts;
        }
        if (!this.accept(s2, p, o, c)) {
            return false;
        }
        return this.model.contains(s2, p, o, c);
    }

    @Override
    public Model filter(Resource s2, IRI p, Value o, Resource ... c) {
        if (s2 == null) {
            s2 = this.subj;
        }
        if (p == null) {
            p = this.pred;
        }
        if (o == null) {
            o = this.obj;
        }
        if (c != null && c.length == 0) {
            c = this.contexts;
        }
        if (!this.accept(s2, p, o, c)) {
            return new EmptyModel(this.model);
        }
        return this.model.filter(s2, p, o, c);
    }

    @Override
    public final void removeTermIteration(Iterator<Statement> iter, Resource s2, IRI p, Value o, Resource ... c) {
        if (s2 == null) {
            s2 = this.subj;
        }
        if (p == null) {
            p = this.pred;
        }
        if (o == null) {
            o = this.obj;
        }
        if (c != null && c.length == 0) {
            c = this.contexts;
        }
        if (!this.accept(s2, p, o, c)) {
            throw new IllegalStateException();
        }
        this.removeFilteredTermIteration(iter, s2, p, o, c);
    }

    protected abstract void removeFilteredTermIteration(Iterator<Statement> var1, Resource var2, IRI var3, Value var4, Resource ... var5);

    private boolean accept(Resource s2, IRI p, Value o, Resource ... c) {
        if (this.subj != null && !this.subj.equals(s2)) {
            return false;
        }
        if (this.pred != null && !this.pred.equals(p)) {
            return false;
        }
        if (this.obj != null && !this.obj.equals(o)) {
            return false;
        }
        if (!this.matches(c, this.contexts)) {
            return false;
        }
        return !(s2 != null && !(s2 instanceof Resource) || p != null && !(p instanceof IRI));
    }

    private boolean matches(Resource[] stContext, Resource ... contexts) {
        OpenRDFUtil.verifyContextNotNull(stContext);
        if (stContext != null && stContext.length > 0) {
            for (Resource c : stContext) {
                if (this.matches(c, contexts)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean matches(Resource stContext, Resource ... contexts) {
        if (contexts != null && contexts.length == 0) {
            return stContext == null || stContext instanceof Resource;
        }
        OpenRDFUtil.verifyContextNotNull(contexts);
        for (Resource context : contexts) {
            if (context == null && stContext == null) {
                return true;
            }
            if (context == null || !context.equals(stContext)) continue;
            return true;
        }
        return false;
    }
}

