/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.helpers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.impl.SimpleNamespace;
import org.eclipse.rdf4j.rio.DatatypeHandler;
import org.eclipse.rdf4j.rio.DatatypeHandlerRegistry;
import org.eclipse.rdf4j.rio.LanguageHandler;
import org.eclipse.rdf4j.rio.LanguageHandlerRegistry;
import org.eclipse.rdf4j.rio.RioSetting;
import org.eclipse.rdf4j.rio.helpers.LargeLiteralHandling;
import org.eclipse.rdf4j.rio.helpers.RioSettingImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicParserSettings {
    private static final Set<Namespace> _DEFAULT_PREFIX;
    private static final Logger log;
    public static final RioSetting<Boolean> VERIFY_DATATYPE_VALUES;
    public static final RioSetting<Boolean> FAIL_ON_UNKNOWN_DATATYPES;
    public static final RioSetting<Boolean> NORMALIZE_DATATYPE_VALUES;
    public static final RioSetting<List<DatatypeHandler>> DATATYPE_HANDLERS;
    public static final RioSetting<Boolean> FAIL_ON_UNKNOWN_LANGUAGES;
    public static final RioSetting<Boolean> VERIFY_LANGUAGE_TAGS;
    public static final RioSetting<Boolean> NORMALIZE_LANGUAGE_TAGS;
    public static final RioSetting<List<LanguageHandler>> LANGUAGE_HANDLERS;
    public static final RioSetting<Boolean> VERIFY_RELATIVE_URIS;
    public static final RioSetting<Boolean> VERIFY_URI_SYNTAX;
    public static final RioSetting<Boolean> PRESERVE_BNODE_IDS;
    public static final RioSetting<String> SKOLEMIZE_ORIGIN;
    public static final RioSetting<LargeLiteralHandling> LARGE_LITERALS_HANDLING;
    public static final RioSetting<Long> LARGE_LITERALS_LIMIT;
    public static final RioSetting<Set<Namespace>> NAMESPACES;

    private BasicParserSettings() {
    }

    static {
        HashSet<SimpleNamespace> aNamespaces = new HashSet<SimpleNamespace>();
        aNamespaces.add(new SimpleNamespace("as", "https://www.w3.org/ns/activitystreams#"));
        aNamespaces.add(new SimpleNamespace("csvw", "http://www.w3.org/ns/csvw#"));
        aNamespaces.add(new SimpleNamespace("dcat", "http://www.w3.org/ns/dcat#"));
        aNamespaces.add(new SimpleNamespace("dqv", "http://www.w3.org/ns/dqv#"));
        aNamespaces.add(new SimpleNamespace("duv", "https://www.w3.org/TR/vocab-duv#"));
        aNamespaces.add(new SimpleNamespace("grddl", "http://www.w3.org/2003/g/data-view#"));
        aNamespaces.add(new SimpleNamespace("ldp", "http://www.w3.org/ns/ldp#"));
        aNamespaces.add(new SimpleNamespace("ma", "http://www.w3.org/ns/ma-ont#"));
        aNamespaces.add(new SimpleNamespace("oa", "http://www.w3.org/ns/oa#"));
        aNamespaces.add(new SimpleNamespace("org", "http://www.w3.org/ns/org#"));
        aNamespaces.add(new SimpleNamespace("owl", "http://www.w3.org/2002/07/owl#"));
        aNamespaces.add(new SimpleNamespace("prov", "http://www.w3.org/ns/prov#"));
        aNamespaces.add(new SimpleNamespace("qb", "http://purl.org/linked-data/cube#"));
        aNamespaces.add(new SimpleNamespace("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#"));
        aNamespaces.add(new SimpleNamespace("rdfa", "http://www.w3.org/ns/rdfa#"));
        aNamespaces.add(new SimpleNamespace("rdfs", "http://www.w3.org/2000/01/rdf-schema#"));
        aNamespaces.add(new SimpleNamespace("rif", "http://www.w3.org/2007/rif#"));
        aNamespaces.add(new SimpleNamespace("rr", "http://www.w3.org/ns/r2rml#"));
        aNamespaces.add(new SimpleNamespace("sd", "http://www.w3.org/ns/sparql-service-description#"));
        aNamespaces.add(new SimpleNamespace("skos", "http://www.w3.org/2004/02/skos/core#"));
        aNamespaces.add(new SimpleNamespace("skosxl", "http://www.w3.org/2008/05/skos-xl#"));
        aNamespaces.add(new SimpleNamespace("ssn", "http://www.w3.org/ns/ssn/"));
        aNamespaces.add(new SimpleNamespace("sosa", "http://www.w3.org/ns/sosa/"));
        aNamespaces.add(new SimpleNamespace("time", "http://www.w3.org/2006/time#"));
        aNamespaces.add(new SimpleNamespace("void", "http://rdfs.org/ns/void#"));
        aNamespaces.add(new SimpleNamespace("wdr", "http://www.w3.org/2007/05/powder#"));
        aNamespaces.add(new SimpleNamespace("wdrs", "http://www.w3.org/2007/05/powder-s#"));
        aNamespaces.add(new SimpleNamespace("xhv", "http://www.w3.org/1999/xhtml/vocab#"));
        aNamespaces.add(new SimpleNamespace("xml", "http://www.w3.org/XML/1998/namespace"));
        aNamespaces.add(new SimpleNamespace("xsd", "http://www.w3.org/2001/XMLSchema#"));
        aNamespaces.add(new SimpleNamespace("earl", "http://www.w3.org/ns/earl#"));
        aNamespaces.add(new SimpleNamespace("odrl", "http://www.w3.org/ns/odrl/2/"));
        aNamespaces.add(new SimpleNamespace("cc", "http://creativecommons.org/ns#"));
        aNamespaces.add(new SimpleNamespace("ctag", "http://commontag.org/ns#"));
        aNamespaces.add(new SimpleNamespace("dc", "http://purl.org/dc/terms/"));
        aNamespaces.add(new SimpleNamespace("dc11", "http://purl.org/dc/elements/1.1/"));
        aNamespaces.add(new SimpleNamespace("dcterms", "http://purl.org/dc/terms/"));
        aNamespaces.add(new SimpleNamespace("foaf", "http://xmlns.com/foaf/0.1/"));
        aNamespaces.add(new SimpleNamespace("gr", "http://purl.org/goodrelations/v1#"));
        aNamespaces.add(new SimpleNamespace("ical", "http://www.w3.org/2002/12/cal/icaltzd#"));
        aNamespaces.add(new SimpleNamespace("og", "http://ogp.me/ns#"));
        aNamespaces.add(new SimpleNamespace("rev", "http://purl.org/stuff/rev#"));
        aNamespaces.add(new SimpleNamespace("sioc", "http://rdfs.org/sioc/ns#"));
        aNamespaces.add(new SimpleNamespace("v", "http://rdf.data-vocabulary.org/#"));
        aNamespaces.add(new SimpleNamespace("vcard", "http://www.w3.org/2006/vcard/ns#"));
        aNamespaces.add(new SimpleNamespace("schema", "http://schema.org/"));
        aNamespaces.add(new SimpleNamespace("describedby", "http://www.w3.org/2007/05/powder-s#describedby"));
        aNamespaces.add(new SimpleNamespace("license", "http://www.w3.org/1999/xhtml/vocab#license"));
        aNamespaces.add(new SimpleNamespace("role", "http://www.w3.org/1999/xhtml/vocab#role"));
        aNamespaces.add(new SimpleNamespace("cat", "http://www.w3.org/ns/dcat#"));
        aNamespaces.add(new SimpleNamespace("cnt", "http://www.w3.org/2008/content#"));
        aNamespaces.add(new SimpleNamespace("gldp", "http://www.w3.org/ns/people#"));
        aNamespaces.add(new SimpleNamespace("ht", "http://www.w3.org/2006/http#"));
        aNamespaces.add(new SimpleNamespace("ptr", "http://www.w3.org/2009/pointers#"));
        _DEFAULT_PREFIX = Collections.unmodifiableSet(aNamespaces);
        log = LoggerFactory.getLogger(BasicParserSettings.class);
        VERIFY_DATATYPE_VALUES = new RioSettingImpl<Boolean>("org.eclipse.rdf4j.rio.verifydatatypevalues", "Verify recognised datatype values", Boolean.FALSE);
        FAIL_ON_UNKNOWN_DATATYPES = new RioSettingImpl<Boolean>("org.eclipse.rdf4j.rio.failonunknowndatatypes", "Fail on unknown datatypes", Boolean.FALSE);
        NORMALIZE_DATATYPE_VALUES = new RioSettingImpl<Boolean>("org.eclipse.rdf4j.rio.normalizedatatypevalues", "Normalize recognised datatype values", Boolean.FALSE);
        FAIL_ON_UNKNOWN_LANGUAGES = new RioSettingImpl<Boolean>("org.eclipse.rdf4j.rio.failonunknownlanguages", "Fail on unknown languages", Boolean.FALSE);
        VERIFY_LANGUAGE_TAGS = new RioSettingImpl<Boolean>("org.eclipse.rdf4j.rio.verifylanguagevalues", "Verify language tags", Boolean.TRUE);
        NORMALIZE_LANGUAGE_TAGS = new RioSettingImpl<Boolean>("org.eclipse.rdf4j.rio.normalizelanguagevalues", "Normalize recognised language tags", Boolean.FALSE);
        VERIFY_RELATIVE_URIS = new RioSettingImpl<Boolean>("org.eclipse.rdf4j.rio.verifyrelativeuris", "Verify relative URIs", Boolean.TRUE);
        VERIFY_URI_SYNTAX = new RioSettingImpl<Boolean>("org.eclipse.rdf4j.rio.verifyurisyntax", "Verify URI syntax", Boolean.TRUE);
        PRESERVE_BNODE_IDS = new RioSettingImpl<Boolean>("org.eclipse.rdf4j.rio.preservebnodeids", "Preserve blank node identifiers", Boolean.FALSE);
        SKOLEMIZE_ORIGIN = new RioSettingImpl<Object>("org.eclipse.rdf4j.rio.skolemorigin", "Replace blank nodes with well known genid IRIs using this scheme and authority", null);
        LARGE_LITERALS_HANDLING = new RioSettingImpl<LargeLiteralHandling>("org.eclipse.rdf4j.rio.largeliterals", "Large literals handling", LargeLiteralHandling.PRESERVE);
        LARGE_LITERALS_LIMIT = new RioSettingImpl<Long>("org.eclipse.rdf4j.rio.largeliteralslimit", "Size limit for large literals", 0x100000L);
        NAMESPACES = new RioSettingImpl<Set<Namespace>>("org.eclipse.rdf4j.rio.namespaces", "Collection of default namespaces to use for parsing", _DEFAULT_PREFIX);
        ArrayList defaultDatatypeHandlers = new ArrayList(5);
        try {
            DatatypeHandlerRegistry registry = DatatypeHandlerRegistry.getInstance();
            for (String nextDatatype : Arrays.asList("org.eclipse.rdf4j.rio.datatypes.xmlschema", "org.eclipse.rdf4j.rio.datatypes.rdf", "org.eclipse.rdf4j.rio.datatypes.dbpedia", "org.eclipse.rdf4j.rio.datatypes.virtuosogeometry", "org.eclipse.rdf4j.rio.datatypes.geosparql")) {
                Optional nextDatatypeHandler = registry.get(nextDatatype);
                if (nextDatatypeHandler.isPresent()) {
                    defaultDatatypeHandlers.add(nextDatatypeHandler.get());
                    continue;
                }
                log.warn("Could not find DatatypeHandler : {}", (Object)nextDatatype);
            }
        }
        catch (Exception e) {
            log.warn("Found an error loading DatatypeHandler services", e);
        }
        DATATYPE_HANDLERS = new RioSettingImpl("org.eclipse.rdf4j.rio.datatypehandlers", "Datatype Handlers", Collections.unmodifiableList(defaultDatatypeHandlers));
        ArrayList defaultLanguageHandlers = new ArrayList(1);
        try {
            LanguageHandlerRegistry registry = LanguageHandlerRegistry.getInstance();
            String nextLanguageTagScheme = "org.eclipse.rdf4j.rio.languages.BCP47";
            if (registry.has(nextLanguageTagScheme)) {
                Optional nextLanguageHandler = registry.get(nextLanguageTagScheme);
                if (nextLanguageHandler.isPresent()) {
                    defaultLanguageHandlers.add(nextLanguageHandler.get());
                } else {
                    log.warn("Could not find LanguageHandler : {}", (Object)nextLanguageTagScheme);
                }
            }
        }
        catch (Exception e) {
            log.warn("Found an error loading LanguageHandler services", e);
        }
        LANGUAGE_HANDLERS = new RioSettingImpl("org.eclipse.rdf4j.rio.languagehandlers", "Language Handlers", Collections.unmodifiableList(defaultLanguageHandlers));
    }
}

