/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.rio.turtle;

import org.openrdf.util.ASCIIUtil;
import org.openrdf.util.StringUtil;

public class TurtleUtil {
    public static boolean isWhitespace(int c) {
        return c == 32 || c == 9 || c == 10 || c == 13;
    }

    public static boolean isPrefixStartChar(int c) {
        return ASCIIUtil.isLetter(c) || c >= 192 && c <= 214 || c >= 216 && c <= 246 || c >= 248 && c <= 767 || c >= 880 && c <= 893 || c >= 895 && c <= 8191 || c >= 8204 && c <= 8205 || c >= 8304 && c <= 8591 || c >= 11264 && c <= 12271 || c >= 12289 && c <= 55295 || c >= 63744 && c <= 64975 || c >= 65008 && c <= 65533 || c >= 65536 && c <= 983039;
    }

    public static boolean isNameStartChar(int c) {
        return c == 95 || TurtleUtil.isPrefixStartChar(c);
    }

    public static boolean isNameChar(int c) {
        return TurtleUtil.isNameStartChar(c) || ASCIIUtil.isNumber(c) || c == 45 || c == 183 || c >= 768 && c <= 879 || c >= 8255 && c <= 8256;
    }

    public static boolean isPrefixChar(int c) {
        return TurtleUtil.isNameChar(c);
    }

    public static boolean isLanguageStartChar(int c) {
        return ASCIIUtil.isLetter(c);
    }

    public static boolean isLanguageChar(int c) {
        return ASCIIUtil.isLetter(c) || ASCIIUtil.isNumber(c) || c == 45;
    }

    public static boolean isLegalPrefix(String prefix) {
        if (prefix.length() == 0) {
            return false;
        }
        if (!TurtleUtil.isPrefixStartChar(prefix.charAt(0))) {
            return false;
        }
        for (int i = 1; i < prefix.length(); ++i) {
            if (TurtleUtil.isPrefixChar(prefix.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isLegalName(String name) {
        if (name.length() == 0) {
            return false;
        }
        if (!TurtleUtil.isNameStartChar(name.charAt(0))) {
            return false;
        }
        for (int i = 1; i < name.length(); ++i) {
            if (TurtleUtil.isNameChar(name.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String encodeString(String s2) {
        s2 = StringUtil.gsub("\\", "\\\\", s2);
        s2 = StringUtil.gsub("\t", "\\t", s2);
        s2 = StringUtil.gsub("\n", "\\n", s2);
        s2 = StringUtil.gsub("\r", "\\r", s2);
        s2 = StringUtil.gsub("\"", "\\\"", s2);
        return s2;
    }

    public static String encodeLongString(String s2) {
        s2 = StringUtil.gsub("\\", "\\\\", s2);
        s2 = StringUtil.gsub("\"", "\\\"", s2);
        return s2;
    }

    public static String encodeURIString(String s2) {
        s2 = StringUtil.gsub("\\", "\\\\", s2);
        s2 = StringUtil.gsub(">", "\\>", s2);
        return s2;
    }

    public static String decodeString(String s2) {
        int backSlashIdx = s2.indexOf(92);
        if (backSlashIdx == -1) {
            return s2;
        }
        int startIdx = 0;
        int sLength = s2.length();
        StringBuffer buf = new StringBuffer(sLength);
        while (backSlashIdx != -1) {
            String xx;
            buf.append(s2.substring(startIdx, backSlashIdx));
            if (backSlashIdx + 1 >= sLength) {
                throw new IllegalArgumentException("Unescaped backslash in: " + s2);
            }
            char c = s2.charAt(backSlashIdx + 1);
            if (c == 't') {
                buf.append('\t');
                startIdx = backSlashIdx + 2;
            } else if (c == 'r') {
                buf.append('\r');
                startIdx = backSlashIdx + 2;
            } else if (c == 'n') {
                buf.append('\n');
                startIdx = backSlashIdx + 2;
            } else if (c == '\"') {
                buf.append('\"');
                startIdx = backSlashIdx + 2;
            } else if (c == '>') {
                buf.append('>');
                startIdx = backSlashIdx + 2;
            } else if (c == '\\') {
                buf.append('\\');
                startIdx = backSlashIdx + 2;
            } else if (c == 'u') {
                if (backSlashIdx + 5 >= sLength) {
                    throw new IllegalArgumentException("Incomplete Unicode escape sequence in: " + s2);
                }
                xx = s2.substring(backSlashIdx + 2, backSlashIdx + 6);
                try {
                    c = (char)Integer.parseInt(xx, 16);
                    buf.append(c);
                    startIdx = backSlashIdx + 6;
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Illegal Unicode escape sequence '\\u" + xx + "' in: " + s2);
                }
            } else if (c == 'U') {
                if (backSlashIdx + 9 >= sLength) {
                    throw new IllegalArgumentException("Incomplete Unicode escape sequence in: " + s2);
                }
                xx = s2.substring(backSlashIdx + 2, backSlashIdx + 10);
                try {
                    c = (char)Integer.parseInt(xx, 16);
                    buf.append(c);
                    startIdx = backSlashIdx + 10;
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Illegal Unicode escape sequence '\\U" + xx + "' in: " + s2);
                }
            } else {
                throw new IllegalArgumentException("Unescaped backslash in: " + s2);
            }
            backSlashIdx = s2.indexOf(92, startIdx);
        }
        buf.append(s2.substring(startIdx));
        return buf.toString();
    }
}

