/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.admin;

import java.io.IOException;
import java.io.OutputStream;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.sesame.admin.AdminListener;
import org.openrdf.util.xml.XmlWriter;

public class XmlAdminMsgWriter
implements AdminListener {
    private XmlWriter _xmlWriter;
    protected OutputStream _responseStream;
    private boolean _transactionStarted;

    public XmlAdminMsgWriter(OutputStream responseStream) {
        this._responseStream = responseStream;
        this._xmlWriter = new XmlWriter(responseStream);
        this._xmlWriter.setPrettyPrint(true);
        this._transactionStarted = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transactionStart() {
        if (this._transactionStarted) {
            return;
        }
        try {
            this._xmlWriter.startDocument();
            this._xmlWriter.startTag("transaction");
        }
        catch (IOException iOException) {
        }
        finally {
            this._transactionStarted = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transactionEnd() {
        if (!this._transactionStarted) {
            return;
        }
        try {
            this._xmlWriter.endTag("transaction");
            this._xmlWriter.endDocument();
            this._responseStream.close();
        }
        catch (IOException iOException) {
        }
        finally {
            this._transactionStarted = false;
        }
    }

    public void status(String msg, int lineNo, int colNo) {
        this._writeMsgBlock("status", msg, lineNo, colNo, null);
    }

    public void notification(String msg, int lineNo, int colNo, Statement statement) {
        this._writeMsgBlock("notification", msg, lineNo, colNo, statement);
    }

    public void warning(String msg, int lineNo, int colNo, Statement statement) {
        this._writeMsgBlock("warning", msg, lineNo, colNo, statement);
    }

    public void error(String msg, int lineNo, int colNo, Statement statement) {
        this._writeMsgBlock("error", msg, lineNo, colNo, statement);
    }

    private void _writeMsgBlock(String blockType, String msg, int lineNo, int colNo, Statement statement) {
        try {
            this._xmlWriter.startTag(blockType);
            this._xmlWriter.textElement("msg", msg == null ? "" : msg);
            if (lineNo != -1) {
                this._xmlWriter.textElement("line", lineNo);
                if (colNo != -1) {
                    this._xmlWriter.textElement("column", colNo);
                }
            }
            if (statement != null) {
                this._xmlWriter.startTag("statement");
                this._writeValue(statement.getSubject());
                this._writeValue(statement.getPredicate());
                this._writeValue(statement.getObject());
                this._xmlWriter.endTag("statement");
            }
            this._xmlWriter.endTag(blockType);
        }
        catch (IOException ignore) {
            // empty catch block
        }
    }

    private void _writeValue(Value value) throws IOException {
        if (value instanceof Literal) {
            Literal literal = (Literal)value;
            if (literal.getLanguage() != null) {
                this._xmlWriter.setAttribute("xml:lang", literal.getLanguage());
            }
            if (literal.getDatatype() != null) {
                this._xmlWriter.setAttribute("datatype", literal.getDatatype().getURI());
            }
        }
        if (value instanceof URI) {
            this._xmlWriter.textElement("uri", ((URI)value).getURI());
        } else if (value instanceof BNode) {
            this._xmlWriter.textElement("bNode", ((BNode)value).getID());
        } else if (value instanceof Literal) {
            this._xmlWriter.textElement("literal", ((Literal)value).getLabel());
        }
    }
}

