/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.config.handlers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openrdf.sesame.config.SystemConfig;
import org.openrdf.sesame.config.SystemConfigHandler;
import org.openrdf.sesame.config.handlers.SystemConfigReader;
import org.openrdf.sesame.config.handlers.SystemConfigWriter;
import org.openrdf.sesame.server.SesameServer;
import org.openrdf.util.log.ThreadLog;
import org.openrdf.util.xml.XMLReaderFactory;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class SystemConfigFileHandler
implements SystemConfigHandler {
    private static final String SYSCONFIGFILE = "systemConfigFile";
    protected Map _parameters;

    public void setParameters(Map parameters) {
        this._parameters = parameters;
    }

    public Set getParameterNames() {
        HashSet<String> result = new HashSet<String>();
        result.add(SYSCONFIGFILE);
        return result;
    }

    public SystemConfig loadConfig() throws IOException {
        String sysConfigFile = (String)this._parameters.get(SYSCONFIGFILE);
        File f = new File(SesameServer.getBaseDir(), sysConfigFile);
        try {
            FileInputStream in = new FileInputStream(f);
            SystemConfig newConfig = SystemConfigFileHandler.readConfiguration(in);
            ((InputStream)in).close();
            return newConfig;
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
    }

    public void storeConfig(SystemConfig config) throws IOException {
        String sysConfigFile = (String)this._parameters.get(SYSCONFIGFILE);
        File f = new File(SesameServer.getBaseDir(), sysConfigFile);
        try {
            FileOutputStream out = new FileOutputStream(f);
            SystemConfigFileHandler.writeConfiguration(config, out);
            ((OutputStream)out).close();
        }
        catch (IOException e) {
            ThreadLog.error("unable to store system configuration file '" + f + "'", e);
            throw e;
        }
    }

    public static SystemConfig readConfiguration(InputStream inputStream) throws IOException {
        try {
            SystemConfigReader scr = SystemConfigFileHandler._createSystemConfigReader();
            SystemConfig systemConfig = scr.read(inputStream);
            return systemConfig;
        }
        catch (SAXException e) {
            throw new IOException(e.getMessage());
        }
    }

    public static SystemConfig readConfiguration(Reader reader) throws IOException {
        try {
            SystemConfigReader scr = SystemConfigFileHandler._createSystemConfigReader();
            SystemConfig systemConfig = scr.read(reader);
            return systemConfig;
        }
        catch (SAXException e) {
            throw new IOException(e.getMessage());
        }
    }

    private static SystemConfigReader _createSystemConfigReader() {
        XMLReader xmlReader;
        try {
            xmlReader = XMLReaderFactory.createXMLReader();
        }
        catch (Exception e) {
            ThreadLog.error("Unable to create XMLReader", e);
            throw new RuntimeException(e.getMessage());
        }
        return new SystemConfigReader(xmlReader);
    }

    public static void writeConfiguration(SystemConfig config, OutputStream outputStream) throws IOException {
        SystemConfigWriter sysConfWriter = new SystemConfigWriter();
        sysConfWriter.write(config, outputStream);
        outputStream.flush();
    }

    public static void writeConfiguration(SystemConfig config, Writer writer) throws IOException {
        SystemConfigWriter sysConfWriter = new SystemConfigWriter();
        sysConfWriter.write(config, writer);
        writer.flush();
    }
}

