/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.query;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Iterator;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.sesame.query.QueryErrorType;
import org.openrdf.sesame.query.TableQueryResultListener;
import org.openrdf.sesame.query.rql.model.Intersection;
import org.openrdf.util.xml.XmlWriter;

public class XmlQueryResultWriter
implements TableQueryResultListener {
    private boolean _plainXMLLiterals = false;
    private XmlWriter _xmlWriter;

    public XmlQueryResultWriter(OutputStream out) {
        this(out, false);
    }

    public XmlQueryResultWriter(OutputStream out, boolean plainXMLLiterals) {
        this._xmlWriter = new XmlWriter(out);
        this._xmlWriter.setPrettyPrint(true);
        this._plainXMLLiterals = plainXMLLiterals;
    }

    public XmlQueryResultWriter(Writer writer) {
        this(writer, false);
    }

    public XmlQueryResultWriter(Writer writer, boolean plainXMLLiterals) {
        this._xmlWriter = new XmlWriter(writer);
        this._xmlWriter.setPrettyPrint(true);
        this._plainXMLLiterals = plainXMLLiterals;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this._xmlWriter.setPrettyPrint(prettyPrint);
    }

    public void startTableQueryResult() throws IOException {
        this.startTableQueryResult(null);
    }

    public void startTableQueryResult(String[] columnHeaders) throws IOException {
        this._xmlWriter.startDocument();
        this._xmlWriter.startTag("tableQueryResult");
        if (columnHeaders != null) {
            this._xmlWriter.startTag("header");
            for (int i = 0; i < columnHeaders.length; ++i) {
                this._xmlWriter.textElement("columnName", columnHeaders[i]);
            }
            this._xmlWriter.endTag("header");
        }
    }

    public void endTableQueryResult() throws IOException {
        this._xmlWriter.endTag("tableQueryResult");
        this._xmlWriter.endDocument();
    }

    public void startTuple() throws IOException {
        this._xmlWriter.startTag("tuple");
    }

    public void endTuple() throws IOException {
        this._xmlWriter.endTag("tuple");
    }

    public void tupleValue(Value value) throws IOException {
        if (value instanceof Intersection) {
            this._writeIntersection((Intersection)value);
        } else if (value instanceof URI) {
            this._writeURI((URI)value);
        } else if (value instanceof BNode) {
            this._writeBNode((BNode)value);
        } else if (value instanceof Literal) {
            this._writeLiteral((Literal)value);
        } else if (value == null) {
            this._writeNull();
        }
    }

    public void error(QueryErrorType errType, String msg) throws IOException {
        if (this._xmlWriter == null) {
            this.startTableQueryResult();
        }
        this._xmlWriter.setAttribute("type", errType.toString());
        this._xmlWriter.textElement("error", msg);
    }

    private void _writeURI(URI uri) throws IOException {
        this._xmlWriter.textElement("uri", uri.getURI());
    }

    private void _writeBNode(BNode bNode) throws IOException {
        this._xmlWriter.textElement("bNode", bNode.getID());
    }

    private void _writeLiteral(Literal literal) throws IOException {
        boolean isXmlLiteral = false;
        if (literal.getLanguage() != null) {
            this._xmlWriter.setAttribute("xml:lang", literal.getLanguage());
        }
        if (literal.getDatatype() != null) {
            URI datatype = literal.getDatatype();
            this._xmlWriter.setAttribute("datatype", datatype.getURI());
            isXmlLiteral = ((Object)datatype).equals(URIImpl.RDF_XMLLITERAL);
        }
        if (isXmlLiteral && this._plainXMLLiterals) {
            this._xmlWriter.unescapedTextElement("literal", literal.getLabel());
        } else {
            this._xmlWriter.textElement("literal", literal.getLabel());
        }
    }

    private void _writeIntersection(Intersection intersection) throws IOException {
        this._xmlWriter.startTag("intersection");
        Iterator i = intersection.getMembers().iterator();
        while (i.hasNext()) {
            Resource resource = (Resource)i.next();
            if (resource instanceof URI) {
                this._writeURI((URI)resource);
                continue;
            }
            this._writeBNode((BNode)resource);
        }
        this._xmlWriter.endTag("intersection");
    }

    private void _writeNull() throws IOException {
        this._xmlWriter.emptyElement("null");
    }
}

