/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.query.rql.model;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.openrdf.model.GraphException;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.sesame.query.rql.model.iterators.StatementSubjectIterator;
import org.openrdf.sesame.sail.RdfSchemaSource;
import org.openrdf.sesame.sail.StatementIterator;
import org.openrdf.sesame.sail.ValueIterator;
import org.openrdf.sesame.sail.util.ValueCollectionIterator;

public class Intersection
implements Resource {
    private TreeSet _memberSet = new TreeSet();

    public Intersection() {
    }

    public Intersection(StatementIterator statIter) {
        this();
        while (statIter.hasNext()) {
            Statement stat = statIter.next();
            Value v = stat.getObject();
            if (!(v instanceof Resource)) continue;
            this.add((Resource)v);
        }
        statIter.close();
    }

    public Set getMembers() {
        return this._memberSet;
    }

    public Resource getFirstMember() {
        if (this._memberSet.size() > 0) {
            return (Resource)this._memberSet.iterator().next();
        }
        return null;
    }

    public void add(Resource resource) {
        this._memberSet.add(resource);
    }

    public Value minimize(RdfSchemaSource rss) {
        if (this._memberSet.size() == 0) {
            return this;
        }
        if (this._memberSet.size() == 1) {
            return this.getFirstMember();
        }
        Iterator memberIter = this._memberSet.iterator();
        TreeSet resultSet = new TreeSet(this._memberSet);
        while (memberIter.hasNext()) {
            Resource member = (Resource)memberIter.next();
            StatementIterator superClasses = rss.getDirectSubClassOf(member, null);
            while (superClasses.hasNext()) {
                Resource superClass = (Resource)superClasses.next().getObject();
                if (member.equals(superClass)) continue;
                resultSet.remove(superClass);
            }
        }
        this._memberSet = resultSet;
        if (this._memberSet.size() == 1) {
            return this.getFirstMember();
        }
        return this;
    }

    public int size() {
        return this._memberSet.size();
    }

    public boolean containsInstance(Resource instance, RdfSchemaSource rss) {
        boolean result = true;
        Iterator iter = this._memberSet.iterator();
        while (iter.hasNext()) {
            Resource clazz = (Resource)iter.next();
            if (rss.isType(instance, clazz)) continue;
            result = false;
            break;
        }
        return result;
    }

    public ValueIterator getInstances(RdfSchemaSource rss) {
        if (this.size() == 0) {
            return new StatementSubjectIterator(rss.getType(null, URIImpl.RDFS_RESOURCE));
        }
        Iterator iter = this._memberSet.iterator();
        Resource clazz = (Resource)iter.next();
        Set result = this._getInstances(clazz, rss);
        while (iter.hasNext()) {
            clazz = (Resource)iter.next();
            Set instances = this._getInstances(clazz, rss);
            result.retainAll(instances);
        }
        return new ValueCollectionIterator(result);
    }

    private Set _getInstances(Resource clazz, RdfSchemaSource rss) {
        HashSet<Resource> result = new HashSet<Resource>();
        StatementIterator statIter = rss.getType(null, clazz);
        while (statIter.hasNext()) {
            result.add(statIter.next().getSubject());
        }
        statIter.close();
        return result;
    }

    public boolean equals(Object other) {
        if (other instanceof Intersection) {
            return this._memberSet.equals(((Intersection)other).getMembers());
        }
        return false;
    }

    public boolean lowerEqualThan(Intersection other, RdfSchemaSource rss) {
        Set set2 = other.getMembers();
        if (this._memberSet.containsAll(set2)) {
            return true;
        }
        TreeSet difference = new TreeSet(set2);
        difference.removeAll(this._memberSet);
        Iterator diffIter = difference.iterator();
        while (diffIter.hasNext()) {
            boolean subClassInSet = false;
            Resource classResource = (Resource)diffIter.next();
            StatementIterator subClassIter = rss.getSubClassOf(null, classResource);
            while (!subClassInSet && subClassIter.hasNext()) {
                Resource subClass = subClassIter.next().getSubject();
                if (!this._memberSet.contains(subClass)) continue;
                subClassInSet = true;
            }
            if (subClassInSet) continue;
            return false;
        }
        return true;
    }

    public boolean greaterThan(Intersection other, RdfSchemaSource rss) {
        return !this.lowerEqualThan(other, rss);
    }

    public boolean greaterEqualThan(Intersection other, RdfSchemaSource rss) {
        return this.equals(other) || this.greaterThan(other, rss);
    }

    public boolean lowerThan(Intersection other, RdfSchemaSource rss) {
        return !this.equals(other) && this.lowerEqualThan(other, rss);
    }

    public int hashCode() {
        return this._memberSet.hashCode();
    }

    public int compareTo(Object o) {
        Intersection other = (Intersection)o;
        int result = this.size() - other.size();
        if (result == 0) {
            Iterator thisIter = this.getMembers().iterator();
            Iterator otherIter = other.getMembers().iterator();
            while (result == 0 && thisIter.hasNext()) {
                Resource thisRes = (Resource)thisIter.next();
                Resource otherRes = (Resource)otherIter.next();
                result = thisRes.compareTo(otherRes);
            }
        }
        return result;
    }

    public String toString() {
        return this._memberSet.toString();
    }

    public void addProperty(URI property, Value value) throws GraphException {
        throw new GraphException("no backing store associated");
    }

    public StatementIterator getSubjectStatements() throws GraphException {
        throw new GraphException("no backing store associated");
    }

    public StatementIterator getObjectStatements() throws GraphException {
        throw new GraphException("no backing store associated");
    }
}

