/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.query.rql.model;

import java.io.IOException;
import org.openrdf.model.Resource;
import org.openrdf.model.Value;
import org.openrdf.sesame.query.QueryEvaluationException;
import org.openrdf.sesame.query.TableQueryResultListener;
import org.openrdf.sesame.query.rql.model.ClassQuery;
import org.openrdf.sesame.query.rql.model.iterators.NestedResourceIterator;
import org.openrdf.sesame.query.rql.model.iterators.StatementSubjectIterator;
import org.openrdf.sesame.sail.RdfSchemaSource;
import org.openrdf.sesame.sail.ResourceIterator;
import org.openrdf.sesame.sail.StatementIterator;
import org.openrdf.sesame.sail.ValueIterator;

public class SubClassOf
implements ClassQuery {
    protected ClassQuery _classQ;
    protected boolean _recursive;

    public SubClassOf(ClassQuery classQ, boolean recursive) {
        this._classQ = classQ;
        this._recursive = recursive;
    }

    public void evaluate(RdfSchemaSource rss, TableQueryResultListener listener) throws QueryEvaluationException {
        ValueIterator iter = null;
        try {
            String[] columnHeaders = new String[]{this.getQuery()};
            listener.startTableQueryResult(columnHeaders);
            iter = this.getClasses(rss);
            while (iter.hasNext()) {
                listener.startTuple();
                listener.tupleValue(iter.next());
                listener.endTuple();
            }
            listener.endTableQueryResult();
        }
        catch (IOException e) {
            throw new QueryEvaluationException(e);
        }
        finally {
            if (iter != null) {
                iter.close();
            }
        }
    }

    public ClassQuery getArgument() {
        return this._classQ;
    }

    public ValueIterator getResources(RdfSchemaSource rss) throws QueryEvaluationException {
        return this.getClasses(rss);
    }

    public ResourceIterator getClasses(RdfSchemaSource rss) throws QueryEvaluationException {
        ResourceIterator classIter = this._classQ.getClasses(rss);
        return new Iterator(rss, classIter);
    }

    public boolean returnsSet() {
        return true;
    }

    public String getQuery() {
        return this.toString();
    }

    public String toString() {
        if (this._recursive) {
            return "subClassOf(" + this._classQ.toString() + ")";
        }
        return "subClassOf^(" + this._classQ.toString() + ")";
    }

    class Iterator
    extends NestedResourceIterator {
        protected RdfSchemaSource _rss;

        public Iterator(RdfSchemaSource rss, ResourceIterator classIter) {
            super(classIter);
            this._rss = rss;
        }

        public ResourceIterator getInnerIterator(Value classRes) {
            StatementIterator statIter = SubClassOf.this._recursive ? this._rss.getSubClassOf(null, (Resource)classRes) : this._rss.getDirectSubClassOf(null, (Resource)classRes);
            return new StatementSubjectIterator(statIter);
        }
    }
}

