/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.query.rql.model;

import java.io.IOException;
import org.openrdf.model.Resource;
import org.openrdf.model.Value;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.sesame.query.QueryEvaluationException;
import org.openrdf.sesame.query.TableQueryResultListener;
import org.openrdf.sesame.query.rql.model.ClassQuery;
import org.openrdf.sesame.query.rql.model.ResourceQuery;
import org.openrdf.sesame.query.rql.model.iterators.NestedResourceIterator;
import org.openrdf.sesame.query.rql.model.iterators.StatementObjectIterator;
import org.openrdf.sesame.sail.RdfSchemaSource;
import org.openrdf.sesame.sail.ResourceIterator;
import org.openrdf.sesame.sail.StatementIterator;
import org.openrdf.sesame.sail.ValueIterator;
import org.openrdf.sesame.sail.util.SingleResourceIterator;

public class TypeOf
implements ClassQuery {
    protected ResourceQuery _instanceQ;
    protected boolean _recursive;

    public TypeOf(ResourceQuery instanceQ, boolean recursive) {
        this._instanceQ = instanceQ;
        this._recursive = recursive;
    }

    public void evaluate(RdfSchemaSource rss, TableQueryResultListener listener) throws QueryEvaluationException {
        ValueIterator iter = null;
        try {
            String[] columnHeaders = new String[]{this.getQuery()};
            listener.startTableQueryResult(columnHeaders);
            iter = this.getClasses(rss);
            while (iter.hasNext()) {
                listener.startTuple();
                listener.tupleValue(iter.next());
                listener.endTuple();
            }
            listener.endTableQueryResult();
        }
        catch (IOException e) {
            throw new QueryEvaluationException(e);
        }
        finally {
            if (iter != null) {
                iter.close();
            }
        }
    }

    public ValueIterator getResources(RdfSchemaSource rss) throws QueryEvaluationException {
        return this.getClasses(rss);
    }

    public ResourceIterator getClasses(RdfSchemaSource rss) throws QueryEvaluationException {
        ValueIterator instanceIter = this._instanceQ.getResources(rss);
        return new Iterator(rss, instanceIter);
    }

    public boolean returnsSet() {
        return true;
    }

    public String getQuery() {
        return this.toString();
    }

    public String toString() {
        if (this._recursive) {
            return "typeOf(" + this._instanceQ.toString() + ")";
        }
        return "typeOf^(" + this._instanceQ.toString() + ")";
    }

    class Iterator
    extends NestedResourceIterator {
        protected RdfSchemaSource _rss;

        public Iterator(RdfSchemaSource rss, ValueIterator instanceIter) {
            super(instanceIter);
            this._rss = rss;
        }

        public ResourceIterator getInnerIterator(Value instance) {
            if (instance instanceof Resource) {
                StatementIterator statIter = TypeOf.this._recursive ? this._rss.getType((Resource)instance, null) : this._rss.getDirectType((Resource)instance, null);
                return new StatementObjectIterator(statIter);
            }
            return new SingleResourceIterator(URIImpl.RDFS_LITERAL);
        }
    }
}

