/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.query.serql.parser;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.openrdf.model.Value;
import org.openrdf.sesame.query.serql.parser.SerqlParser;
import org.openrdf.sesame.sail.query.DirectSubClassOf;
import org.openrdf.sesame.sail.query.DirectSubPropertyOf;
import org.openrdf.sesame.sail.query.DirectType;
import org.openrdf.sesame.sail.query.TriplePattern;
import org.openrdf.sesame.sail.query.Var;

public class PathElement {
    protected List _subjectVars;
    protected Var _edge;
    protected List _objectVars;

    public PathElement(List subjectVars, Var edge, List objectVars) {
        this._subjectVars = subjectVars;
        this._edge = edge;
        this._objectVars = objectVars;
    }

    public List getSubjectVars() {
        return this._subjectVars;
    }

    public Var getEdge() {
        return this._edge;
    }

    public List getObjectVars() {
        return this._objectVars;
    }

    public List getTriplePatterns() {
        ArrayList triplePatterns = new ArrayList();
        Iterator leftIter = this._subjectVars.iterator();
        while (leftIter.hasNext()) {
            Var subject = (Var)leftIter.next();
            Iterator rightIter = this._objectVars.iterator();
            while (rightIter.hasNext()) {
                Var object = (Var)rightIter.next();
                this._createTriplePatterns(subject, this._edge, object, triplePatterns);
            }
        }
        return triplePatterns;
    }

    protected void _createTriplePatterns(Var subject, Var predicate, Var object, List triplePatterns) {
        Value predValue = predicate.getValue();
        TriplePattern newPE = ((Object)SerqlParser.SERQL_DIRECTSUBCLASSOF).equals(predValue) ? new DirectSubClassOf(subject, object) : (((Object)SerqlParser.SERQL_DIRECTSUBPROPERTYOF).equals(predValue) ? new DirectSubPropertyOf(subject, object) : (((Object)SerqlParser.SERQL_DIRECTTYPE).equals(predValue) ? new DirectType(subject, object) : new TriplePattern(subject, predicate, object)));
        triplePatterns.add(newPE);
    }

    public String toString() {
        String result = "{";
        Iterator i = this._subjectVars.iterator();
        while (i.hasNext()) {
            result = result + i.next().toString();
            if (!i.hasNext()) continue;
            result = result + ", ";
        }
        result = result + "} ";
        result = result + this._edge.toString();
        result = result + " {";
        i = this._objectVars.iterator();
        while (i.hasNext()) {
            result = result + i.next().toString();
            if (!i.hasNext()) continue;
            result = result + ", ";
        }
        result = result + "}";
        return result;
    }
}

