/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.sailimpl.nativerdf;

import java.io.IOException;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.sesame.sail.SailInternalException;
import org.openrdf.sesame.sail.StatementIterator;
import org.openrdf.sesame.sailimpl.nativerdf.TripleStore;
import org.openrdf.sesame.sailimpl.nativerdf.ValueStore;
import org.openrdf.sesame.sailimpl.nativerdf.btree.BTreeIterator;
import org.openrdf.util.ByteArrayUtil;

public class NativeStatementIterator
implements StatementIterator {
    private BTreeIterator _btreeIter;
    private ValueStore _valueStore;
    private ValueFactory _valueFactory;
    private Resource _subj;
    private URI _pred;
    private Value _obj;
    private byte[] _nextValue;

    public NativeStatementIterator(TripleStore tripleStore, ValueStore valueStore, ValueFactory valueFactory, Resource subj, URI pred, Value obj, int subjID, int predID, int objID) throws IOException {
        this._valueStore = valueStore;
        this._valueFactory = valueFactory;
        this._subj = subj;
        this._pred = pred;
        this._obj = obj;
        this._btreeIter = tripleStore.getTriples(subjID, predID, objID);
        this._nextValue = this._btreeIter.next();
    }

    public boolean hasNext() {
        return this._nextValue != null;
    }

    public Statement next() {
        try {
            Value obj;
            URI pred;
            Resource subj = this._subj;
            if (subj == null) {
                int subjID = ByteArrayUtil.getInt(this._nextValue, 0);
                subj = (Resource)this._valueStore.getValue(subjID);
            }
            if ((pred = this._pred) == null) {
                int predID = ByteArrayUtil.getInt(this._nextValue, 4);
                pred = (URI)this._valueStore.getValue(predID);
            }
            if ((obj = this._obj) == null) {
                int objID = ByteArrayUtil.getInt(this._nextValue, 8);
                obj = this._valueStore.getValue(objID);
            }
            this._nextValue = this._btreeIter.next();
            return this._valueFactory.createStatement(subj, pred, obj);
        }
        catch (IOException e) {
            throw new SailInternalException(e);
        }
    }

    public void close() {
        this._nextValue = null;
        if (this._btreeIter != null) {
            try {
                this._btreeIter.close();
            }
            catch (IOException e) {
                throw new SailInternalException(e);
            }
            finally {
                this._btreeIter = null;
            }
        }
    }
}

