/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.sailimpl.rdbms;

import java.sql.SQLException;
import org.openrdf.sesame.sailimpl.rdbms.RDBMS;
import org.openrdf.sesame.sailimpl.rdbms.RdfSchemaRepository;
import org.openrdf.sesame.sailimpl.rdbms.TableNames;
import org.openrdf.util.log.ThreadLog;

public class RdfMTDependencyInferencer
implements TableNames {
    protected RdfSchemaRepository _sail;
    protected RDBMS _rdbms;

    public RdfMTDependencyInferencer(RdfSchemaRepository sail, RDBMS rdbms) {
        this._sail = sail;
        this._rdbms = rdbms;
    }

    public void markAxioms() throws SQLException {
        ThreadLog.trace("adding dependencies for axioms");
        this._rdbms.executeUpdate("INSERT INTO depend SELECT id, 0, 0 FROM allnewtriples");
        ThreadLog.trace("dependencies for axioms added");
    }

    public void processNewStatements() throws SQLException {
        ThreadLog.trace("adding dependencies for new statements");
        this._addRuleRdf1Dependencies();
        this._addRuleRdfs2Dependencies();
        this._addRuleRdfs3Dependencies();
        this._addRuleRdfs4aDependencies();
        this._addRuleRdfs4bDependencies();
        this._addRuleRdfs5Dependencies();
        this._addRuleRdfs6Dependencies();
        this._addRuleRdfs7Dependencies();
        this._addRuleRdfs8Dependencies();
        this._addRuleRdfs9Dependencies();
        this._addRuleRdfs10Dependencies();
        this._addRuleRdfs11Dependencies();
        this._addRuleRdfs12Dependencies();
        this._addRuleRdfs13Dependencies();
        this._addRuleX1Dependencies();
        ThreadLog.trace("dependencies for new statements added");
    }

    protected void _addRuleRdf1Dependencies() throws SQLException {
        this._rdbms.executeUpdate("INSERT INTO depend SELECT t.id, dep1.id, 0 FROM allnewtriples dep1, triples t WHERE dep1.pred = t.subj AND t.pred = " + this._sail.rdfTypeId + " AND t.obj = " + this._sail.rdfPropertyId + " AND dep1.id <> t.id");
    }

    protected void _addRuleRdfs2Dependencies() throws SQLException {
        this._rdbms.executeUpdate("INSERT INTO depend SELECT t.id, dep1.id, dep2.id FROM allnewtriples dep1, triples dep2, triples t WHERE dep1.pred = dep2.subj AND dep1.subj = t.subj AND dep2.pred = " + this._sail.rdfsDomainId + " AND dep2.obj = t.obj" + " AND t.pred = " + this._sail.rdfTypeId + " AND dep1.id <> t.id");
        this._rdbms.executeUpdate("INSERT INTO depend SELECT t.id, dep1.id, dep2.id FROM triples dep1, allnewtriples dep2, triples t WHERE dep1.pred = dep2.subj AND dep1.subj = t.subj AND dep2.pred = " + this._sail.rdfsDomainId + " AND dep2.obj = t.obj" + " AND t.pred = " + this._sail.rdfTypeId + " AND dep1.id <> t.id");
    }

    protected void _addRuleRdfs3Dependencies() throws SQLException {
        this._rdbms.executeUpdate("INSERT INTO depend SELECT t.id, dep1.id, dep2.id FROM allnewtriples dep1, triples dep2, triples t WHERE dep1.pred = dep2.subj AND dep1.obj = t.subj AND dep2.pred = " + this._sail.rdfsRangeId + " AND dep2.obj = t.obj" + " AND t.pred = " + this._sail.rdfTypeId + " AND dep1.id <> t.id");
        this._rdbms.executeUpdate("INSERT INTO depend SELECT t.id, dep1.id, dep2.id FROM triples dep1, allnewtriples dep2, triples t WHERE dep1.pred = dep2.subj AND dep1.obj = t.subj AND dep2.pred = " + this._sail.rdfsRangeId + " AND dep2.obj = t.obj" + " AND t.pred = " + this._sail.rdfTypeId + " AND dep1.id <> t.id");
    }

    protected void _addRuleRdfs4aDependencies() throws SQLException {
        this._rdbms.executeUpdate("INSERT INTO depend SELECT t.id, dep1.id, 0 FROM allnewtriples dep1, triples t WHERE dep1.subj = t.subj AND t.pred = " + this._sail.rdfTypeId + " AND t.obj = " + this._sail.rdfsResourceId + " AND dep1.id <> t.id");
    }

    protected void _addRuleRdfs4bDependencies() throws SQLException {
        this._rdbms.executeUpdate("INSERT INTO depend SELECT t.id, dep1.id, 0 FROM allnewtriples dep1, triples t WHERE dep1.obj > 0 AND dep1.obj = t.subj AND t.pred = " + this._sail.rdfTypeId + " AND t.obj = " + this._sail.rdfsResourceId + " AND dep1.id <> t.id");
    }

    protected void _addRuleRdfs5Dependencies() throws SQLException {
        this._rdbms.executeUpdate("INSERT INTO depend SELECT t.id, dep1.id, dep2.id FROM allnewtriples dep1, triples dep2, triples t WHERE dep1.pred = " + this._sail.rdfsSubPropertyOfId + " AND dep2.pred = " + this._sail.rdfsSubPropertyOfId + " AND t.pred = " + this._sail.rdfsSubPropertyOfId + " AND dep1.subj = t.subj" + " AND dep1.obj = dep2.subj" + " AND dep2.obj = t.obj" + " AND dep1.id <> t.id" + " AND dep2.id <> t.id");
        this._rdbms.executeUpdate("INSERT INTO depend SELECT t.id, dep1.id, dep2.id FROM triples dep1, allnewtriples dep2, triples t WHERE dep1.pred = " + this._sail.rdfsSubPropertyOfId + " AND dep2.pred = " + this._sail.rdfsSubPropertyOfId + " AND t.pred = " + this._sail.rdfsSubPropertyOfId + " AND dep1.subj = t.subj" + " AND dep1.obj = dep2.subj" + " AND dep2.obj = t.obj" + " AND dep1.id <> t.id" + " AND dep2.id <> t.id");
    }

    protected void _addRuleRdfs6Dependencies() throws SQLException {
        this._rdbms.executeUpdate("INSERT INTO depend SELECT t.id, dep1.id, 0 FROM allnewtriples dep1, triples t WHERE dep1.pred = " + this._sail.rdfTypeId + " AND dep1.obj = " + this._sail.rdfPropertyId + " AND t.pred = " + this._sail.rdfsSubPropertyOfId + " AND dep1.subj = t.subj " + " AND t.subj = t.obj ");
    }

    protected void _addRuleRdfs7Dependencies() throws SQLException {
        this._rdbms.executeUpdate("INSERT INTO depend SELECT t.id, dep1.id, dep2.id FROM allnewtriples dep1, triples dep2, triples t WHERE dep1.subj = t.subj AND dep1.pred = dep2.subj AND dep1.obj = t.obj AND dep2.pred = " + this._sail.rdfsSubPropertyOfId + " AND dep2.obj = t.pred" + " AND dep1.id <> t.id" + " AND dep2.id <> t.id");
        this._rdbms.executeUpdate("INSERT INTO depend SELECT t.id, dep1.id, dep2.id FROM triples dep1, allnewtriples dep2, triples t WHERE dep1.subj = t.subj AND dep1.pred = dep2.subj AND dep1.obj = t.obj AND dep2.pred = " + this._sail.rdfsSubPropertyOfId + " AND dep2.obj = t.pred" + " AND dep1.id <> t.id" + " AND dep2.id <> t.id");
    }

    protected void _addRuleRdfs8Dependencies() throws SQLException {
        this._rdbms.executeUpdate("INSERT INTO depend SELECT t.id, dep1.id, 0 FROM allnewtriples dep1, triples t WHERE dep1.subj = t.subj AND dep1.pred = " + this._sail.rdfTypeId + " AND dep1.obj = " + this._sail.rdfsClassId + " AND t.pred = " + this._sail.rdfsSubClassOfId + " AND t.obj = " + this._sail.rdfsResourceId);
    }

    protected void _addRuleRdfs10Dependencies() throws SQLException {
        this._rdbms.executeUpdate("INSERT INTO depend SELECT t.id, dep1.id, 0 FROM allnewtriples dep1, triples t WHERE dep1.subj = t.subj AND dep1.pred = " + this._sail.rdfTypeId + " AND dep1.obj = " + this._sail.rdfsClassId + " AND t.pred = " + this._sail.rdfsSubClassOfId + " AND t.subj = t.obj");
    }

    protected void _addRuleRdfs11Dependencies() throws SQLException {
        this._rdbms.executeUpdate("INSERT INTO depend SELECT t.id, dep1.id, dep2.id FROM allnewtriples dep1, triples dep2, triples t WHERE dep1.pred = " + this._sail.rdfsSubClassOfId + " AND dep2.pred = " + this._sail.rdfsSubClassOfId + " AND t.pred = " + this._sail.rdfsSubClassOfId + " AND dep1.subj = t.subj" + " AND dep1.obj = dep2.subj" + " AND dep2.obj = t.obj" + " AND dep1.id <> t.id" + " AND dep2.id <> t.id");
        this._rdbms.executeUpdate("INSERT INTO depend SELECT t.id, dep1.id, dep2.id FROM triples dep1, allnewtriples dep2, triples t WHERE dep1.pred = " + this._sail.rdfsSubClassOfId + " AND dep2.pred = " + this._sail.rdfsSubClassOfId + " AND t.pred = " + this._sail.rdfsSubClassOfId + " AND dep1.subj = t.subj" + " AND dep1.obj = dep2.subj" + " AND dep2.obj = t.obj" + " AND dep1.id <> t.id" + " AND dep2.id <> t.id");
    }

    protected void _addRuleRdfs9Dependencies() throws SQLException {
        this._rdbms.executeUpdate("INSERT INTO depend SELECT t.id, dep1.id, dep2.id FROM allnewtriples dep1, triples dep2, triples t WHERE dep1.subj = dep2.obj AND dep1.pred = " + this._sail.rdfsSubClassOfId + " AND dep1.obj = t.obj" + " AND dep2.subj = t.subj" + " AND dep2.pred = " + this._sail.rdfTypeId + " AND t.pred = " + this._sail.rdfTypeId + " AND dep2.id <> t.id");
        this._rdbms.executeUpdate("INSERT INTO depend SELECT t.id, dep1.id, dep2.id FROM triples dep1, allnewtriples dep2, triples t WHERE dep1.subj = dep2.obj AND dep1.pred = " + this._sail.rdfsSubClassOfId + " AND dep1.obj = t.obj" + " AND dep2.subj = t.subj" + " AND dep2.pred = " + this._sail.rdfTypeId + " AND t.pred = " + this._sail.rdfTypeId + " AND dep2.id <> t.id");
    }

    protected void _addRuleRdfs12Dependencies() throws SQLException {
        this._rdbms.executeUpdate("INSERT INTO depend SELECT t.id, dep1.id, 0 FROM allnewtriples dep1, triples t WHERE dep1.subj = t.subj AND dep1.pred = " + this._sail.rdfTypeId + " AND dep1.obj = " + this._sail.rdfsContainerMembershipPropertyId + " AND t.pred = " + this._sail.rdfsSubPropertyOfId + " AND t.obj = " + this._sail.rdfsMemberId);
    }

    protected void _addRuleRdfs13Dependencies() throws SQLException {
        this._rdbms.executeUpdate("INSERT INTO depend SELECT t.id, dep1.id, 0 FROM allnewtriples dep1, triples t WHERE dep1.subj = t.subj AND dep1.pred = " + this._sail.rdfTypeId + " AND dep1.obj = " + this._sail.rdfsDatatypeId + " AND t.pred = " + this._sail.rdfsSubClassOfId + " AND t.obj = " + this._sail.rdfsLiteralId);
    }

    /*
     * WARNING - void declaration
     */
    protected void _addRuleX1Dependencies() throws SQLException {
        void var2_2;
        String likePattern;
        int rdfNsId = this._sail._getNamespaceId("http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        if (rdfNsId == 0) {
            return;
        }
        if (this._rdbms.getSearchStringEscape() != null) {
            likePattern = "'" + this._rdbms.getSearchStringEscape() + "_%' ";
        } else if (this._rdbms.supportsLikeEscapeClause()) {
            likePattern = "'\\_%' ESCAPE '\\' ";
        } else {
            throw new SQLException("Unable to create like pattern; no escape character available");
        }
        this._rdbms.executeUpdate("INSERT INTO depend SELECT t.id, dep1.id, 0 FROM allnewtriples dep1, triples t, resources r WHERE dep1.pred = t.subj AND t.pred = " + this._sail.rdfTypeId + " AND t.obj = " + this._sail.rdfsContainerMembershipPropertyId + " AND dep1.pred = r.id " + " AND r.namespace = " + rdfNsId + " AND r.localname LIKE " + (String)var2_2);
    }
}

