/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.sailimpl.rdbms.model;

import org.openrdf.model.GraphException;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.BNodeImpl;
import org.openrdf.sesame.sail.RdfRepository;
import org.openrdf.sesame.sail.SailUpdateException;
import org.openrdf.sesame.sail.StatementIterator;
import org.openrdf.sesame.sailimpl.rdbms.RdfSource;
import org.openrdf.sesame.sailimpl.rdbms.model.IdResource;

public class IdBNode
extends BNodeImpl
implements IdResource {
    protected transient RdfSource _source;
    protected transient int _internalId;

    public IdBNode(RdfSource source, String nodeID, int internalId) {
        super(nodeID);
        this._source = source;
        this._internalId = internalId;
    }

    public RdfSource getRdfSource() {
        return this._source;
    }

    public int getInternalId() {
        return this._internalId;
    }

    public void setInternalId(int internalId) {
        this._internalId = internalId;
    }

    public StatementIterator getSubjectStatements() throws GraphException {
        return this._source.getStatements(this, null, null);
    }

    public StatementIterator getObjectStatements() throws GraphException {
        return this._source.getStatements(null, null, this);
    }

    public void addProperty(URI property, Value value) throws GraphException {
        if (this._source instanceof RdfRepository) {
            RdfRepository rep = (RdfRepository)((Object)this._source);
            rep.startTransaction();
            try {
                rep.addStatement(this, property, value);
            }
            catch (SailUpdateException e) {
                throw new GraphException(e);
            }
            finally {
                rep.commitTransaction();
            }
        } else {
            throw new GraphException("source not writable");
        }
    }
}

