/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.server;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.openrdf.sesame.config.SystemConfig;
import org.openrdf.sesame.config.SystemConfigCenterListener;
import org.openrdf.sesame.repository.RepositoryList;
import org.openrdf.sesame.repository.local.LocalService;
import org.openrdf.util.io.IOUtil;
import org.openrdf.util.log.ThreadLog;

public class SesameServer {
    private static LocalService _localService;
    private static SystemConfig _sysConfig;
    private static File _baseDir;
    private static String _version;
    private static List _listeners;

    public static void createLocalService() {
        _localService = new LocalService(_sysConfig);
    }

    public static LocalService getLocalService() {
        return _localService;
    }

    public static SystemConfig getSystemConfig() {
        return _sysConfig;
    }

    public static void setSystemConfig(SystemConfig newConfig) {
        boolean oldEnabled = false;
        String oldFac = null;
        int oldPort = -1;
        if (_sysConfig != null) {
            oldEnabled = _sysConfig.isRMIEnabled();
            oldFac = _sysConfig.getRMIFactoryClass();
            oldPort = _sysConfig.getRMIPort();
        }
        boolean newEnabled = newConfig.isRMIEnabled();
        String newFac = newConfig.getRMIFactoryClass();
        int newPort = newConfig.getRMIPort();
        if (oldEnabled != newEnabled || oldFac == null != (newFac == null) || oldFac != null && !oldFac.equals(newFac) || oldPort != newPort) {
            if (oldEnabled) {
                SesameServer._unbindRMIServer(oldFac, oldPort);
            }
            if (newEnabled) {
                SesameServer._bindRMIServer(newFac, newPort);
            }
        }
        Properties oldSystemProps = _sysConfig.getSystemProps();
        Iterator<Object> keys = oldSystemProps.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            System.setProperty(key, "");
        }
        Properties newSystemProps = newConfig.getSystemProps();
        keys = newSystemProps.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String value = newSystemProps.getProperty(key);
            System.setProperty(key, value);
        }
        _sysConfig = newConfig;
        if (_localService == null) {
            SesameServer.createLocalService();
        } else {
            _localService.setSystemConfig(newConfig);
        }
        SesameServer._notifyListeners();
    }

    public static void setBaseDir(File baseDir) {
        _baseDir = baseDir;
    }

    public static File getBaseDir() {
        return _baseDir;
    }

    public static void setDefaultLogFile(String fileName) {
        if (_sysConfig.getLogDir() == null || fileName == null) {
            ThreadLog.setDefaultLog(null, 2);
        } else {
            File logDir = new File(_baseDir, _sysConfig.getLogDir());
            String logFile = new File(logDir, fileName).getPath();
            int logLevel = _sysConfig.getLogLevel();
            ThreadLog.setDefaultLog(logFile, logLevel);
        }
    }

    public static void unsetDefaultLogFile() {
        ThreadLog.unsetDefaultLog();
    }

    public static void setThreadLogFile(String fileName) {
        if (_sysConfig.getLogDir() == null || fileName == null) {
            ThreadLog.registerThread(null, 5);
        } else {
            File logDir = new File(_baseDir, _sysConfig.getLogDir());
            String logFile = new File(logDir, fileName).getPath();
            int logLevel = _sysConfig.getLogLevel();
            ThreadLog.registerThread(logFile, logLevel);
        }
    }

    public static void setThreadLogFileForRepository(String repositoryID) {
        RepositoryList list = _localService.getRepositoryList();
        if (list.getRepository(repositoryID) != null) {
            SesameServer.setThreadLogFile("repositories/" + repositoryID + ".log");
        }
    }

    public static void unsetThreadLogFile() {
        ThreadLog.deregisterThread();
    }

    public static String getVersion() {
        if (_version == null) {
            InputStream in = SesameServer.class.getClassLoader().getResourceAsStream("VERSION");
            if (in == null) {
                _version = "[VERSION FILE MISSING]";
            } else {
                try {
                    _version = new String(IOUtil.readFully(in)).trim();
                    in.close();
                }
                catch (IOException e) {
                    ThreadLog.error("Unable to read version from file", e);
                }
            }
        }
        return _version;
    }

    public static void clear() {
        _localService.shutDown();
        SesameServer._unbindRMIServer(_sysConfig.getRMIFactoryClass(), _sysConfig.getRMIPort());
    }

    public static void addListener(SystemConfigCenterListener listener) {
        _listeners.add(listener);
    }

    public static void removeListener(SystemConfigCenterListener listener) {
        _listeners.remove(listener);
    }

    protected static void _notifyListeners() {
        Iterator i = _listeners.iterator();
        while (i.hasNext()) {
            ((SystemConfigCenterListener)i.next()).configurationRefreshed();
        }
    }

    protected static void _bindRMIServer(String rmiFactoryClass, int port) {
        if (rmiFactoryClass == null) {
            return;
        }
        Class<?> rmi_factory = null;
        Method rmi_factory_bind = null;
        try {
            rmi_factory = Class.forName(rmiFactoryClass);
            rmi_factory_bind = rmi_factory.getDeclaredMethod("bind", Integer.class);
            rmi_factory_bind.invoke(null, new Integer(port));
        }
        catch (ClassNotFoundException e) {
            ThreadLog.error("RMI factory class '" + rmiFactoryClass + "' not found");
        }
        catch (NoSuchMethodException e) {
            ThreadLog.error("Method 'static void bind(Integer)' not found in RMI factory class '" + rmiFactoryClass + "'");
        }
        catch (IllegalAccessException e) {
            ThreadLog.error("Unable to bind RMI server: " + e.getMessage());
        }
        catch (InvocationTargetException e) {
            ThreadLog.error("Unable to bind RMI server: " + e.getMessage());
        }
    }

    protected static void _unbindRMIServer(String rmiFactoryClass, int port) {
        if (rmiFactoryClass == null) {
            return;
        }
        Class<?> rmi_factory = null;
        Method rmi_factory_unbind = null;
        try {
            rmi_factory = Class.forName(rmiFactoryClass);
            rmi_factory_unbind = rmi_factory.getDeclaredMethod("unbind", Integer.class);
            rmi_factory_unbind.invoke(null, new Integer(port));
        }
        catch (ClassNotFoundException e) {
            ThreadLog.error("RMI factory class '" + rmiFactoryClass + "' not found");
        }
        catch (NoSuchMethodException e) {
            ThreadLog.error("Method 'static void unbind(Integer)' not found in RMI factory class '" + rmiFactoryClass + "'");
        }
        catch (IllegalAccessException e) {
            ThreadLog.error("Unable to unbind RMI server: " + e.getMessage());
        }
        catch (InvocationTargetException e) {
            ThreadLog.error("Unable to unbind RMI server: " + e.getMessage());
        }
        Thread gcThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                1 var1_1 = this;
                synchronized (var1_1) {
                    try {
                        this.wait(500L);
                        System.gc();
                        this.wait(500L);
                        System.gc();
                        this.wait(500L);
                        System.gc();
                    }
                    catch (InterruptedException e) {
                        this.notifyAll();
                    }
                }
            }
        });
        gcThread.start();
    }

    static {
        _sysConfig = new SystemConfig();
        _baseDir = null;
        _version = null;
        _listeners = new ArrayList();
    }
}

