/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.server.http;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openrdf.sesame.admin.AdminListener;
import org.openrdf.sesame.admin.HtmlAdminMsgWriter;
import org.openrdf.sesame.admin.XmlAdminMsgWriter;
import org.openrdf.sesame.config.AccessDeniedException;
import org.openrdf.sesame.config.ConfigurationException;
import org.openrdf.sesame.config.UnknownRepositoryException;
import org.openrdf.sesame.constants.AdminResultFormat;
import org.openrdf.sesame.constants.RDFFormat;
import org.openrdf.sesame.repository.SesameRepository;
import org.openrdf.sesame.repository.local.LocalService;
import org.openrdf.sesame.repository.remote.HTTPErrorType;
import org.openrdf.sesame.server.SesameServer;
import org.openrdf.sesame.server.http.HTTPOutputStream;
import org.openrdf.sesame.server.http.SesameServlet;
import org.openrdf.util.http.HttpServerUtil;
import org.openrdf.util.log.ThreadLog;

public class DataUploadServlet
extends SesameServlet {
    protected void _doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (HttpServerUtil.isMultipartFormRequest(request)) {
            this._handleMultipartFormRequest(request, response);
        } else {
            this._handleFormURLEncodedRequest(request, response);
        }
    }

    private void _handleFormURLEncodedRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String repository = HttpServerUtil.getParameter(request, "repository");
        String data = HttpServerUtil.getParameter(request, "data");
        String baseURI = HttpServerUtil.getParameter(request, "baseURI");
        String dataFormatStr = HttpServerUtil.getParameter(request, "dataFormat", RDFFormat.RDFXML.toString());
        String resultFormatStr = HttpServerUtil.getParameter(request, "resultFormat", AdminResultFormat.XML.toString());
        String verify = HttpServerUtil.getParameter(request, "verifyData", "off");
        ByteArrayInputStream rdfStream = new ByteArrayInputStream(data.getBytes());
        this._handleRequest(request, response, repository, rdfStream, baseURI, dataFormatStr, resultFormatStr, verify);
    }

    private void _handleMultipartFormRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Map fileItemMap = HttpServerUtil.parseMultipartFormRequest(request);
        String repository = HttpServerUtil.getParameter(fileItemMap, "repository");
        InputStream rdfStream = HttpServerUtil.getStreamParameter(fileItemMap, "data");
        String baseURI = HttpServerUtil.getParameter(fileItemMap, "baseURI");
        String dataFormatStr = HttpServerUtil.getParameter(fileItemMap, "dataFormat", RDFFormat.RDFXML.toString());
        String resultFormatStr = HttpServerUtil.getParameter(fileItemMap, "resultFormat", AdminResultFormat.XML.toString());
        String verify = HttpServerUtil.getParameter(fileItemMap, "verifyData", "off");
        this._handleRequest(request, response, repository, rdfStream, baseURI, dataFormatStr, resultFormatStr, verify);
    }

    private void _handleRequest(HttpServletRequest request, HttpServletResponse response, String repository, InputStream rdfStream, String baseURI, String dataFormatStr, String resultFormatStr, String verify) throws IOException {
        SesameServer.setThreadLogFileForRepository(repository);
        this._logIP(request);
        ThreadLog.log(">>> upload data");
        ThreadLog.trace("repository = " + repository);
        ThreadLog.trace("baseURI = " + baseURI);
        ThreadLog.trace("dataFormat = " + dataFormatStr);
        ThreadLog.trace("resultFormat = " + resultFormatStr);
        ThreadLog.trace("verifyData = " + verify);
        if (rdfStream == null) {
            this._sendBadRequest("RDF data is missing", response);
            return;
        }
        if (baseURI == null) {
            baseURI = "foo:bar";
        }
        if (repository == null) {
            this._sendBadRequest("No repository specified", response);
            return;
        }
        RDFFormat dataFormat = RDFFormat.forValue(dataFormatStr);
        if (dataFormat != RDFFormat.RDFXML && dataFormat != RDFFormat.NTRIPLES && dataFormat != RDFFormat.TURTLE) {
            this._sendBadRequest("Unsupported data format: " + dataFormatStr, response);
            return;
        }
        HTTPOutputStream httpOut = new HTTPOutputStream(response);
        httpOut.setCacheableResult(false);
        AdminListener report = null;
        AdminResultFormat resultFormat = AdminResultFormat.forValue(resultFormatStr);
        if (resultFormat == AdminResultFormat.XML) {
            httpOut.setContentType("text/xml");
            report = new XmlAdminMsgWriter(httpOut);
        } else if (resultFormat == AdminResultFormat.HTML) {
            httpOut.setContentType("text/html");
            report = new HtmlAdminMsgWriter(httpOut);
        } else {
            this._sendBadRequest("Unknown result format: " + resultFormatStr, response);
            return;
        }
        boolean verifyData = verify.equals("on");
        try {
            LocalService service = SesameServer.getLocalService();
            this._login(service);
            SesameRepository rep = service.getRepository(repository);
            long startTime = System.currentTimeMillis();
            rep.addData(rdfStream, baseURI, dataFormat, verifyData, report);
            rdfStream.close();
            long endTime = System.currentTimeMillis();
            ThreadLog.trace("data added in " + (endTime - startTime) + "ms");
        }
        catch (AccessDeniedException e) {
            this._sendForbidden("Access denied", response);
        }
        catch (ConfigurationException e) {
            this._sendInternalError("Configuration error", e, response);
        }
        catch (UnknownRepositoryException e) {
            this._sendBadRequest(HTTPErrorType.UNKNOWN_REPOSITORY, "Unknown repository: " + repository, response);
        }
        catch (RuntimeException e) {
            ThreadLog.error("Unknown error on adding RDF data to repository " + repository, e);
        }
    }
}

