/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.server.http;

import java.io.IOException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openrdf.sesame.config.AccessDeniedException;
import org.openrdf.sesame.config.UnknownRepositoryException;
import org.openrdf.sesame.constants.QueryLanguage;
import org.openrdf.sesame.constants.RDFFormat;
import org.openrdf.sesame.query.MalformedQueryException;
import org.openrdf.sesame.query.QueryEvaluationException;
import org.openrdf.sesame.query.RdfGraphWriter;
import org.openrdf.sesame.repository.SesameRepository;
import org.openrdf.sesame.repository.local.LocalService;
import org.openrdf.sesame.repository.remote.HTTPErrorType;
import org.openrdf.sesame.server.SesameServer;
import org.openrdf.sesame.server.http.HTTPOutputStream;
import org.openrdf.sesame.server.http.SesameServlet;
import org.openrdf.util.http.HttpServerUtil;
import org.openrdf.util.log.ThreadLog;

public class GraphQueryServlet
extends SesameServlet {
    protected void _doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        this._handleFormURLEncodedRequest(request, response);
    }

    protected void _doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (HttpServerUtil.isMultipartFormRequest(request)) {
            this._handleMultipartFormRequest(request, response);
        } else {
            this._handleFormURLEncodedRequest(request, response);
        }
    }

    private void _handleFormURLEncodedRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String repository = HttpServerUtil.getParameter(request, "repository");
        String query = HttpServerUtil.getParameter(request, "query");
        String queryLanguageStr = HttpServerUtil.getParameter(request, "queryLanguage");
        String serialization = HttpServerUtil.getParameter(request, "serialization", RDFFormat.RDFXML.toString());
        this._handleRequest(request, response, repository, query, queryLanguageStr, serialization);
    }

    private void _handleMultipartFormRequest(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Map fileItemMap = HttpServerUtil.parseMultipartFormRequest(request);
        String repository = HttpServerUtil.getParameter(fileItemMap, "repository");
        String query = HttpServerUtil.getParameter(fileItemMap, "query");
        String queryLanguageStr = HttpServerUtil.getParameter(fileItemMap, "queryLanguage");
        String serialization = HttpServerUtil.getParameter(fileItemMap, "serialization", RDFFormat.RDFXML.toString());
        this._handleRequest(request, response, repository, query, queryLanguageStr, serialization);
    }

    protected void _handleRequest(HttpServletRequest request, HttpServletResponse response, String repository, String query, String queryLanguageStr, String serialization) throws IOException {
        SesameServer.setThreadLogFileForRepository(repository);
        this._logIP(request);
        ThreadLog.log(">>> evaluate graph query");
        ThreadLog.trace("repository = " + repository);
        ThreadLog.trace("query = " + query);
        ThreadLog.trace("queryLanguage = " + queryLanguageStr);
        ThreadLog.trace("serialization = " + serialization);
        if (query == null) {
            this._sendBadRequest("Query is missing", response);
            return;
        }
        if (repository == null) {
            this._sendBadRequest("No repository specified", response);
            return;
        }
        if (queryLanguageStr == null) {
            this._sendBadRequest("No query language specified", response);
            return;
        }
        QueryLanguage queryLanguage = QueryLanguage.forValue(queryLanguageStr);
        if (queryLanguage == null) {
            this._sendBadRequest("Unsupported query language: " + queryLanguageStr, response);
            return;
        }
        HTTPOutputStream httpOut = new HTTPOutputStream(response);
        httpOut.setUseGZIPCompression(HttpServerUtil.acceptsGZIPEncoding(request));
        httpOut.setCacheableResult(false);
        RDFFormat rdfFormat = RDFFormat.forValue(serialization);
        if (rdfFormat == RDFFormat.RDFXML) {
            httpOut.setContentType("application/rdf+xml");
        } else if (rdfFormat == RDFFormat.NTRIPLES) {
            httpOut.setContentType("text/plain");
        } else if (rdfFormat == RDFFormat.N3) {
            httpOut.setContentType("text/rdf+n3");
        } else if (rdfFormat == RDFFormat.TURTLE) {
            httpOut.setContentType("application/x-turtle");
        } else {
            this._sendBadRequest("Unknown serialization format: " + serialization, response);
            return;
        }
        RdfGraphWriter graphListener = new RdfGraphWriter(rdfFormat, httpOut);
        try {
            LocalService service = SesameServer.getLocalService();
            this._login(service);
            SesameRepository rep = service.getRepository(repository);
            rep.performGraphQuery(queryLanguage, query, graphListener);
        }
        catch (UnknownRepositoryException e) {
            this._sendBadRequest(HTTPErrorType.UNKNOWN_REPOSITORY, "Unknown repository: " + repository, response);
        }
        catch (AccessDeniedException e) {
            this._sendForbidden("Access denied: " + e.getMessage(), response);
        }
        catch (MalformedQueryException e) {
            this._sendBadRequest(HTTPErrorType.MALFORMED_QUERY, e.getMessage(), response);
        }
        catch (QueryEvaluationException e) {
            ThreadLog.warning("Query evaluation error: " + e.getMessage());
            if (!httpOut.streamOpened()) {
                this._sendBadRequest(HTTPErrorType.QUERY_EVALUATION_ERROR, e.getMessage(), response);
            } else {
                graphListener.reportError("Query evaluation error: " + e.getMessage());
                graphListener.endGraphQueryResult();
            }
        }
        catch (IOException ie) {
            ThreadLog.warning("I/O error, client connection closed?\n" + ie.getMessage());
        }
        catch (Exception e) {
            ThreadLog.error("Unknown error on query: " + query, e);
            graphListener.reportError("The server generated an unknown error. Please inform the server administrator.");
            graphListener.endGraphQueryResult();
        }
    }
}

