/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.server.rmi;

import java.io.File;
import java.net.URI;
import java.rmi.Naming;
import org.openrdf.sesame.Sesame;
import org.openrdf.sesame.constants.QueryLanguage;
import org.openrdf.sesame.repository.SesameRepository;
import org.openrdf.sesame.repository.SesameService;
import org.openrdf.sesame.server.rmi.FactoryInterface;
import org.openrdf.sesame.server.rmi.LocalQueryListener;
import org.openrdf.sesame.server.rmi.RegisteringThread;
import org.openrdf.util.log.ThreadLog;
import org.openrdf.util.rmirouting.ChannelIfaceInvocation;

public class RMICenter {
    static final String SYSTEM_CONF_PROP = "system.config";
    static final String RMI_PORT_PROP = "rmi.port";
    static final String RMI_FACTORY_PROP = "rmi.factory.class";
    static final String REPOSITORY_PROP = "init.repository";
    static final String REPOSITORY_USER = "init.user";
    static final String REPOSITORY_PASS = "init.pass";
    static String sSystemConfFile;
    static String sRepository;
    static String sRMIPort;
    static String sRMIHost;
    static String sSesameUser;
    static String sSesamePass;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("usage: RMICenter [start <system.conf> [#port] | stop [#port] | test [#port] ]");
            return;
        }
        if (0 == args[0].compareToIgnoreCase("start")) {
            Object signal = new Object();
            switch (args.length) {
                case 2: {
                    sRMIPort = String.valueOf(1099);
                    sSystemConfFile = args[1];
                    break;
                }
                case 3: {
                    try {
                        sRMIPort = String.valueOf(Integer.parseInt(args[1]));
                        sSystemConfFile = args[2];
                        break;
                    }
                    catch (NumberFormatException e) {
                        try {
                            sRMIPort = String.valueOf(Integer.parseInt(args[2]));
                            sSystemConfFile = args[1];
                            break;
                        }
                        catch (NumberFormatException e2) {
                            throw new RuntimeException("At least one of the first two arguments should be a valid port number!");
                        }
                    }
                }
            }
            Object e = signal;
            synchronized (e) {
                String conf = sSystemConfFile;
                File ftest = new File(conf);
                if (!ftest.exists()) {
                    throw new RuntimeException("Cannot read from file " + conf + "! It should exist!");
                }
                new RegisteringThread(conf, signal).start();
                try {
                    signal.wait();
                }
                catch (InterruptedException e2) {
                    // empty catch block
                }
            }
            return;
        }
        if (0 == args[0].compareToIgnoreCase("stop")) {
            ThreadLog.registerThread(null, 5);
            try {
                String port = String.valueOf(1099);
                if (args.length > 1) {
                    int p2 = 0;
                    try {
                        p2 = Integer.parseInt(args[1]);
                    }
                    catch (NumberFormatException e) {
                        throw new RuntimeException("The second parameter is not a valid port number !");
                    }
                    if (p2 > 10) {
                        port = String.valueOf(p2);
                    }
                }
                sRMIPort = port;
                FactoryInterface fi = null;
                try {
                    fi = (FactoryInterface)ChannelIfaceInvocation.wrapIt(Naming.lookup("//localhost:" + sRMIPort + "/FactoryInterface"));
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    return;
                }
                if (fi != null) {
                    fi.stopService();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return;
        }
        if (0 == args[0].compareToIgnoreCase("test")) {
            ThreadLog.registerThread(null, 5);
            try {
                String port = String.valueOf(1099);
                if (args.length > 1) {
                    int p2 = 0;
                    try {
                        p2 = Integer.parseInt(args[1]);
                    }
                    catch (NumberFormatException e) {
                        throw new RuntimeException("The second parameter is not a valid port number !");
                    }
                    if (p2 > 10) {
                        port = String.valueOf(p2);
                    }
                }
                sRMIPort = port;
                Object fi = null;
                SesameService si = null;
                SesameRepository rep = null;
                si = Sesame.getService(new URI("rmi://localhost:" + sRMIPort));
                si.login("admin", "admin");
                rep = si.getRepository("kim");
                String query = "select\tLA, I, DC from {TI} <rdf:type> {<kimo:Trusted>}, {I} <kimo:generatedBy> {TI}, {I} <rdf:type> {<kimo:Entity>}, {I} <serql:directType> {DC}, {I} <kimo:hasAlias> {} <rdfs:label> {LA} using namespace rdf = <!http://www.w3.org/1999/02/22-rdf-syntax-ns#> , rdfs = <!http://www.w3.org/2000/01/rdf-schema#> , kimo = <!http://www.ontotext.com/kim/kimo.rdfs#> ";
                LocalQueryListener wrl = new LocalQueryListener(-1);
                long start = System.currentTimeMillis();
                ThreadLog.log("--- Query started");
                rep.performTableQuery(QueryLanguage.SERQL, query, wrl);
                ThreadLog.log("--- Query (" + wrl.counter + ")ended for " + (System.currentTimeMillis() - start));
                wrl = null;
                System.gc();
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
        throw new RuntimeException("unknown command\n usage: RMITest [start <system.conf> | stop | test]");
    }
}

