/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.util.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import org.openrdf.util.http.FilePart;
import org.openrdf.util.io.IOUtil;

public class HttpClientUtil {
    private static final String CRLF = "\r\n";

    public static void preparePostRequest(HttpURLConnection connection, Map parameters) throws IOException {
        String postData = HttpClientUtil.buildQueryString(parameters);
        connection.setRequestMethod("POST");
        connection.setDoInput(true);
        connection.setDoOutput(true);
        connection.setUseCaches(false);
        OutputStream postStream = connection.getOutputStream();
        OutputStreamWriter postWriter = new OutputStreamWriter(postStream);
        postWriter.write(postData);
        ((Writer)postWriter).flush();
        ((Writer)postWriter).close();
    }

    public static void prepareMultipartPostRequest(HttpURLConnection connection, Map parameters, String encoding) throws UnsupportedEncodingException, IOException {
        String boundary = "---8qP3mZ1yyysss---";
        byte[] postData = HttpClientUtil.buildMultipartFormData(parameters, boundary, encoding);
        connection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
        connection.setRequestProperty("Content-Length", String.valueOf(postData.length));
        connection.setRequestMethod("POST");
        connection.setDoInput(true);
        connection.setDoOutput(true);
        connection.setUseCaches(false);
        OutputStream postStream = connection.getOutputStream();
        postStream.write(postData);
        postStream.flush();
        postStream.close();
    }

    public static void prepareMultipartPostRequestInputStreamAware(HttpURLConnection connection, Map parameters, String encoding) throws UnsupportedEncodingException, IOException {
        HashMap inputStreamParameters = new HashMap();
        HashMap nonInputStreamParameters = new HashMap();
        Iterator iter = parameters.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (value instanceof InputStream) {
                inputStreamParameters.put(key, value);
                continue;
            }
            nonInputStreamParameters.put(key, value);
        }
        String boundary = "---8qP3mZ1yyysss---";
        byte[] postParams = HttpClientUtil.buildMultipartFormData(nonInputStreamParameters, boundary, encoding, false);
        connection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
        connection.setRequestMethod("POST");
        connection.setDoInput(true);
        connection.setDoOutput(true);
        connection.setUseCaches(false);
        HttpClientUtil.tryChunkedStreamingMode(connection);
        OutputStream postStream = connection.getOutputStream();
        postStream.write(postParams);
        postStream.flush();
        byte[] startBoundary = ("\r\n--" + boundary + CRLF).getBytes();
        byte[] endBoundary = ("\r\n--" + boundary + "--" + CRLF).getBytes();
        Iterator isIter = inputStreamParameters.entrySet().iterator();
        while (isIter.hasNext()) {
            Map.Entry entry = isIter.next();
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            InputStream in = (InputStream)value;
            byte[] partHeader = ("Content-Disposition: form-data; name=\"" + key + "\"" + CRLF + CRLF).getBytes();
            postStream.write(startBoundary);
            postStream.write(partHeader);
            IOUtil.transfer(in, postStream);
            postStream.flush();
        }
        postStream.write(endBoundary);
        postStream.flush();
        postStream.close();
    }

    private static boolean tryChunkedStreamingMode(HttpURLConnection connection) {
        try {
            Method m3 = connection.getClass().getMethod("setChunkedStreamingMode", Integer.TYPE);
            m3.invoke((Object)connection, new Integer(8192));
            return true;
        }
        catch (NoSuchMethodException e) {
        }
        catch (SecurityException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return false;
    }

    public static byte[] buildMultipartFormData(Map parameters, String boundary, String encoding) throws UnsupportedEncodingException {
        return HttpClientUtil.buildMultipartFormData(parameters, boundary, encoding, true);
    }

    public static byte[] buildMultipartFormData(Map parameters, String boundary, String encoding, boolean includeEndBoundary) throws UnsupportedEncodingException {
        ArrayList<byte[]> parts = new ArrayList<byte[]>(parameters.size());
        int partLengthSum = 0;
        Iterator iter = parameters.entrySet().iterator();
        while (iter.hasNext()) {
            byte[] partContents;
            byte[] partHeader;
            Map.Entry entry = iter.next();
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (value instanceof FilePart) {
                FilePart fp = (FilePart)value;
                partHeader = ("Content-Disposition: form-data; name=\"" + key + "\"; filename=\"" + fp.getName() + "\"" + CRLF + "Content-Type: " + fp.getContentType() + CRLF + CRLF).getBytes();
                partContents = fp.getBytes();
            } else {
                partHeader = ("Content-Disposition: form-data; name=\"" + key + "\"" + CRLF + CRLF).getBytes();
                partContents = value instanceof byte[] ? (byte[])value : value.toString().getBytes(encoding);
            }
            byte[] part = new byte[partHeader.length + partContents.length];
            System.arraycopy(partHeader, 0, part, 0, partHeader.length);
            System.arraycopy(partContents, 0, part, partHeader.length, partContents.length);
            parts.add(part);
            partLengthSum += part.length;
        }
        byte[] startBoundary = ("\r\n--" + boundary + CRLF).getBytes();
        byte[] endBoundary = ("\r\n--" + boundary + "--" + CRLF).getBytes();
        int totalLength = parts.size() * startBoundary.length + (includeEndBoundary ? endBoundary.length : 0) + partLengthSum;
        byte[] result = new byte[totalLength];
        int idx = 0;
        for (int i = 0; i < parts.size(); ++i) {
            byte[] part = (byte[])parts.get(i);
            System.arraycopy(startBoundary, 0, result, idx, startBoundary.length);
            System.arraycopy(part, 0, result, idx += startBoundary.length, part.length);
            idx += part.length;
        }
        if (includeEndBoundary) {
            System.arraycopy(endBoundary, 0, result, idx, endBoundary.length);
        }
        return result;
    }

    public static String buildQueryString(Map keyValuePairs) {
        StringBuffer result = new StringBuffer(20 * keyValuePairs.size());
        Set entrySet = keyValuePairs.entrySet();
        Iterator iter = entrySet.iterator();
        while (iter.hasNext()) {
            Map.Entry keyValuePair = iter.next();
            String key = (String)keyValuePair.getKey();
            String value = (String)keyValuePair.getValue();
            HttpClientUtil._formUrlEncode(key, result);
            result.append('=');
            HttpClientUtil._formUrlEncode(value, result);
            if (!iter.hasNext()) continue;
            result.append('&');
        }
        return result.toString();
    }

    private static void _formUrlEncode(String s2, StringBuffer buf) {
        for (int i = 0; i < s2.length(); ++i) {
            char c = s2.charAt(i);
            char cInt = c;
            if (cInt >= '0' && cInt <= '9' || cInt >= 'A' && cInt <= 'Z' || cInt >= 'a' && cInt <= 'z') {
                buf.append(c);
                continue;
            }
            buf.append('%');
            String hexVal = Integer.toHexString(cInt);
            if (hexVal.length() == 1) {
                buf.append('0');
            }
            buf.append(hexVal);
        }
    }

    public static void setAcceptGZIPEncoding(URLConnection conn) {
        conn.setRequestProperty("Accept-Encoding", "gzip");
    }

    public static InputStream getInputStream(URLConnection conn) throws IOException {
        InputStream responseStream = conn.getInputStream();
        String contentEncoding = conn.getContentEncoding();
        if ("gzip".equalsIgnoreCase(contentEncoding)) {
            responseStream = new GZIPInputStream(responseStream);
        }
        return responseStream;
    }
}

