/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.util.xml;

import java.util.StringTokenizer;
import org.openrdf.util.StringUtil;
import org.openrdf.util.xml.datatypes.DateTime;

public class XmlDatatypeUtil {
    public static boolean isPrimitiveDatatype(String datatype) {
        return datatype.equals("http://www.w3.org/2001/XMLSchema#duration") || datatype.equals("http://www.w3.org/2001/XMLSchema#dateTime") || datatype.equals("http://www.w3.org/2001/XMLSchema#time") || datatype.equals("http://www.w3.org/2001/XMLSchema#date") || datatype.equals("http://www.w3.org/2001/XMLSchema#gYearMonth") || datatype.equals("http://www.w3.org/2001/XMLSchema#gYear") || datatype.equals("http://www.w3.org/2001/XMLSchema#gMonthDay") || datatype.equals("http://www.w3.org/2001/XMLSchema#gDay") || datatype.equals("http://www.w3.org/2001/XMLSchema#gMonth") || datatype.equals("http://www.w3.org/2001/XMLSchema#string") || datatype.equals("http://www.w3.org/2001/XMLSchema#boolean") || datatype.equals("http://www.w3.org/2001/XMLSchema#base64Binary") || datatype.equals("http://www.w3.org/2001/XMLSchema#hexBinary") || datatype.equals("http://www.w3.org/2001/XMLSchema#float") || datatype.equals("http://www.w3.org/2001/XMLSchema#decimal") || datatype.equals("http://www.w3.org/2001/XMLSchema#double") || datatype.equals("http://www.w3.org/2001/XMLSchema#anyURI") || datatype.equals("http://www.w3.org/2001/XMLSchema#QName") || datatype.equals("http://www.w3.org/2001/XMLSchema#NOTATION");
    }

    public static boolean isDerivedDatatype(String datatype) {
        return datatype.equals("http://www.w3.org/2001/XMLSchema#normalizedString") || datatype.equals("http://www.w3.org/2001/XMLSchema#token") || datatype.equals("http://www.w3.org/2001/XMLSchema#language") || datatype.equals("http://www.w3.org/2001/XMLSchema#NMTOKEN") || datatype.equals("http://www.w3.org/2001/XMLSchema#NMTOKENS") || datatype.equals("http://www.w3.org/2001/XMLSchema#Name") || datatype.equals("http://www.w3.org/2001/XMLSchema#NCName") || datatype.equals("http://www.w3.org/2001/XMLSchema#ID") || datatype.equals("http://www.w3.org/2001/XMLSchema#IDREF") || datatype.equals("http://www.w3.org/2001/XMLSchema#IDREFS") || datatype.equals("http://www.w3.org/2001/XMLSchema#ENTITY") || datatype.equals("http://www.w3.org/2001/XMLSchema#ENTITIES") || datatype.equals("http://www.w3.org/2001/XMLSchema#integer") || datatype.equals("http://www.w3.org/2001/XMLSchema#long") || datatype.equals("http://www.w3.org/2001/XMLSchema#int") || datatype.equals("http://www.w3.org/2001/XMLSchema#short") || datatype.equals("http://www.w3.org/2001/XMLSchema#byte") || datatype.equals("http://www.w3.org/2001/XMLSchema#nonPositiveInteger") || datatype.equals("http://www.w3.org/2001/XMLSchema#negativeInteger") || datatype.equals("http://www.w3.org/2001/XMLSchema#nonNegativeInteger") || datatype.equals("http://www.w3.org/2001/XMLSchema#positiveInteger") || datatype.equals("http://www.w3.org/2001/XMLSchema#unsignedLong") || datatype.equals("http://www.w3.org/2001/XMLSchema#unsignedInt") || datatype.equals("http://www.w3.org/2001/XMLSchema#unsignedShort") || datatype.equals("http://www.w3.org/2001/XMLSchema#unsignedByte");
    }

    public static boolean isBuiltInDatatype(String datatype) {
        return XmlDatatypeUtil.isPrimitiveDatatype(datatype) || XmlDatatypeUtil.isDerivedDatatype(datatype);
    }

    public static boolean isDecimalDatatype(String datatype) {
        return datatype.equals("http://www.w3.org/2001/XMLSchema#decimal") || XmlDatatypeUtil.isIntegerDatatype(datatype);
    }

    public static boolean isIntegerDatatype(String datatype) {
        return datatype.equals("http://www.w3.org/2001/XMLSchema#integer") || datatype.equals("http://www.w3.org/2001/XMLSchema#long") || datatype.equals("http://www.w3.org/2001/XMLSchema#int") || datatype.equals("http://www.w3.org/2001/XMLSchema#short") || datatype.equals("http://www.w3.org/2001/XMLSchema#byte") || datatype.equals("http://www.w3.org/2001/XMLSchema#nonPositiveInteger") || datatype.equals("http://www.w3.org/2001/XMLSchema#negativeInteger") || datatype.equals("http://www.w3.org/2001/XMLSchema#nonNegativeInteger") || datatype.equals("http://www.w3.org/2001/XMLSchema#positiveInteger") || datatype.equals("http://www.w3.org/2001/XMLSchema#unsignedLong") || datatype.equals("http://www.w3.org/2001/XMLSchema#unsignedInt") || datatype.equals("http://www.w3.org/2001/XMLSchema#unsignedShort") || datatype.equals("http://www.w3.org/2001/XMLSchema#unsignedByte");
    }

    public static boolean isFloatingPointDatatype(String datatype) {
        return datatype.equals("http://www.w3.org/2001/XMLSchema#float") || datatype.equals("http://www.w3.org/2001/XMLSchema#double");
    }

    public static boolean isDateTimeDatatype(String datatype) {
        return datatype.equals("http://www.w3.org/2001/XMLSchema#dateTime");
    }

    public static boolean isOrderedDatatype(String datatype) {
        return XmlDatatypeUtil.isDecimalDatatype(datatype) || XmlDatatypeUtil.isFloatingPointDatatype(datatype) || XmlDatatypeUtil.isDateTimeDatatype(datatype);
    }

    public static boolean isValidValue(String value, String datatype) {
        boolean result = true;
        if (datatype.equals("http://www.w3.org/2001/XMLSchema#decimal")) {
            result = XmlDatatypeUtil.isValidDecimal(value);
        } else if (datatype.equals("http://www.w3.org/2001/XMLSchema#integer")) {
            result = XmlDatatypeUtil.isValidInteger(value);
        } else if (datatype.equals("http://www.w3.org/2001/XMLSchema#negativeInteger")) {
            result = XmlDatatypeUtil.isValidNegativeInteger(value);
        } else if (datatype.equals("http://www.w3.org/2001/XMLSchema#nonPositiveInteger")) {
            result = XmlDatatypeUtil.isValidNonPositiveInteger(value);
        } else if (datatype.equals("http://www.w3.org/2001/XMLSchema#nonNegativeInteger")) {
            result = XmlDatatypeUtil.isValidNonNegativeInteger(value);
        } else if (datatype.equals("http://www.w3.org/2001/XMLSchema#positiveInteger")) {
            result = XmlDatatypeUtil.isValidPositiveInteger(value);
        } else if (datatype.equals("http://www.w3.org/2001/XMLSchema#long")) {
            result = XmlDatatypeUtil.isValidLong(value);
        } else if (datatype.equals("http://www.w3.org/2001/XMLSchema#int")) {
            result = XmlDatatypeUtil.isValidInt(value);
        } else if (datatype.equals("http://www.w3.org/2001/XMLSchema#short")) {
            result = XmlDatatypeUtil.isValidShort(value);
        } else if (datatype.equals("http://www.w3.org/2001/XMLSchema#byte")) {
            result = XmlDatatypeUtil.isValidByte(value);
        } else if (datatype.equals("http://www.w3.org/2001/XMLSchema#unsignedLong")) {
            result = XmlDatatypeUtil.isValidUnsignedLong(value);
        } else if (datatype.equals("http://www.w3.org/2001/XMLSchema#unsignedInt")) {
            result = XmlDatatypeUtil.isValidUnsignedInt(value);
        } else if (datatype.equals("http://www.w3.org/2001/XMLSchema#unsignedShort")) {
            result = XmlDatatypeUtil.isValidUnsignedShort(value);
        } else if (datatype.equals("http://www.w3.org/2001/XMLSchema#unsignedByte")) {
            result = XmlDatatypeUtil.isValidUnsignedByte(value);
        } else if (datatype.equals("http://www.w3.org/2001/XMLSchema#float")) {
            result = XmlDatatypeUtil.isValidFloat(value);
        } else if (datatype.equals("http://www.w3.org/2001/XMLSchema#double")) {
            result = XmlDatatypeUtil.isValidDouble(value);
        } else if (datatype.equals("http://www.w3.org/2001/XMLSchema#boolean")) {
            result = XmlDatatypeUtil.isValidBoolean(value);
        } else if (datatype.equals("http://www.w3.org/2001/XMLSchema#dateTime")) {
            result = XmlDatatypeUtil.isValidDateTime(value);
        }
        return result;
    }

    public static boolean isValidDecimal(String value) {
        try {
            XmlDatatypeUtil.normalizeDecimal(value);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean isValidInteger(String value) {
        try {
            XmlDatatypeUtil.normalizeInteger(value);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean isValidNegativeInteger(String value) {
        try {
            XmlDatatypeUtil.normalizeNegativeInteger(value);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean isValidNonPositiveInteger(String value) {
        try {
            XmlDatatypeUtil.normalizeNonPositiveInteger(value);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean isValidNonNegativeInteger(String value) {
        try {
            XmlDatatypeUtil.normalizeNonNegativeInteger(value);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean isValidPositiveInteger(String value) {
        try {
            XmlDatatypeUtil.normalizePositiveInteger(value);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean isValidLong(String value) {
        try {
            XmlDatatypeUtil.normalizeLong(value);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean isValidInt(String value) {
        try {
            XmlDatatypeUtil.normalizeInt(value);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean isValidShort(String value) {
        try {
            XmlDatatypeUtil.normalizeShort(value);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean isValidByte(String value) {
        try {
            XmlDatatypeUtil.normalizeByte(value);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean isValidUnsignedLong(String value) {
        try {
            XmlDatatypeUtil.normalizeUnsignedLong(value);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean isValidUnsignedInt(String value) {
        try {
            XmlDatatypeUtil.normalizeUnsignedInt(value);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean isValidUnsignedShort(String value) {
        try {
            XmlDatatypeUtil.normalizeUnsignedShort(value);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean isValidUnsignedByte(String value) {
        try {
            XmlDatatypeUtil.normalizeUnsignedByte(value);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean isValidFloat(String value) {
        try {
            XmlDatatypeUtil.normalizeFloat(value);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean isValidDouble(String value) {
        try {
            XmlDatatypeUtil.normalizeDouble(value);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean isValidBoolean(String value) {
        try {
            XmlDatatypeUtil.normalizeBoolean(value);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean isValidDateTime(String value) {
        try {
            DateTime dt = new DateTime(value);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static String normalize(String value, String datatype) {
        String result = value;
        if (datatype.equals("http://www.w3.org/2001/XMLSchema#decimal")) {
            result = XmlDatatypeUtil.normalizeDecimal(value);
        } else if (datatype.equals("http://www.w3.org/2001/XMLSchema#integer")) {
            result = XmlDatatypeUtil.normalizeInteger(value);
        } else if (datatype.equals("http://www.w3.org/2001/XMLSchema#negativeInteger")) {
            result = XmlDatatypeUtil.normalizeNegativeInteger(value);
        } else if (datatype.equals("http://www.w3.org/2001/XMLSchema#nonPositiveInteger")) {
            result = XmlDatatypeUtil.normalizeNonPositiveInteger(value);
        } else if (datatype.equals("http://www.w3.org/2001/XMLSchema#nonNegativeInteger")) {
            result = XmlDatatypeUtil.normalizeNonNegativeInteger(value);
        } else if (datatype.equals("http://www.w3.org/2001/XMLSchema#positiveInteger")) {
            result = XmlDatatypeUtil.normalizePositiveInteger(value);
        } else if (datatype.equals("http://www.w3.org/2001/XMLSchema#long")) {
            result = XmlDatatypeUtil.normalizeLong(value);
        } else if (datatype.equals("http://www.w3.org/2001/XMLSchema#int")) {
            result = XmlDatatypeUtil.normalizeInt(value);
        } else if (datatype.equals("http://www.w3.org/2001/XMLSchema#short")) {
            result = XmlDatatypeUtil.normalizeShort(value);
        } else if (datatype.equals("http://www.w3.org/2001/XMLSchema#byte")) {
            result = XmlDatatypeUtil.normalizeByte(value);
        } else if (datatype.equals("http://www.w3.org/2001/XMLSchema#unsignedLong")) {
            result = XmlDatatypeUtil.normalizeUnsignedLong(value);
        } else if (datatype.equals("http://www.w3.org/2001/XMLSchema#unsignedInt")) {
            result = XmlDatatypeUtil.normalizeUnsignedInt(value);
        } else if (datatype.equals("http://www.w3.org/2001/XMLSchema#unsignedShort")) {
            result = XmlDatatypeUtil.normalizeUnsignedShort(value);
        } else if (datatype.equals("http://www.w3.org/2001/XMLSchema#unsignedByte")) {
            result = XmlDatatypeUtil.normalizeUnsignedByte(value);
        } else if (datatype.equals("http://www.w3.org/2001/XMLSchema#float")) {
            result = XmlDatatypeUtil.normalizeFloat(value);
        } else if (datatype.equals("http://www.w3.org/2001/XMLSchema#double")) {
            result = XmlDatatypeUtil.normalizeDouble(value);
        } else if (datatype.equals("http://www.w3.org/2001/XMLSchema#boolean")) {
            result = XmlDatatypeUtil.normalizeBoolean(value);
        } else if (datatype.equals("http://www.w3.org/2001/XMLSchema#dateTime")) {
            result = XmlDatatypeUtil.normalizeDateTime(value);
        }
        return result;
    }

    public static String normalizeBoolean(String value) {
        if ((value = XmlDatatypeUtil.collapseWhiteSpace(value)).equals("1")) {
            return "true";
        }
        if (value.equals("0")) {
            return "false";
        }
        if (value.equals("true") || value.equals("false")) {
            return value;
        }
        XmlDatatypeUtil._throwIAE("Not a legal boolean value: " + value);
        return null;
    }

    public static String normalizeDecimal(String decimal) {
        decimal = XmlDatatypeUtil.collapseWhiteSpace(decimal);
        String errMsg = "Not a legal decimal: " + decimal;
        int decLength = decimal.length();
        StringBuffer result = new StringBuffer(decLength + 2);
        if (decLength == 0) {
            XmlDatatypeUtil._throwIAE(errMsg);
        }
        boolean isZeroPointZero = true;
        int idx = 0;
        if (decimal.charAt(idx) == '-') {
            result.append('-');
            ++idx;
        } else if (decimal.charAt(idx) == '+') {
            ++idx;
        }
        if (idx == decLength) {
            XmlDatatypeUtil._throwIAE(errMsg);
        }
        while (idx < decLength && decimal.charAt(idx) == '0') {
            ++idx;
        }
        if (idx == decLength) {
            result.append('0');
        } else if (idx < decLength && decimal.charAt(idx) == '.') {
            result.append('0');
        } else {
            char c;
            isZeroPointZero = false;
            while (idx < decLength && (c = decimal.charAt(idx)) != '.') {
                if (!XmlDatatypeUtil._isDigit(c)) {
                    XmlDatatypeUtil._throwIAE(errMsg);
                }
                result.append(c);
                ++idx;
            }
        }
        result.append('.');
        if (idx == decLength) {
            result.append('0');
        } else {
            int lastIdx;
            ++idx;
            for (lastIdx = decLength - 1; lastIdx >= 0 && decimal.charAt(lastIdx) == '0'; --lastIdx) {
            }
            if (idx > lastIdx) {
                result.append('0');
            } else {
                isZeroPointZero = false;
                while (idx <= lastIdx) {
                    char c = decimal.charAt(idx);
                    if (!XmlDatatypeUtil._isDigit(c)) {
                        XmlDatatypeUtil._throwIAE(errMsg);
                    }
                    result.append(c);
                    ++idx;
                }
            }
        }
        if (isZeroPointZero) {
            return "0.0";
        }
        return result.toString();
    }

    public static String normalizeInteger(String value) {
        return XmlDatatypeUtil._normalizeIntegerValue(value, null, null);
    }

    public static String normalizeNegativeInteger(String value) {
        return XmlDatatypeUtil._normalizeIntegerValue(value, null, "-1");
    }

    public static String normalizeNonPositiveInteger(String value) {
        return XmlDatatypeUtil._normalizeIntegerValue(value, null, "0");
    }

    public static String normalizeNonNegativeInteger(String value) {
        return XmlDatatypeUtil._normalizeIntegerValue(value, "0", null);
    }

    public static String normalizePositiveInteger(String value) {
        return XmlDatatypeUtil._normalizeIntegerValue(value, "1", null);
    }

    public static String normalizeLong(String value) {
        return XmlDatatypeUtil._normalizeIntegerValue(value, "-9223372036854775808", "9223372036854775807");
    }

    public static String normalizeInt(String value) {
        return XmlDatatypeUtil._normalizeIntegerValue(value, "-2147483648", "2147483647");
    }

    public static String normalizeShort(String value) {
        return XmlDatatypeUtil._normalizeIntegerValue(value, "-32768", "32767");
    }

    public static String normalizeByte(String value) {
        return XmlDatatypeUtil._normalizeIntegerValue(value, "-128", "127");
    }

    public static String normalizeUnsignedLong(String value) {
        return XmlDatatypeUtil._normalizeIntegerValue(value, "0", "18446744073709551615");
    }

    public static String normalizeUnsignedInt(String value) {
        return XmlDatatypeUtil._normalizeIntegerValue(value, "0", "4294967295");
    }

    public static String normalizeUnsignedShort(String value) {
        return XmlDatatypeUtil._normalizeIntegerValue(value, "0", "65535");
    }

    public static String normalizeUnsignedByte(String value) {
        return XmlDatatypeUtil._normalizeIntegerValue(value, "0", "255");
    }

    private static String _normalizeIntegerValue(String integer, String minValue, String maxValue) {
        integer = XmlDatatypeUtil.collapseWhiteSpace(integer);
        String errMsg = "Not a legal integer: " + integer;
        int intLength = integer.length();
        if (intLength == 0) {
            XmlDatatypeUtil._throwIAE(errMsg);
        }
        int idx = 0;
        boolean isNegative = false;
        if (integer.charAt(idx) == '-') {
            isNegative = true;
            ++idx;
        } else if (integer.charAt(idx) == '+') {
            ++idx;
        }
        if (idx == intLength) {
            XmlDatatypeUtil._throwIAE(errMsg);
        }
        if (integer.charAt(idx) == '0' && idx < intLength - 1) {
            ++idx;
            while (idx < intLength - 1 && integer.charAt(idx) == '0') {
                ++idx;
            }
        }
        String norm = integer.substring(idx);
        for (int i = 0; i < norm.length(); ++i) {
            if (XmlDatatypeUtil._isDigit(norm.charAt(i))) continue;
            XmlDatatypeUtil._throwIAE(errMsg);
        }
        if (isNegative && norm.charAt(0) != '0') {
            norm = "-" + norm;
        }
        if (minValue != null && XmlDatatypeUtil.compareCanonicalIntegers(norm, minValue) < 0) {
            XmlDatatypeUtil._throwIAE("Value smaller than minimum value");
        }
        if (maxValue != null && XmlDatatypeUtil.compareCanonicalIntegers(norm, maxValue) > 0) {
            XmlDatatypeUtil._throwIAE("Value larger than maximum value");
        }
        return norm;
    }

    public static String normalizeFloat(String value) {
        return XmlDatatypeUtil._normalizeFPNumber(value, "-16777215.0", "16777215.0", "-149", "104");
    }

    public static String normalizeDouble(String value) {
        return XmlDatatypeUtil._normalizeFPNumber(value, "-9007199254740991.0", "9007199254740991.0", "-1075", "970");
    }

    public static String normalizeFPNumber(String value) {
        return XmlDatatypeUtil._normalizeFPNumber(value, null, null, null, null);
    }

    private static String _normalizeFPNumber(String value, String minMantissa, String maxMantissa, String minExponent, String maxExponent) {
        int dotIdx;
        String exponent;
        String mantissa;
        if ((value = XmlDatatypeUtil.collapseWhiteSpace(value)).equals("INF") || value.equals("-INF") || value.equals("NaN")) {
            return value;
        }
        int eIdx = value.indexOf(69);
        if (eIdx == -1) {
            eIdx = value.indexOf(101);
        }
        if (eIdx == -1) {
            mantissa = XmlDatatypeUtil.normalizeDecimal(value);
            exponent = "0";
        } else {
            mantissa = XmlDatatypeUtil.normalizeDecimal(value.substring(0, eIdx));
            exponent = XmlDatatypeUtil.normalizeInteger(value.substring(eIdx + 1));
        }
        if (minMantissa != null && XmlDatatypeUtil.compareCanonicalDecimals(mantissa, minMantissa) < 0) {
            XmlDatatypeUtil._throwIAE("Mantissa smaller than minimum value (" + minMantissa + ")");
        }
        if (maxMantissa != null && XmlDatatypeUtil.compareCanonicalDecimals(mantissa, maxMantissa) > 0) {
            XmlDatatypeUtil._throwIAE("Mantissa larger than maximum value (" + maxMantissa + ")");
        }
        if (minExponent != null && XmlDatatypeUtil.compareCanonicalIntegers(exponent, minExponent) < 0) {
            XmlDatatypeUtil._throwIAE("Exponent smaller than minimum value (" + minExponent + ")");
        }
        if (maxExponent != null && XmlDatatypeUtil.compareCanonicalIntegers(exponent, maxExponent) > 0) {
            XmlDatatypeUtil._throwIAE("Exponent larger than maximum value (" + maxExponent + ")");
        }
        int shift = 0;
        int digitCount = dotIdx = mantissa.indexOf(46);
        if (mantissa.charAt(0) == '-') {
            --digitCount;
        }
        if (digitCount > 1) {
            int nonZeroIdx;
            StringBuffer buf = new StringBuffer(mantissa.length());
            int firstDigitIdx = 0;
            if (mantissa.charAt(0) == '-') {
                buf.append('-');
                firstDigitIdx = 1;
            }
            buf.append(mantissa.charAt(firstDigitIdx));
            buf.append('.');
            buf.append(mantissa.substring(firstDigitIdx + 1, dotIdx));
            buf.append(mantissa.substring(dotIdx + 1));
            mantissa = buf.toString();
            for (nonZeroIdx = mantissa.length() - 1; nonZeroIdx >= 3 && mantissa.charAt(nonZeroIdx) == '0'; --nonZeroIdx) {
            }
            if (nonZeroIdx < 3 && mantissa.charAt(0) == '-') {
                ++nonZeroIdx;
            }
            if (nonZeroIdx < mantissa.length() - 1) {
                mantissa = mantissa.substring(0, nonZeroIdx + 1);
            }
            shift = 1 - digitCount;
        } else if (mantissa.startsWith("0.") || mantissa.startsWith("-0.")) {
            int nonZeroIdx;
            for (nonZeroIdx = 2; nonZeroIdx < mantissa.length() && mantissa.charAt(nonZeroIdx) == '0'; ++nonZeroIdx) {
            }
            if (nonZeroIdx < mantissa.length()) {
                StringBuffer buf = new StringBuffer(mantissa.length());
                buf.append(mantissa.charAt(nonZeroIdx));
                buf.append('.');
                if (nonZeroIdx == mantissa.length() - 1) {
                    buf.append('0');
                } else {
                    buf.append(mantissa.substring(nonZeroIdx + 1));
                }
                mantissa = buf.toString();
                shift = nonZeroIdx - 1;
            }
        }
        if (shift != 0) {
            try {
                int exp = Integer.parseInt(exponent);
                exponent = String.valueOf(exp - shift);
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("NumberFormatException: " + e.getMessage());
            }
        }
        return mantissa + "E" + exponent;
    }

    public static String normalizeDateTime(String value) {
        DateTime dt = new DateTime(value);
        dt.normalize();
        return dt.toString();
    }

    private static String _replaceWhiteSpace(String s2) {
        s2 = StringUtil.gsub("\t", " ", s2);
        s2 = StringUtil.gsub("\r", " ", s2);
        s2 = StringUtil.gsub("\n", " ", s2);
        return s2;
    }

    public static String collapseWhiteSpace(String s2) {
        StringTokenizer st = new StringTokenizer(s2, "\t\r\n ");
        if (!st.hasMoreTokens()) {
            return "";
        }
        String firstToken = st.nextToken();
        if (!st.hasMoreTokens()) {
            return firstToken;
        }
        StringBuffer buf = new StringBuffer(s2.length());
        buf.append(firstToken);
        while (st.hasMoreTokens()) {
            buf.append(' ').append(st.nextToken());
        }
        return buf.toString();
    }

    public static int compare(String value1, String value2, String datatype) {
        if (datatype.equals("http://www.w3.org/2001/XMLSchema#decimal")) {
            return XmlDatatypeUtil.compareDecimals(value1, value2);
        }
        if (datatype.equals("http://www.w3.org/2001/XMLSchema#integer")) {
            return XmlDatatypeUtil.compareIntegers(value1, value2);
        }
        if (datatype.equals("http://www.w3.org/2001/XMLSchema#negativeInteger")) {
            return XmlDatatypeUtil.compareNegativeIntegers(value1, value2);
        }
        if (datatype.equals("http://www.w3.org/2001/XMLSchema#nonPositiveInteger")) {
            return XmlDatatypeUtil.compareNonPositiveIntegers(value1, value2);
        }
        if (datatype.equals("http://www.w3.org/2001/XMLSchema#nonNegativeInteger")) {
            return XmlDatatypeUtil.compareNonNegativeIntegers(value1, value2);
        }
        if (datatype.equals("http://www.w3.org/2001/XMLSchema#positiveInteger")) {
            return XmlDatatypeUtil.comparePositiveIntegers(value1, value2);
        }
        if (datatype.equals("http://www.w3.org/2001/XMLSchema#long")) {
            return XmlDatatypeUtil.compareLongs(value1, value2);
        }
        if (datatype.equals("http://www.w3.org/2001/XMLSchema#int")) {
            return XmlDatatypeUtil.compareInts(value1, value2);
        }
        if (datatype.equals("http://www.w3.org/2001/XMLSchema#short")) {
            return XmlDatatypeUtil.compareShorts(value1, value2);
        }
        if (datatype.equals("http://www.w3.org/2001/XMLSchema#byte")) {
            return XmlDatatypeUtil.compareBytes(value1, value2);
        }
        if (datatype.equals("http://www.w3.org/2001/XMLSchema#unsignedLong")) {
            return XmlDatatypeUtil.compareUnsignedLongs(value1, value2);
        }
        if (datatype.equals("http://www.w3.org/2001/XMLSchema#unsignedInt")) {
            return XmlDatatypeUtil.compareUnsignedInts(value1, value2);
        }
        if (datatype.equals("http://www.w3.org/2001/XMLSchema#unsignedShort")) {
            return XmlDatatypeUtil.compareUnsignedShorts(value1, value2);
        }
        if (datatype.equals("http://www.w3.org/2001/XMLSchema#unsignedByte")) {
            return XmlDatatypeUtil.compareUnsignedBytes(value1, value2);
        }
        if (datatype.equals("http://www.w3.org/2001/XMLSchema#float")) {
            return XmlDatatypeUtil.compareFloats(value1, value2);
        }
        if (datatype.equals("http://www.w3.org/2001/XMLSchema#double")) {
            return XmlDatatypeUtil.compareDoubles(value1, value2);
        }
        if (datatype.equals("http://www.w3.org/2001/XMLSchema#dateTime")) {
            return XmlDatatypeUtil.compareDateTime(value1, value2);
        }
        XmlDatatypeUtil._throwIAE("datatype is not ordered");
        return 0;
    }

    public static int compareDecimals(String dec1, String dec2) {
        dec1 = XmlDatatypeUtil.normalizeDecimal(dec1);
        dec2 = XmlDatatypeUtil.normalizeDecimal(dec2);
        return XmlDatatypeUtil.compareCanonicalDecimals(dec1, dec2);
    }

    public static int compareCanonicalDecimals(String dec1, String dec2) {
        int dotIdx2;
        if (dec1.equals(dec2)) {
            return 0;
        }
        if (dec1.charAt(0) == '-' && dec2.charAt(0) != '-') {
            return -1;
        }
        if (dec2.charAt(0) == '-' && dec1.charAt(0) != '-') {
            return 1;
        }
        int dotIdx1 = dec1.indexOf(46);
        int result = dotIdx1 - (dotIdx2 = dec2.indexOf(46));
        if (result == 0) {
            int dec2Length;
            for (int i = 0; result == 0 && i < dotIdx1; ++i) {
                result = dec1.charAt(i) - dec2.charAt(i);
            }
            int dec1Length = dec1.length();
            int lastIdx = dec1Length <= (dec2Length = dec2.length()) ? dec1Length : dec2Length;
            for (int i = dotIdx1 + 1; result == 0 && i < lastIdx; ++i) {
                result = dec1.charAt(i) - dec2.charAt(i);
            }
            if (result == 0) {
                result = dec1Length - dec2Length;
            }
        }
        if (dec1.charAt(0) == '-') {
            result = -result;
        }
        return result;
    }

    public static int compareIntegers(String int1, String int2) {
        int1 = XmlDatatypeUtil.normalizeInteger(int1);
        int2 = XmlDatatypeUtil.normalizeInteger(int2);
        return XmlDatatypeUtil.compareCanonicalIntegers(int1, int2);
    }

    public static int compareCanonicalIntegers(String int1, String int2) {
        if (int1.equals(int2)) {
            return 0;
        }
        if (int1.charAt(0) == '-' && int2.charAt(0) != '-') {
            return -1;
        }
        if (int2.charAt(0) == '-' && int1.charAt(0) != '-') {
            return 1;
        }
        int result = int1.length() - int2.length();
        if (result == 0) {
            for (int i = 0; result == 0 && i < int1.length(); ++i) {
                result = int1.charAt(i) - int2.charAt(i);
            }
        }
        if (int1.charAt(0) == '-') {
            result = -result;
        }
        return result;
    }

    public static int compareNegativeIntegers(String int1, String int2) {
        int1 = XmlDatatypeUtil.normalizeNegativeInteger(int1);
        int2 = XmlDatatypeUtil.normalizeNegativeInteger(int2);
        return XmlDatatypeUtil.compareCanonicalIntegers(int1, int2);
    }

    public static int compareNonPositiveIntegers(String int1, String int2) {
        int1 = XmlDatatypeUtil.normalizeNonPositiveInteger(int1);
        int2 = XmlDatatypeUtil.normalizeNonPositiveInteger(int2);
        return XmlDatatypeUtil.compareCanonicalIntegers(int1, int2);
    }

    public static int compareNonNegativeIntegers(String int1, String int2) {
        int1 = XmlDatatypeUtil.normalizeNonNegativeInteger(int1);
        int2 = XmlDatatypeUtil.normalizeNonNegativeInteger(int2);
        return XmlDatatypeUtil.compareCanonicalIntegers(int1, int2);
    }

    public static int comparePositiveIntegers(String int1, String int2) {
        int1 = XmlDatatypeUtil.normalizePositiveInteger(int1);
        int2 = XmlDatatypeUtil.normalizePositiveInteger(int2);
        return XmlDatatypeUtil.compareCanonicalIntegers(int1, int2);
    }

    public static int compareLongs(String int1, String int2) {
        int1 = XmlDatatypeUtil.normalizeLong(int1);
        int2 = XmlDatatypeUtil.normalizeLong(int2);
        return XmlDatatypeUtil.compareCanonicalIntegers(int1, int2);
    }

    public static int compareInts(String int1, String int2) {
        int1 = XmlDatatypeUtil.normalizeInt(int1);
        int2 = XmlDatatypeUtil.normalizeInt(int2);
        return XmlDatatypeUtil.compareCanonicalIntegers(int1, int2);
    }

    public static int compareShorts(String int1, String int2) {
        int1 = XmlDatatypeUtil.normalizeShort(int1);
        int2 = XmlDatatypeUtil.normalizeShort(int2);
        return XmlDatatypeUtil.compareCanonicalIntegers(int1, int2);
    }

    public static int compareBytes(String int1, String int2) {
        int1 = XmlDatatypeUtil.normalizeByte(int1);
        int2 = XmlDatatypeUtil.normalizeByte(int2);
        return XmlDatatypeUtil.compareCanonicalIntegers(int1, int2);
    }

    public static int compareUnsignedLongs(String int1, String int2) {
        int1 = XmlDatatypeUtil.normalizeUnsignedLong(int1);
        int2 = XmlDatatypeUtil.normalizeUnsignedLong(int2);
        return XmlDatatypeUtil.compareCanonicalIntegers(int1, int2);
    }

    public static int compareUnsignedInts(String int1, String int2) {
        int1 = XmlDatatypeUtil.normalizeUnsignedInt(int1);
        int2 = XmlDatatypeUtil.normalizeUnsignedInt(int2);
        return XmlDatatypeUtil.compareCanonicalIntegers(int1, int2);
    }

    public static int compareUnsignedShorts(String int1, String int2) {
        int1 = XmlDatatypeUtil.normalizeUnsignedShort(int1);
        int2 = XmlDatatypeUtil.normalizeUnsignedShort(int2);
        return XmlDatatypeUtil.compareCanonicalIntegers(int1, int2);
    }

    public static int compareUnsignedBytes(String int1, String int2) {
        int1 = XmlDatatypeUtil.normalizeUnsignedByte(int1);
        int2 = XmlDatatypeUtil.normalizeUnsignedByte(int2);
        return XmlDatatypeUtil.compareCanonicalIntegers(int1, int2);
    }

    public static int compareFloats(String float1, String float2) {
        float1 = XmlDatatypeUtil.normalizeFloat(float1);
        float2 = XmlDatatypeUtil.normalizeFloat(float2);
        return XmlDatatypeUtil.compareCanonicalFloats(float1, float2);
    }

    public static int compareCanonicalFloats(String float1, String float2) {
        return XmlDatatypeUtil.compareCanonicalFPNumbers(float1, float2);
    }

    public static int compareDoubles(String double1, String double2) {
        double1 = XmlDatatypeUtil.normalizeDouble(double1);
        double2 = XmlDatatypeUtil.normalizeDouble(double2);
        return XmlDatatypeUtil.compareCanonicalDoubles(double1, double2);
    }

    public static int compareCanonicalDoubles(String double1, String double2) {
        return XmlDatatypeUtil.compareCanonicalFPNumbers(double1, double2);
    }

    public static int compareFPNumbers(String fp1, String fp2) {
        fp1 = XmlDatatypeUtil.normalizeFPNumber(fp1);
        fp2 = XmlDatatypeUtil.normalizeFPNumber(fp2);
        return XmlDatatypeUtil.compareCanonicalFPNumbers(fp1, fp2);
    }

    public static int compareCanonicalFPNumbers(String float1, String float2) {
        if (float1.equals("NaN") || float2.equals("NaN")) {
            if (float1.equals(float2)) {
                return 0;
            }
            XmlDatatypeUtil._throwIAE("NaN cannot be compared to other floats");
        }
        if (float1.equals("INF")) {
            return float2.equals("INF") ? 0 : 1;
        }
        if (float2.equals("INF")) {
            return -1;
        }
        if (float1.equals("-INF")) {
            return float2.equals("-INF") ? 0 : -1;
        }
        if (float2.equals("-INF")) {
            return 1;
        }
        if (float1.charAt(0) == '-' && float2.charAt(0) != '-') {
            return -1;
        }
        if (float2.charAt(0) == '-' && float1.charAt(0) != '-') {
            return 1;
        }
        int eIdx1 = float1.indexOf(69);
        String mantissa1 = float1.substring(0, eIdx1);
        String exponent1 = float1.substring(eIdx1 + 1);
        int eIdx2 = float2.indexOf(69);
        String mantissa2 = float2.substring(0, eIdx2);
        String exponent2 = float2.substring(eIdx2 + 1);
        int result = XmlDatatypeUtil.compareCanonicalIntegers(exponent1, exponent2);
        if (result != 0 && float1.charAt(0) == '-') {
            result = -result;
        }
        if (result == 0) {
            result = XmlDatatypeUtil.compareCanonicalDecimals(mantissa1, mantissa2);
        }
        return result;
    }

    public static int compareDateTime(String value1, String value2) {
        DateTime dateTime1 = new DateTime(value1);
        DateTime dateTime2 = new DateTime(value2);
        dateTime1.normalize();
        dateTime2.normalize();
        return dateTime1.compareTo(dateTime2);
    }

    private static final boolean _isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private static final void _throwIAE(String msg) {
        throw new IllegalArgumentException(msg);
    }
}

