/*
 * Decompiled with CFR 0.152.
 */
package org.phyloref.jphyloref.commands;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.eclipse.rdf4j.rio.RDFParser;
import org.phyloref.jphyloref.commands.Command;
import org.phyloref.jphyloref.helpers.JSONLDHelper;
import org.phyloref.jphyloref.helpers.OWLHelper;
import org.phyloref.jphyloref.helpers.PhylorefHelper;
import org.phyloref.jphyloref.helpers.ReasonerHelper;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.OWLReasonerFactory;
import org.semanticweb.owlapi.util.AutoIRIMapper;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tap4j.model.Comment;
import org.tap4j.model.Directive;
import org.tap4j.model.Plan;
import org.tap4j.model.TestResult;
import org.tap4j.model.TestSet;
import org.tap4j.producer.TapProducer;
import org.tap4j.producer.TapProducerFactory;
import org.tap4j.util.DirectiveValues;
import org.tap4j.util.StatusValues;

public class TestCommand
implements Command {
    private static final Logger logger = LoggerFactory.getLogger(TestCommand.class);

    @Override
    public String getName() {
        return "test";
    }

    @Override
    public String getDescription() {
        return "Test the phyloreferences in the provided ontology to determine if they resolved correctly.";
    }

    @Override
    public void addCommandLineOptions(Options opts) {
        opts.addOption("i", "input", true, "The input ontology to read in RDF/XML or JSON-LD (can also be provided without the '-i').");
        opts.addOption("j", "jsonld", false, "Treat the input file as a JSON-LD file. Files with a '.json' or '.jsonld' extension will automatically be treated as a JSON-LD file.");
    }

    @Override
    public int execute(CommandLine cmdLine) throws RuntimeException {
        OWLOntology ontology;
        String inputFilename = cmdLine.getOptionValue("input");
        if (inputFilename == null && cmdLine.getArgList().size() > 1) {
            inputFilename = cmdLine.getArgList().get(1);
        }
        if (inputFilename == null) {
            throw new IllegalArgumentException("Error: no input ontology specified (use '-i input.owl')");
        }
        InputStream inputStreamToReadFrom = null;
        if (inputFilename.equals("-")) {
            inputStreamToReadFrom = System.in;
        } else {
            try {
                inputStreamToReadFrom = new FileInputStream(inputFilename);
            }
            catch (FileNotFoundException ex) {
                logger.error("Could not open input file '{}': {}", (Object)inputFilename, (Object)ex);
                return 1;
            }
        }
        logger.info("Input: {}", (Object)inputFilename);
        OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
        AutoIRIMapper mapper = new AutoIRIMapper(new File("ontologies"), true);
        logger.info("Found local ontologies: {}", (Object)mapper.getOntologyIRIs());
        manager.addIRIMapper(mapper);
        String inputFileLowercase = inputFilename.toLowerCase();
        String defaultURIPrefix = null;
        try {
            if (cmdLine.hasOption("jsonld") || inputFileLowercase.endsWith(".json") || inputFileLowercase.endsWith(".jsonld")) {
                ontology = manager.createOntology();
                RDFParser parser = JSONLDHelper.createRDFParserForOntology(ontology);
                defaultURIPrefix = "http://example.org/jphyloref";
                parser.parse(inputStreamToReadFrom, defaultURIPrefix);
            } else {
                ontology = manager.loadOntologyFromOntologyDocument(inputStreamToReadFrom);
            }
        }
        catch (OWLOntologyCreationException ex) {
            logger.error("Could not create ontology '{}': {}", (Object)inputFilename, (Object)ex);
            return 1;
        }
        catch (IOException ex) {
            logger.error("Could not read and load ontology '{}': {}", (Object)inputFilename, (Object)ex);
            return 1;
        }
        logger.info("Loaded ontology: {}", (Object)ontology);
        OWLReasonerFactory reasonerFactory = ReasonerHelper.getReasonerFactoryFromCmdLine(cmdLine);
        OWLReasoner reasoner = null;
        if (reasonerFactory != null) {
            reasoner = reasonerFactory.createReasoner(ontology);
        }
        Set<OWLClass> phylorefs = PhylorefHelper.getPhyloreferences(ontology, reasoner);
        logger.info("Phyloreferences identified: {}", (Object)phylorefs);
        TapProducer tapProducer = TapProducerFactory.makeTap13Producer();
        TestSet testSet = new TestSet();
        testSet.setPlan(new Plan(phylorefs.size()));
        testSet.addComment(new Comment("From file: " + inputFilename));
        testSet.addComment(new Comment("Using reasoner: " + ReasonerHelper.getReasonerNameAndVersion(ReasonerHelper.getReasonerFactoryFromCmdLine(cmdLine))));
        OWLDataFactory dataFactory = manager.getOWLDataFactory();
        OWLClass classCDAONode = dataFactory.getOWLClass(PhylorefHelper.IRI_CDAO_NODE);
        OWLAnnotationProperty labelAnnotationProperty = dataFactory.getOWLAnnotationProperty(OWLRDFVocabulary.RDFS_LABEL.getIRI());
        int testNumber = 0;
        int countSuccess = 0;
        int countFailure = 0;
        int countTODO = 0;
        int countSkipped = 0;
        for (OWLClass phyloref : phylorefs) {
            TestResult result = new TestResult();
            result.setTestNumber(++testNumber);
            boolean testFailed = false;
            Optional opt_phylorefLabel = OWLHelper.getAnnotationLiteralsForEntity(ontology, phyloref, labelAnnotationProperty, Arrays.asList("en")).stream().findFirst();
            String phylorefLabel = opt_phylorefLabel.isPresent() ? (String)opt_phylorefLabel.get() : phyloref.getIRI().toString();
            result.setDescription("Phyloreference '" + phylorefLabel + "'");
            List<PhylorefHelper.PhylorefStatus> statuses = PhylorefHelper.getStatusesForPhyloref(phyloref, ontology);
            boolean flag_expected_to_resolve = false;
            List activeStatuses = statuses.stream().filter(ps -> ps.getIntervalStart() != null && ps.getIntervalEnd() == null).collect(Collectors.toList());
            flag_expected_to_resolve = activeStatuses.isEmpty() ? true : activeStatuses.stream().anyMatch(ps -> ps.getStatus().equals(PhylorefHelper.IRI_PSO_SUBMITTED) || ps.getStatus().equals(PhylorefHelper.IRI_PSO_PUBLISHED));
            OWLObjectSomeValuesFrom expectedNodesExpr = dataFactory.getOWLObjectSomeValuesFrom(dataFactory.getOWLObjectProperty(PhylorefHelper.IRI_OBI_IS_SPECIFIED_OUTPUT_OF), dataFactory.getOWLObjectSomeValuesFrom(dataFactory.getOWLObjectProperty(PhylorefHelper.IRI_OBI_HAS_SPECIFIED_INPUT), phyloref));
            HashSet<OWLNamedIndividual> expectedNodes = new HashSet();
            if (reasoner == null) {
                throw new RuntimeException("Testing without reasoner not yet implemented.");
            }
            expectedNodes = reasoner.getInstances(expectedNodesExpr, false).getFlattened();
            result.addComment(new Comment("Expected nodes: " + this.removeDefaultURIPrefixes(expectedNodes, defaultURIPrefix)));
            Set<OWLNamedIndividual> nodes = PhylorefHelper.getNodesInClass(phyloref, ontology, reasoner);
            if (expectedNodes.isEmpty()) {
                ++countSkipped;
                result.setStatus(StatusValues.NOT_OK);
                result.setDirective(new Directive(DirectiveValues.SKIP, "Phyloreference has no expected resolution, and so cannot be tested."));
                if (nodes.isEmpty()) {
                    result.addComment(new Comment("It did not resolve to any nodes."));
                } else {
                    result.addComment(new Comment("It resolved to the following " + nodes.size() + " nodes: " + nodes));
                }
                testSet.addTapLine(result);
                continue;
            }
            if (nodes.isEmpty()) {
                result.setStatus(StatusValues.NOT_OK);
                result.addComment(new Comment("No nodes matched."));
                testSet.addTapLine(result);
                ++countFailure;
                continue;
            }
            result.addComment(new Comment("Resolved nodes: " + this.removeDefaultURIPrefixes(nodes, defaultURIPrefix)));
            HashSet<OWLNamedIndividual> expectedButNotResolved = new HashSet<OWLNamedIndividual>(expectedNodes);
            expectedButNotResolved.removeAll(nodes);
            HashSet<OWLNamedIndividual> resolvedButNotExpected = new HashSet<OWLNamedIndividual>(nodes);
            resolvedButNotExpected.removeAll(expectedNodes);
            if (expectedButNotResolved.isEmpty() && resolvedButNotExpected.isEmpty()) {
                result.setStatus(StatusValues.OK);
                if (!flag_expected_to_resolve) {
                    result.addComment(new Comment("This phyloref resolved as expected, and should be marked as pso:submitted instead of: " + activeStatuses));
                }
                testSet.addTapLine(result);
                ++countSuccess;
                continue;
            }
            result.setStatus(StatusValues.NOT_OK);
            boolean flagTODO = false;
            if (!flag_expected_to_resolve) {
                result.setDirective(new Directive(DirectiveValues.TODO, "Phyloreference is not expected to resolve as it has a status of " + activeStatuses));
                flagTODO = true;
            }
            if (!resolvedButNotExpected.isEmpty()) {
                result.addComment(new Comment("Some nodes were resolved but were not expected: " + resolvedButNotExpected));
            }
            if (!expectedButNotResolved.isEmpty()) {
                result.addComment(new Comment("Some nodes were expected but were not resolved: " + expectedButNotResolved));
            }
            if (flagTODO) {
                ++countTODO;
            } else {
                ++countFailure;
            }
            testSet.addTapLine(result);
        }
        System.out.println(tapProducer.dump(testSet));
        System.err.println("Testing complete:" + countSuccess + " successes, " + countFailure + " failures, " + countTODO + " failures marked TODO, " + countSkipped + " skipped.");
        reasoner.dispose();
        if (countSuccess == 0) {
            return -1;
        }
        return countFailure;
    }

    private List<String> removeDefaultURIPrefixes(Set<OWLNamedIndividual> indivs, String defaultURIPrefix) {
        if (defaultURIPrefix == null) {
            return indivs.stream().map(indiv -> indiv.getIRI().toString()).collect(Collectors.toList());
        }
        return indivs.stream().map(indiv -> {
            String iriString = indiv.getIRI().toString();
            if (iriString.startsWith(defaultURIPrefix)) {
                return iriString.substring(defaultURIPrefix.length());
            }
            return iriString;
        }).collect(Collectors.toList());
    }
}

