/*
 * Decompiled with CFR 0.152.
 */
package org.phyloref.jphyloref.helpers;

import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFParser;
import org.eclipse.rdf4j.rio.Rio;
import org.semanticweb.owlapi.formats.RDFJsonLDDocumentFormat;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.rio.RioOWLRDFConsumerAdapter;
import org.semanticweb.owlapi.util.AnonymousNodeChecker;

public class JSONLDHelper {
    public static RDFParser createRDFParserForOntology(OWLOntology ontology) {
        AnonymousNodeChecker anonymousNodeChecker = new AnonymousNodeChecker(){

            private boolean isAnonymous(String iri) {
                return iri.startsWith("_:");
            }

            @Override
            public boolean isAnonymousSharedNode(String iri) {
                return this.isAnonymous(iri);
            }

            @Override
            public boolean isAnonymousNode(String iri) {
                return this.isAnonymous(iri);
            }

            @Override
            public boolean isAnonymousNode(IRI iri) {
                return this.isAnonymous(iri.toString());
            }
        };
        OWLOntologyLoaderConfiguration config = new OWLOntologyLoaderConfiguration();
        RioOWLRDFConsumerAdapter rdfHandler = new RioOWLRDFConsumerAdapter(ontology, anonymousNodeChecker, config);
        rdfHandler.setOntologyFormat(new RDFJsonLDDocumentFormat());
        RDFParser parser = Rio.createParser(RDFFormat.JSONLD);
        parser.setRDFHandler(rdfHandler);
        return parser;
    }
}

