/*
 * Decompiled with CFR 0.152.
 */
package org.phyloref.jphyloref.helpers;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.search.EntitySearcher;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;

public final class OWLHelper {
    private static OWLAnnotationProperty cache_labelProperty = null;

    public static OWLAnnotationProperty getLabelProperty(OWLOntology ontology) {
        if (cache_labelProperty != null) {
            return cache_labelProperty;
        }
        cache_labelProperty = ontology.getOWLOntologyManager().getOWLDataFactory().getOWLAnnotationProperty(OWLRDFVocabulary.RDFS_LABEL.getIRI());
        return cache_labelProperty;
    }

    public static Set<String> getLabelsInEnglish(OWLNamedIndividual individual, OWLOntology ontology) {
        OWLAnnotationProperty labelProperty = OWLHelper.getLabelProperty(ontology);
        return OWLHelper.getAnnotationLiteralsForEntity(ontology, individual, labelProperty, Arrays.asList("en"));
    }

    public static Set<String> getAnnotationLiteralsForEntity(OWLOntology ontology, OWLEntity entity, OWLAnnotationProperty annotationProperty, List<String> langs) {
        Map<String, Set<String>> valuesByLanguage = OWLHelper.getAnnotationLiteralsForEntity(ontology, entity, annotationProperty);
        for (String lang : langs) {
            if (!valuesByLanguage.containsKey(lang)) continue;
            return valuesByLanguage.get(lang);
        }
        if (valuesByLanguage.containsKey("")) {
            return valuesByLanguage.get("");
        }
        return new HashSet<String>();
    }

    public static Map<String, Set<String>> getAnnotationLiteralsForEntity(OWLOntology ontology, OWLEntity entity, OWLAnnotationProperty annotationProperty) {
        HashMap<String, Set<String>> valuesByLanguage = new HashMap<String, Set<String>>();
        EntitySearcher.getAnnotations(entity, ontology, annotationProperty).stream().filter(annotation -> annotation.getValue() instanceof OWLLiteral).forEach(annotation -> {
            OWLLiteral val = (OWLLiteral)annotation.getValue();
            String lang = val.getLang();
            if (!valuesByLanguage.containsKey(lang)) {
                valuesByLanguage.put(lang, new HashSet());
            }
            ((Set)valuesByLanguage.get(lang)).add(val.getLiteral());
        });
        return valuesByLanguage;
    }
}

