/*
 * Decompiled with CFR 0.152.
 */
package org.phyloref.jphyloref.helpers;

import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.search.EntitySearcher;

public class PhylorefHelper {
    public static final IRI IRI_CDAO_NODE = IRI.create("http://purl.obolibrary.org/obo/CDAO_0000140");
    public static final IRI IRI_PHYLOREFERENCE = IRI.create("http://ontology.phyloref.org/phyloref.owl#Phyloreference");
    public static final IRI IRI_OBI_IS_SPECIFIED_OUTPUT_OF = IRI.create("http://purl.obolibrary.org/obo/OBI_0000312");
    public static final IRI IRI_OBI_HAS_SPECIFIED_INPUT = IRI.create("http://purl.obolibrary.org/obo/OBI_0000293");
    public static final IRI IRI_PSO_HOLDS_STATUS_IN_TIME = IRI.create("http://purl.org/spar/pso/holdsStatusInTime");
    public static final IRI IRI_PSO_WITH_STATUS = IRI.create("http://purl.org/spar/pso/withStatus");
    public static final IRI IRI_TVC_AT_TIME = IRI.create("http://www.essepuntato.it/2012/04/tvc/atTime");
    public static final IRI IRI_TIMEINT_HAS_INTERVAL_START_DATE = IRI.create("http://www.ontologydesignpatterns.org/cp/owl/timeinterval.owl#hasIntervalStartDate");
    public static final IRI IRI_TIMEINT_HAS_INTERVAL_END_DATE = IRI.create("http://www.ontologydesignpatterns.org/cp/owl/timeinterval.owl#hasIntervalEndDate");
    public static final IRI IRI_PSO_DRAFT = IRI.create("http://purl.org/spar/pso/draft");
    public static final IRI IRI_PSO_SUBMITTED = IRI.create("http://purl.org/spar/pso/submitted");
    public static final IRI IRI_PSO_PUBLISHED = IRI.create("http://purl.org/spar/pso/published");

    public static Set<OWLClass> getPhyloreferencesWithoutReasoning(OWLOntology ontology) {
        Set<OWLEntity> set_phyloref_Phyloreference = ontology.getEntitiesInSignature(IRI_PHYLOREFERENCE);
        if (set_phyloref_Phyloreference.isEmpty()) {
            throw new RuntimeException("Class 'phyloref:Phyloreference' is not defined in ontology.");
        }
        if (set_phyloref_Phyloreference.size() > 1) {
            throw new RuntimeException("Class 'phyloref:Phyloreference' is defined multiple times in ontology.");
        }
        OWLClass phyloref_Phyloreference = set_phyloref_Phyloreference.iterator().next().asOWLClass();
        HashSet<OWLClass> phylorefs = new HashSet<OWLClass>();
        Set<OWLSubClassOfAxiom> subClassOfAxioms = ontology.getAxioms(AxiomType.SUBCLASS_OF);
        for (OWLSubClassOfAxiom subClassOfAxiom : subClassOfAxioms) {
            if (!subClassOfAxiom.getSuperClass().equals(phyloref_Phyloreference.asOWLClass())) continue;
            phylorefs.add(subClassOfAxiom.getSubClass().asOWLClass());
        }
        return phylorefs;
    }

    public static Set<OWLClass> getPhyloreferences(OWLOntology ontology, OWLReasoner reasoner) {
        if (reasoner == null) {
            return PhylorefHelper.getPhyloreferencesWithoutReasoning(ontology);
        }
        Set<OWLEntity> set_phyloref_Phyloreference = ontology.getEntitiesInSignature(IRI_PHYLOREFERENCE);
        if (set_phyloref_Phyloreference.isEmpty()) {
            throw new IllegalArgumentException("Class " + IRI_PHYLOREFERENCE + " is not defined in ontology.");
        }
        if (set_phyloref_Phyloreference.size() > 1) {
            throw new IllegalArgumentException("Class " + IRI_PHYLOREFERENCE + " is defined multiple times in ontology.");
        }
        OWLClass phyloref_Phyloreference = set_phyloref_Phyloreference.iterator().next().asOWLClass();
        Set<OWLClass> classes = reasoner.getSubClasses(phyloref_Phyloreference, false).getFlattened();
        Set<OWLClass> bottomNodes = reasoner.getUnsatisfiableClasses().getEntities();
        classes = classes.stream().filter(c -> !bottomNodes.contains(c)).filter(c -> !c.getIRI().toString().startsWith("http://ontology.phyloref.org/phyloref.owl#Phyloreference")).collect(Collectors.toSet());
        return classes;
    }

    public static Set<OWLNamedIndividual> getNodesInClass(OWLClass owlClass, OWLOntology ontology, OWLReasoner reasoner) {
        if (reasoner != null) {
            return reasoner.getInstances(owlClass, false).getFlattened();
        }
        HashSet<OWLNamedIndividual> nodes = new HashSet<OWLNamedIndividual>();
        Set<OWLClassAssertionAxiom> classAssertions = ontology.getAxioms(AxiomType.CLASS_ASSERTION);
        for (OWLClassAssertionAxiom classAssertion : classAssertions) {
            if (!classAssertion.getIndividual().isNamed() || !classAssertion.getClassesInSignature().contains(owlClass)) continue;
            nodes.add(classAssertion.getIndividual().asOWLNamedIndividual());
        }
        return nodes;
    }

    public static List<PhylorefStatus> getStatusesForPhyloref(OWLClass phyloref, OWLOntology ontology) {
        ArrayList<PhylorefStatus> statuses = new ArrayList<PhylorefStatus>();
        OWLDataFactory dataFactory = ontology.getOWLOntologyManager().getOWLDataFactory();
        OWLAnnotationProperty pso_holdsStatusInTime = dataFactory.getOWLAnnotationProperty(IRI_PSO_HOLDS_STATUS_IN_TIME);
        OWLAnnotationProperty pso_withStatus = dataFactory.getOWLAnnotationProperty(IRI_PSO_WITH_STATUS);
        OWLAnnotationProperty tvc_atTime = dataFactory.getOWLAnnotationProperty(IRI_TVC_AT_TIME);
        OWLAnnotationProperty timeinterval_hasIntervalStartDate = dataFactory.getOWLAnnotationProperty(IRI_TIMEINT_HAS_INTERVAL_START_DATE);
        OWLAnnotationProperty timeinterval_hasIntervalEndDate = dataFactory.getOWLAnnotationProperty(IRI_TIMEINT_HAS_INTERVAL_END_DATE);
        Collection<OWLAnnotation> holdsStatusInTime = EntitySearcher.getAnnotations((OWLEntity)phyloref, ontology, pso_holdsStatusInTime);
        for (OWLAnnotation statusInTime : holdsStatusInTime) {
            IRI phylorefStatusIRI = null;
            Instant intervalStartDate = null;
            Instant intervalEndDate = null;
            for (OWLAnonymousIndividual indiv_statusInTime : statusInTime.getAnonymousIndividuals()) {
                for (OWLAnnotationAssertionAxiom axiom : ontology.getAnnotationAssertionAxioms(indiv_statusInTime)) {
                    if (axiom.getProperty().equals(tvc_atTime)) {
                        for (OWLAnonymousIndividual indiv_atTime : axiom.getValue().getAnonymousIndividuals()) {
                            for (OWLAnnotationAssertionAxiom axiom_interval : ontology.getAnnotationAssertionAxioms(indiv_atTime)) {
                                if (axiom_interval.getProperty().equals(timeinterval_hasIntervalStartDate)) {
                                    try {
                                        intervalStartDate = ZonedDateTime.parse(axiom_interval.getValue().asLiteral().get().getLiteral()).toInstant();
                                    }
                                    catch (DateTimeParseException ex) {
                                        intervalStartDate = Instant.MIN;
                                    }
                                }
                                if (!axiom_interval.getProperty().equals(timeinterval_hasIntervalEndDate)) continue;
                                try {
                                    intervalEndDate = ZonedDateTime.parse(axiom_interval.getValue().asLiteral().get().getLiteral()).toInstant();
                                }
                                catch (DateTimeParseException ex) {
                                    intervalEndDate = Instant.MAX;
                                }
                            }
                        }
                        continue;
                    }
                    if (axiom.getProperty().equals(pso_withStatus)) {
                        phylorefStatusIRI = (IRI)axiom.getValue();
                        continue;
                    }
                    throw new IllegalArgumentException("Phyloreference " + phyloref + " contains an unknown axiom: " + axiom);
                }
            }
            statuses.add(new PhylorefStatus(phyloref, phylorefStatusIRI, intervalStartDate, intervalEndDate));
        }
        return statuses;
    }

    public static class PhylorefStatus {
        private OWLClass phyloref;
        private IRI statusIRI;
        private Instant intervalStart;
        private Instant intervalEnd;

        public PhylorefStatus(OWLClass phyloref, IRI status, Instant intervalStart, Instant intervalEnd) {
            this.phyloref = phyloref;
            this.statusIRI = status;
            this.intervalStart = intervalStart;
            this.intervalEnd = intervalEnd;
            if (status == null) {
                throw new IllegalArgumentException("No status provided to PhylorefStatus, which is a required argument");
            }
        }

        public OWLClass getPhyloref() {
            return this.phyloref;
        }

        public IRI getStatus() {
            return this.statusIRI;
        }

        public Instant getIntervalStart() {
            return this.intervalStart;
        }

        public Instant getIntervalEnd() {
            return this.intervalEnd;
        }

        public String toString() {
            StringBuffer statusString = new StringBuffer("phyloreference status " + this.statusIRI);
            if (this.getIntervalStart() != null) {
                statusString.append(" starting at " + this.getIntervalStart().toString());
            }
            if (this.getIntervalEnd() != null) {
                statusString.append(" ending at " + this.getIntervalEnd().toString());
            }
            return statusString.toString();
        }
    }
}

