/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.owlapi;

import java.util.HashSet;
import java.util.Set;
import org.semanticweb.elk.owl.exceptions.ElkException;
import org.semanticweb.elk.owl.exceptions.ElkRuntimeException;
import org.semanticweb.elk.owl.interfaces.ElkClass;
import org.semanticweb.elk.owl.interfaces.ElkNamedIndividual;
import org.semanticweb.elk.owlapi.ElkEntityConverter;
import org.semanticweb.elk.owlapi.ElkExceptionConverter;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.reasoner.Node;
import org.semanticweb.owlapi.reasoner.impl.OWLClassNode;
import org.semanticweb.owlapi.reasoner.impl.OWLClassNodeSet;
import org.semanticweb.owlapi.reasoner.impl.OWLNamedIndividualNode;
import org.semanticweb.owlapi.reasoner.impl.OWLNamedIndividualNodeSet;

public class ElkConverter {
    private static ElkConverter INSTANCE_ = new ElkConverter();
    protected static ElkEntityConverter ELK_ENTITY_CONVERTER = ElkEntityConverter.getInstance();
    protected static ElkExceptionConverter ELK_EXCEPTION_CONVERTER = ElkExceptionConverter.getInstance();

    private ElkConverter() {
    }

    public static ElkConverter getInstance() {
        return INSTANCE_;
    }

    public OWLClass convert(ElkClass cls) {
        return ELK_ENTITY_CONVERTER.visit(cls);
    }

    public OWLNamedIndividual convert(ElkNamedIndividual ind) {
        return ELK_ENTITY_CONVERTER.visit(ind);
    }

    public OWLClassNode convertClassNode(org.semanticweb.elk.reasoner.taxonomy.model.Node<ElkClass> node) {
        HashSet<OWLClass> owlClasses = new HashSet<OWLClass>();
        for (ElkClass cls : node.getMembers()) {
            owlClasses.add(this.convert(cls));
        }
        return new OWLClassNode((Set<OWLClass>)owlClasses);
    }

    public OWLClassNodeSet convertClassNodes(Iterable<? extends org.semanticweb.elk.reasoner.taxonomy.model.Node<ElkClass>> nodes) {
        HashSet<Node<OWLClass>> owlNodes = new HashSet<Node<OWLClass>>();
        for (org.semanticweb.elk.reasoner.taxonomy.model.Node<ElkClass> node : nodes) {
            owlNodes.add(this.convertClassNode(node));
        }
        return new OWLClassNodeSet((Set<Node<OWLClass>>)owlNodes);
    }

    public OWLNamedIndividualNode convertIndividualNode(org.semanticweb.elk.reasoner.taxonomy.model.Node<ElkNamedIndividual> node) {
        HashSet<OWLNamedIndividual> owlIndividuals = new HashSet<OWLNamedIndividual>();
        for (ElkNamedIndividual ind : node.getMembers()) {
            owlIndividuals.add(this.convert(ind));
        }
        return new OWLNamedIndividualNode((Set<OWLNamedIndividual>)owlIndividuals);
    }

    public OWLNamedIndividualNodeSet convertIndividualNodes(Iterable<? extends org.semanticweb.elk.reasoner.taxonomy.model.Node<ElkNamedIndividual>> nodes) {
        HashSet<Node<OWLNamedIndividual>> owlNodes = new HashSet<Node<OWLNamedIndividual>>();
        for (org.semanticweb.elk.reasoner.taxonomy.model.Node<ElkNamedIndividual> node : nodes) {
            owlNodes.add(this.convertIndividualNode(node));
        }
        return new OWLNamedIndividualNodeSet((Set<Node<OWLNamedIndividual>>)owlNodes);
    }

    public OWLRuntimeException convert(ElkException e) {
        return ELK_EXCEPTION_CONVERTER.convert(e);
    }

    public OWLRuntimeException convert(ElkRuntimeException e) {
        return ELK_EXCEPTION_CONVERTER.convert(e);
    }
}

