/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.owlapi;

import org.apache.log4j.Logger;
import org.semanticweb.elk.loading.ElkLoadingException;
import org.semanticweb.elk.owl.interfaces.ElkAxiom;
import org.semanticweb.elk.owl.visitors.ElkAxiomProcessor;
import org.semanticweb.elk.owlapi.wrapper.OwlConverter;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.AddImport;
import org.semanticweb.owlapi.model.AddOntologyAnnotation;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeVisitorEx;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.model.RemoveImport;
import org.semanticweb.owlapi.model.RemoveOntologyAnnotation;
import org.semanticweb.owlapi.model.SetOntologyID;

class OwlOntologyChangeProcessorVisitor
implements OWLOntologyChangeVisitorEx<ElkLoadingException> {
    private static final Logger LOGGER_ = Logger.getLogger(OwlOntologyChangeProcessorVisitor.class);
    private static final OwlConverter OWL_CONVERTER_ = OwlConverter.getInstance();
    private final ElkAxiomProcessor axiomInserter_;
    private final ElkAxiomProcessor axiomDeleter_;

    OwlOntologyChangeProcessorVisitor(ElkAxiomProcessor axiomInserter, ElkAxiomProcessor axiomDeleter) {
        this.axiomInserter_ = axiomInserter;
        this.axiomDeleter_ = axiomDeleter;
    }

    protected static ElkLoadingException defaultVisit(OWLOntologyChange change) {
        return new ElkLoadingException("Ontology change " + change.toString() + " is not supported");
    }

    @Override
    public ElkLoadingException visit(RemoveAxiom arg) {
        ElkAxiom elkAxiom = OWL_CONVERTER_.convert(arg.getAxiom());
        this.axiomDeleter_.visit(elkAxiom);
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace("removing " + arg.getAxiom());
        }
        return null;
    }

    @Override
    public ElkLoadingException visit(AddAxiom arg) {
        ElkAxiom elkAxiom = OWL_CONVERTER_.convert(arg.getAxiom());
        this.axiomInserter_.visit(elkAxiom);
        if (LOGGER_.isTraceEnabled()) {
            LOGGER_.trace("adding " + arg.getAxiom());
        }
        return null;
    }

    @Override
    public ElkLoadingException visit(SetOntologyID change) {
        return OwlOntologyChangeProcessorVisitor.defaultVisit(change);
    }

    @Override
    public ElkLoadingException visit(AddImport change) {
        return OwlOntologyChangeProcessorVisitor.defaultVisit(change);
    }

    @Override
    public ElkLoadingException visit(RemoveImport change) {
        return OwlOntologyChangeProcessorVisitor.defaultVisit(change);
    }

    @Override
    public ElkLoadingException visit(AddOntologyAnnotation change) {
        return OwlOntologyChangeProcessorVisitor.defaultVisit(change);
    }

    @Override
    public ElkLoadingException visit(RemoveOntologyAnnotation change) {
        return OwlOntologyChangeProcessorVisitor.defaultVisit(change);
    }
}

