/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.indexing.hierarchy;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.semanticweb.elk.owl.interfaces.ElkAxiom;
import org.semanticweb.elk.owl.printers.OwlFunctionalStylePrinter;
import org.semanticweb.elk.owl.visitors.ElkAxiomProcessor;
import org.semanticweb.elk.reasoner.indexing.hierarchy.ElkAxiomIndexingVisitor;
import org.semanticweb.elk.reasoner.indexing.hierarchy.ElkIndexingUnsupportedException;
import org.semanticweb.elk.util.logging.ElkMessage;

public class ChangeIndexingProcessor
implements ElkAxiomProcessor {
    private static final Logger LOGGER_ = Logger.getLogger(ChangeIndexingProcessor.class);
    private final ElkAxiomIndexingVisitor indexer_;

    public ChangeIndexingProcessor(ElkAxiomIndexingVisitor indexer) {
        this.indexer_ = indexer;
    }

    @Override
    public void visit(ElkAxiom elkAxiom) {
        block3: {
            try {
                elkAxiom.accept(this.indexer_);
                if (LOGGER_.isTraceEnabled()) {
                    LOGGER_.trace("indexing " + OwlFunctionalStylePrinter.toString(elkAxiom) + " for " + (this.indexer_.getMultiplicity() == 1 ? "addition" : "deletion"));
                }
            }
            catch (ElkIndexingUnsupportedException e) {
                if (!LOGGER_.isEnabledFor(Level.WARN)) break block3;
                LOGGER_.warn(ElkMessage.serialize("reasoner.indexing.axiomIgnored", e.getMessage() + " Axiom ignored:\n" + OwlFunctionalStylePrinter.toString(elkAxiom)));
            }
        }
    }
}

