/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.reasoner.indexing.hierarchy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.apache.log4j.Logger;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedClassExpression;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedObjectProperty;
import org.semanticweb.elk.reasoner.indexing.hierarchy.IndexedPropertyChain;
import org.semanticweb.elk.reasoner.indexing.hierarchy.ModifiableOntologyIndex;
import org.semanticweb.elk.reasoner.indexing.visitors.IndexedClassExpressionVisitor;
import org.semanticweb.elk.reasoner.indexing.visitors.IndexedObjectSomeValuesFromVisitor;
import org.semanticweb.elk.reasoner.saturation.BasicSaturationStateWriter;
import org.semanticweb.elk.reasoner.saturation.conclusions.NegativeSubsumer;
import org.semanticweb.elk.reasoner.saturation.conclusions.Propagation;
import org.semanticweb.elk.reasoner.saturation.context.Context;
import org.semanticweb.elk.reasoner.saturation.rules.ChainableRule;
import org.semanticweb.elk.reasoner.saturation.rules.DecompositionRuleApplicationVisitor;
import org.semanticweb.elk.reasoner.saturation.rules.RuleApplicationVisitor;
import org.semanticweb.elk.util.collections.LazySetIntersection;
import org.semanticweb.elk.util.collections.chains.Chain;
import org.semanticweb.elk.util.collections.chains.Matcher;
import org.semanticweb.elk.util.collections.chains.ModifiableLinkImpl;
import org.semanticweb.elk.util.collections.chains.ReferenceFactory;
import org.semanticweb.elk.util.collections.chains.SimpleTypeBasedMatcher;

public class IndexedObjectSomeValuesFrom
extends IndexedClassExpression {
    protected static final Logger LOGGER_ = Logger.getLogger(IndexedObjectSomeValuesFrom.class);
    protected final IndexedObjectProperty property;
    protected final IndexedClassExpression filler;

    IndexedObjectSomeValuesFrom(IndexedObjectProperty indexedObjectProperty, IndexedClassExpression filler) {
        this.property = indexedObjectProperty;
        this.filler = filler;
    }

    public IndexedObjectProperty getRelation() {
        return this.property;
    }

    public IndexedClassExpression getFiller() {
        return this.filler;
    }

    public <O> O accept(IndexedObjectSomeValuesFromVisitor<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public <O> O accept(IndexedClassExpressionVisitor<O> visitor) {
        return this.accept((IndexedObjectSomeValuesFromVisitor<O>)visitor);
    }

    @Override
    protected void updateOccurrenceNumbers(ModifiableOntologyIndex index, int increment, int positiveIncrement, int negativeIncrement) {
        if (this.negativeOccurrenceNo == 0 && negativeIncrement > 0) {
            index.add(this.filler, new ThisCompositionRule(this));
        }
        this.positiveOccurrenceNo += positiveIncrement;
        this.negativeOccurrenceNo += negativeIncrement;
        if (this.negativeOccurrenceNo == 0 && negativeIncrement < 0) {
            index.remove(this.filler, new ThisCompositionRule(this));
        }
    }

    @Override
    public String toStringStructural() {
        return "ObjectSomeValuesFrom(" + this.property + ' ' + this.filler + ')';
    }

    @Override
    public void accept(DecompositionRuleApplicationVisitor visitor, Context context) {
        visitor.visit(this, context);
    }

    public static void generatePropagations(BasicSaturationStateWriter writer, IndexedPropertyChain property, Context context) {
        for (IndexedClassExpression ice : context.getSubsumers()) {
            ThisCompositionRule rule = (ThisCompositionRule)ice.getCompositionRuleChain().find(ThisCompositionRule.MATCHER_);
            if (rule == null) continue;
            rule.apply(writer, property, context);
        }
    }

    public static class ThisCompositionRule
    extends ModifiableLinkImpl<ChainableRule<Context>>
    implements ChainableRule<Context> {
        private static final String NAME = "ObjectSomeValuesFrom Introduction";
        private final Collection<IndexedObjectSomeValuesFrom> negExistentials_ = new ArrayList<IndexedObjectSomeValuesFrom>(1);
        private static final Matcher<ChainableRule<Context>, ThisCompositionRule> MATCHER_ = new SimpleTypeBasedMatcher<ChainableRule<Context>, ThisCompositionRule>(ThisCompositionRule.class);
        private static final ReferenceFactory<ChainableRule<Context>, ThisCompositionRule> FACTORY_ = new ReferenceFactory<ChainableRule<Context>, ThisCompositionRule>(){

            @Override
            public ThisCompositionRule create(ChainableRule<Context> next) {
                return new ThisCompositionRule(next);
            }
        };

        private ThisCompositionRule(ChainableRule<Context> next) {
            super(next);
        }

        ThisCompositionRule(IndexedObjectSomeValuesFrom negExistential) {
            super(null);
            this.negExistentials_.add(negExistential);
        }

        public Collection<IndexedObjectSomeValuesFrom> getNegativeExistentials() {
            return this.negExistentials_;
        }

        @Override
        public String getName() {
            return NAME;
        }

        @Override
        public void apply(BasicSaturationStateWriter writer, Context context) {
            if (LOGGER_.isTraceEnabled()) {
                LOGGER_.trace("Applying ObjectSomeValuesFrom Introduction to " + context);
            }
            Set<IndexedPropertyChain> candidatePropagationProperties = context.getBackwardLinksByObjectProperty().keySet();
            for (IndexedObjectSomeValuesFrom e : this.negExistentials_) {
                IndexedObjectProperty relation = e.getRelation();
                for (IndexedPropertyChain property : new LazySetIntersection<IndexedPropertyChain>(candidatePropagationProperties, relation.getSaturated().getSubProperties())) {
                    writer.produce(context, new Propagation(property, e));
                }
                if (!relation.getSaturated().isDerivedReflexive()) continue;
                writer.produce(context, new NegativeSubsumer(e));
            }
        }

        @Override
        public boolean addTo(Chain<ChainableRule<Context>> ruleChain) {
            ThisCompositionRule rule = ruleChain.getCreate(MATCHER_, FACTORY_);
            boolean changed = false;
            for (IndexedObjectSomeValuesFrom negExistential : this.negExistentials_) {
                changed |= rule.addNegExistential(negExistential);
            }
            return changed;
        }

        @Override
        public boolean removeFrom(Chain<ChainableRule<Context>> ruleChain) {
            boolean changed = false;
            ThisCompositionRule rule = ruleChain.find(MATCHER_);
            if (rule != null) {
                for (IndexedObjectSomeValuesFrom negExistential : this.negExistentials_) {
                    changed |= rule.removeNegExistential(negExistential);
                }
                if (rule.isEmpty()) {
                    ruleChain.remove(MATCHER_);
                    changed = true;
                }
            }
            return changed;
        }

        @Override
        public void accept(RuleApplicationVisitor visitor, BasicSaturationStateWriter writer, Context context) {
            visitor.visit(this, writer, context);
        }

        private boolean addNegExistential(IndexedObjectSomeValuesFrom existential) {
            return this.negExistentials_.add(existential);
        }

        private boolean removeNegExistential(IndexedObjectSomeValuesFrom existential) {
            return this.negExistentials_.remove(existential);
        }

        private boolean isEmpty() {
            return this.negExistentials_.isEmpty();
        }

        private void apply(BasicSaturationStateWriter writer, IndexedPropertyChain property, Context context) {
            for (IndexedObjectSomeValuesFrom e : this.negExistentials_) {
                if (!e.getRelation().getSaturated().getSubProperties().contains(property)) continue;
                writer.produce(context, new Propagation(property, e));
            }
        }
    }
}

