/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.util.hashing;

import java.util.Iterator;
import java.util.List;
import org.semanticweb.elk.util.hashing.Hasher;

public class HashGenerator {
    private static int counter = 0;

    public static int generateNextHashCode() {
        int h2 = ++counter;
        h2 ^= h2 >>> 20 ^ h2 >>> 12;
        return h2 ^ h2 >>> 7 ^ h2 >>> 4;
    }

    public static int combinedHashCode(Object ... objects) {
        int result = 0;
        for (Object obj : objects) {
            int h2 = obj.hashCode();
            result += h2;
            result += h2 << 10;
            result ^= h2 >> 6;
        }
        result += result << 3;
        result ^= result >> 11;
        result += result << 15;
        return result;
    }

    public static int combinedHashCode(Iterable<?> objects) {
        int result = 0;
        for (Object obj : objects) {
            int h2 = obj.hashCode();
            result += h2;
            result += h2 << 10;
            result ^= h2 >> 6;
        }
        result += result << 3;
        result ^= result >> 11;
        result += result << 15;
        return result;
    }

    public static int combineMultisetHash(boolean finalize, int ... hashes) {
        int hash = 0;
        for (int h2 : hashes) {
            hash += h2;
        }
        if (finalize) {
            hash = HashGenerator.combineListHash(hash);
        }
        return hash;
    }

    public static <T> int combineMultisetHash(boolean finalize, Iterable<? extends T> hashObjects, Hasher<T> hasher) {
        return HashGenerator.combineMultisetHash(finalize, hashObjects.iterator(), hasher);
    }

    public static <T> int combineMultisetHash(boolean finalize, Iterator<? extends T> hashObjectIterator, Hasher<T> hasher) {
        int hash = 0;
        while (hashObjectIterator.hasNext()) {
            hash += hasher.hash(hashObjectIterator.next());
        }
        if (finalize) {
            hash = HashGenerator.combineListHash(hash);
        }
        return hash;
    }

    public static int combineListHash(int ... hashes) {
        int hash = 0;
        for (int h2 : hashes) {
            hash += h2;
            hash += hash << 10;
            hash ^= hash >> 6;
        }
        hash += hash << 3;
        hash ^= hash >> 11;
        hash += hash << 15;
        return hash;
    }

    public static <T> int combineListHash(List<? extends T> hashObjects, Hasher<T> hasher) {
        return HashGenerator.combineListHash(hashObjects.iterator(), hasher);
    }

    public static <T> int combineListHash(Iterator<? extends T> hashObjectIterator, Hasher<T> hasher) {
        int hash = 0;
        while (hashObjectIterator.hasNext()) {
            hash += hasher.hash(hashObjectIterator.next());
            hash += hash << 10;
            hash ^= hash >> 6;
        }
        hash += hash << 3;
        hash ^= hash >> 11;
        hash += hash << 15;
        return hash;
    }
}

