/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.io;

import java.io.InputStream;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.io.ByteOrderMark;
import org.apache.commons.io.input.BOMInputStream;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

public abstract class OWLOntologyDocumentSourceBase
implements OWLOntologyDocumentSource {
    private static final AtomicLong COUNTER = new AtomicLong();
    private String acceptHeaders = null;
    private final OWLDocumentFormat format;
    private final String mimeType;

    @Nonnull
    public static IRI getNextDocumentIRI(String prefix) {
        return IRI.create(prefix + COUNTER.incrementAndGet());
    }

    @Nonnull
    public static InputStream wrap(@Nonnull InputStream delegate) {
        OWLAPIPreconditions.checkNotNull(delegate, "delegate cannot be null");
        return new BOMInputStream(delegate, ByteOrderMark.UTF_8, ByteOrderMark.UTF_16BE, ByteOrderMark.UTF_16LE, ByteOrderMark.UTF_32BE, ByteOrderMark.UTF_32LE);
    }

    public OWLOntologyDocumentSourceBase(@Nullable OWLDocumentFormat format, @Nullable String mime) {
        this.format = format;
        this.mimeType = mime;
    }

    @Override
    public OWLDocumentFormat getFormat() {
        return this.format;
    }

    @Override
    public boolean isFormatKnown() {
        return this.format != null;
    }

    @Override
    public String getMIMEType() {
        return this.mimeType;
    }

    @Override
    public boolean isMIMETypeKnown() {
        return this.mimeType != null && !this.mimeType.isEmpty();
    }

    @Override
    public Optional<String> getAcceptHeaders() {
        return Optional.ofNullable(this.acceptHeaders);
    }

    @Override
    public void setAcceptHeaders(String headers) {
        this.acceptHeaders = headers;
    }
}

