/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSourceBase;
import org.semanticweb.owlapi.io.OWLOntologyInputSourceException;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.tukaani.xz.XZInputStream;

public class XZStreamDocumentSource
extends OWLOntologyDocumentSourceBase {
    @Nonnull
    private final IRI documentIRI;
    private byte[] buffer;

    public XZStreamDocumentSource(@Nonnull InputStream is) {
        this(is, XZStreamDocumentSource.getNextDocumentIRI("xzinputstream:ontology"), null, null);
    }

    public XZStreamDocumentSource(@Nonnull InputStream stream, @Nonnull IRI documentIRI, @Nullable OWLDocumentFormat format, @Nullable String mime) {
        super(format, mime);
        this.documentIRI = documentIRI;
        this.readIntoBuffer(stream);
    }

    private void readIntoBuffer(@Nonnull InputStream reader) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            int length = 100000;
            byte[] tempBuffer = new byte[length];
            int read = 0;
            do {
                if ((read = reader.read(tempBuffer, 0, length)) <= 0) continue;
                bos.write(tempBuffer, 0, read);
            } while (read > 0);
            this.buffer = bos.toByteArray();
        }
        catch (IOException e) {
            throw new OWLRuntimeException(e);
        }
    }

    @Override
    public boolean isInputStreamAvailable() {
        return this.buffer != null;
    }

    @Override
    public InputStream getInputStream() {
        if (this.buffer == null) {
            throw new OWLOntologyInputSourceException("Stream not found - check that the file is available before calling this method.");
        }
        try {
            return new XZInputStream(new ByteArrayInputStream(this.buffer));
        }
        catch (IOException e) {
            throw new OWLOntologyInputSourceException(e);
        }
    }

    @Override
    public IRI getDocumentIRI() {
        return this.documentIRI;
    }

    @Override
    public Reader getReader() {
        try {
            return new InputStreamReader(XZStreamDocumentSource.wrap(this.getInputStream()), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new OWLOntologyInputSourceException(e);
        }
    }

    @Override
    public boolean isReaderAvailable() {
        return this.isInputStreamAvailable();
    }
}

