/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import com.google.common.base.Optional;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public final class OWLAPIPreconditions {
    private OWLAPIPreconditions() {
    }

    @Nonnull
    public static <T> T verifyNotNull(T object) {
        return OWLAPIPreconditions.verifyNotNull(object, "value cannot be null at this stage");
    }

    @Nonnull
    public static <T> T verifyNotNull(T object, @Nonnull String message) {
        if (object == null) {
            throw new IllegalStateException(message);
        }
        return object;
    }

    @Nonnull
    public static <T> T checkNotNull(T object) {
        return OWLAPIPreconditions.checkNotNull(object, "this variable cannot be null");
    }

    @Nonnull
    public static <T> T checkNotNull(T object, @Nonnull String message) {
        if (object == null) {
            throw new NullPointerException(message);
        }
        return object;
    }

    public static void checkNotNegative(@Nonnegative long object) {
        OWLAPIPreconditions.checkNotNegative(object, "this variable cannot be negative: " + object);
    }

    public static void checkNotNegative(@Nonnegative long object, @Nonnull String message) {
        if (object < 0L) {
            throw new IllegalArgumentException(message);
        }
    }

    @Nonnull
    public static <T> T checkNotNull(Optional<T> object, @Nonnull String message) {
        if (object == null || !object.isPresent()) {
            throw new IllegalArgumentException(message);
        }
        return OWLAPIPreconditions.verifyNotNull(object.get());
    }
}

